/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.RecurringAnnouncementJobRunner;
import com.wittified.job.RecurringAnnouncementScheduler;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecurringAnnouncementJobRunnerImpl
implements RecurringAnnouncementJobRunner {
    protected final Logger logger = LoggerFactory.getLogger(RecurringAnnouncementJobRunnerImpl.class);
    private final RecurringAnnouncementScheduler recurringAnnouncementScheduler;
    private final NotificationService notificationService;

    public RecurringAnnouncementJobRunnerImpl(RecurringAnnouncementScheduler recurringAnnouncementScheduler, NotificationService notificationService) {
        this.recurringAnnouncementScheduler = recurringAnnouncementScheduler;
        this.notificationService = notificationService;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        this.logger.debug("Running recurring announcement job.... " + new Date());
        Map params = jobRunnerRequest.getJobConfig().getParameters();
        int notificationId = (Integer)((Serializable)params.get("NOTIFICATION_ID"));
        String recurringType = (String)params.get("RECURRING_TYPE");
        Notification notification = this.notificationService.getThisNotification(notificationId);
        this.logger.debug("isActive " + notification.getActive());
        if (!notification.getActive()) {
            this.logger.debug("stopping scheduler...");
            this.recurringAnnouncementScheduler.unscheduleJob(notification);
            return JobRunnerResponse.success();
        }
        this.logger.debug("jobRunnerRequest:: " + jobRunnerRequest);
        this.logger.debug("jobRunnerRequest.getStartTime()----" + jobRunnerRequest.getStartTime());
        System.out.println(this.notificationService.getThisNotification(notificationId));
        if (recurringType.equals("lastDayOfMonthRecurring")) {
            this.logger.debug("Recurring type is lastDayOfMonth");
            Calendar cal = Calendar.getInstance();
            if (cal.get(5) == cal.getActualMaximum(5)) {
                this.logger.debug("Running reset notification for last day of month!!");
                this.notificationService.resetNotification(this.notificationService.getThisNotification(notificationId));
            }
        } else {
            this.logger.debug(String.format("Running reset notification for %s", recurringType));
            this.notificationService.resetNotification(this.notificationService.getThisNotification(notificationId));
        }
        return null;
    }
}

