/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.format;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.wittified.format.Format;
import com.wittified.format.FormatService;
import com.wittified.format.FormattedCacheLoader;
import com.wittified.format.NotificationFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatServiceImpl
implements FormatService,
LifecycleAware {
    private final CacheManager cacheManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private Cache<NotificationFormat, String> theCache;
    private static final Logger logger = LoggerFactory.getLogger(FormatServiceImpl.class);

    public FormatServiceImpl(CacheManager cacheManager, PluginSettingsFactory pluginSettingsFactory) {
        this.cacheManager = cacheManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public List<Format> getFormats() {
        ArrayList<Format> formats = new ArrayList<Format>();
        formats.add(new Format("HTML", 0));
        formats.add(new Format("Mark Down", 1));
        formats.add(new Format("Plain Text", 2));
        return formats;
    }

    @Override
    public String formatThis(int type, String contents) {
        return (String)this.theCache.get((Object)new NotificationFormat(type, contents));
    }

    public void onStart() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting FormatService");
        }
        this.theCache = this.cacheManager.getCache("wittified-announcer-formatted", (CacheLoader)new FormattedCacheLoader(this.pluginSettingsFactory), new CacheSettingsBuilder().flushable().local().maxEntries(50).expireAfterWrite(1L, TimeUnit.HOURS).build());
    }

    public void onStop() {
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping FormatService");
        }
        this.theCache.removeAll();
        this.theCache = null;
    }
}

