/*
 * Decompiled with CFR 0.152.
 */
package com.wittified;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.wittified.ao.Notification;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.rest.NotificationBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.java.ao.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncerHelper {
    private static final Logger logger = LoggerFactory.getLogger(AnnouncerHelper.class);
    private static final FastDateFormat cookieExpireDateFormat = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss zzz", (TimeZone)TimeZone.getTimeZone("GMT"));

    public static int getNumberOfUsers(Notification notification) {
        return notification.getNotificationUsers().length;
    }

    public static int getNumberOfUsersV1(NotificationBean notification) {
        return notification.getNotificationUsers().length;
    }

    public static String getTitle(Notification notification) {
        return notification.getTitle();
    }

    public static int getNumberOfAnonUsers(Notification notification) {
        return notification.getAnonUsers().length;
    }

    public static int getNumberOfAnonUsersV1(NotificationBean notification) {
        return notification.getAnonUsers().length;
    }

    public static String getCookieName(HttpServletRequest request, HttpServletResponse response) {
        return AnnouncerHelper.getCookieName(request);
    }

    public static String escapeEcmaScript(String stringToEscape) {
        return StringEscapeUtils.escapeEcmaScript(stringToEscape);
    }

    public static String getCookieName(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        if (session != null) {
            return session.getId() + "-" + session.getCreationTime();
        }
        return null;
    }

    public static void setCookie(String key, String value, int expires, String path, HttpServletRequest request, HttpServletResponse response) {
        StringBuilder cookieString = new StringBuilder();
        cookieString.append(key + "=" + value + ";");
        if (expires != 0) {
            cookieString.append(" Expires=" + AnnouncerHelper.getExpires(expires) + ";");
        }
        if (path != null) {
            cookieString.append(" path=" + path + ";");
        }
        cookieString.append(" SameSite=Strict;");
        if (request.getScheme().equalsIgnoreCase("https")) {
            cookieString.append(" Secure;");
        }
        logger.debug(key + " value=" + value + " expires=" + expires + " path=" + path);
        logger.debug("cookieString.toString():" + cookieString);
        response.addHeader("Set-Cookie", cookieString.toString());
    }

    private static String getExpires(int maxAge) {
        if (maxAge < 0) {
            return "";
        }
        Calendar expireDate = Calendar.getInstance();
        expireDate.setTime(new Date());
        expireDate.add(13, maxAge);
        return cookieExpireDateFormat.format(expireDate);
    }

    public static String getContentWithWhitelistedTagsOnly(PluginSettingsFactory pluginSettingsFactory, String contents) {
        Safelist safelist = Safelist.relaxed();
        safelist.addProtocols("a", "href", "slack");
        String whiteListTags = (String)pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.html.whitelist.tags");
        logger.debug("whiteListTags: " + whiteListTags);
        if (StringUtils.isNotBlank((String)whiteListTags)) {
            List<String> entries = Arrays.asList(whiteListTags.split("[\\r\\n]+"));
            try {
                logger.debug("------------SUPPORT-4163--------------");
                String[] whiteListedTags = entries.get(0).replaceAll("\\s", "").split("=")[1].split(",");
                logger.debug("whiteListedTags - " + whiteListedTags);
                safelist.addTags(whiteListedTags);
                for (String attr : entries.subList(1, entries.size())) {
                    logger.debug("attr " + attr);
                    String tag = attr.replaceAll("\\s", "").split("=")[0].split("\\.")[0];
                    logger.debug("tag " + tag);
                    String[] attributes = attr.replaceAll("\\s", "").split("=")[1].split(",");
                    logger.debug("attributes " + attributes);
                    safelist.addAttributes(tag, attributes);
                    logger.debug("safelist ", (Object)safelist);
                }
                logger.debug("------------SUPPORT-4163--------------");
            }
            catch (Exception e) {
                logger.debug("------------SUPPORT-4163--------------");
                logger.debug("entries in exception" + entries);
                logger.debug(e.getMessage());
                logger.debug("------------SUPPORT-4163--------------");
            }
        }
        return Jsoup.clean(contents, safelist);
    }

    public static List<NotificationBean> getAllNotifications(List<Notification> notificationList) {
        ArrayList<NotificationBean> notifications = new ArrayList<NotificationBean>();
        if (notificationList == null || notificationList.isEmpty()) {
            return Collections.emptyList();
        }
        for (Notification notification : notificationList) {
            notifications.add(new NotificationBean(notification));
        }
        return notifications;
    }

    public static List<NotificationBean> getAllNotificationsForUser(List<NotificationCacheEntry> notificationList) {
        ArrayList<NotificationBean> notifications = new ArrayList<NotificationBean>();
        if (notificationList == null || notificationList.isEmpty()) {
            return Collections.emptyList();
        }
        for (NotificationCacheEntry notification : notificationList) {
            notifications.add(new NotificationBean(notification));
        }
        return notifications;
    }

    public static Query prepareQuery(String limit, String offset, String active, String filterProject) {
        try {
            Query query = Query.select();
            if (StringUtils.isNotBlank((String)limit) && StringUtils.isNotBlank((String)offset)) {
                int offsetVal = Integer.parseInt(offset);
                if (offsetVal < 0) {
                    offsetVal = 0;
                }
                query = query.limit(Integer.parseInt(limit)).offset(offsetVal);
            }
            if (StringUtils.isNotBlank((String)active)) {
                query = query.where("ACTIVE = ? ", new Object[]{Boolean.parseBoolean(active)});
                if (StringUtils.isNotBlank((String)filterProject)) {
                    query = query.where("ACTIVE = ? AND FILTER_PROJECT = ? AND TARGET_PROJECT = ? ", new Object[]{Boolean.parseBoolean(active), true, ":" + filterProject + ":"});
                }
            }
            query = query.order("ID DESC");
            return query;
        }
        catch (Exception e) {
            logger.debug("Exception while preparing the query", (Throwable)e);
            return null;
        }
    }
}

