if(!window.wittified)
{
	window.wittified = new Object();
}

if (!window.wittified.cookie) {
    console.log("creating a cookie object");
    console.log(window.wittified);
    window.wittified.cookie = new Object();
}

window.wittified.enableAllNotifications = function()
{
    AJS.$.ajax({
        url: AJS.contextPath()+'/rest/announcer/1.0/admin/enable-all',
        dataType: "json",
        contentType: "application/json",
        data: '{"action":"enable-all"}',
        type: 'POST',
        method: 'POST',
        success: function(data, textStatus, jqXHR)
        {
            window.location.reload(false);

        }
    });
}

window.wittified.resetPaginateResults = function(notificationId,startPage,page,endPage){

    AJS.$('#user-filter-status').val("all");
    AJS.$('#user-filter-page-size').val("20");
    AJS.$('#user-filter').val('');
    var searchTerm = AJS.$('#user-filter').val();
    var status = AJS.$('#user-filter-status').val();
    var pageSize = AJS.$('#user-filter-page-size').val();
    var usersPerPage = parseInt(pageSize);

    AJS.$("#notification-report").html('<aui-spinner size="medium"></aui-spinner>');
    AJS.$.ajax({
        url: AJS.contextPath()+'/rest/announcer/1.0/admin/report/'+notificationId+'/'+page,
        contentType: "application/json",
        data:{
            "startPage":startPage,
            "endPage":endPage,
            "status":status,
            "pageSize":usersPerPage,
            "searchTerm":searchTerm
        },
        method: 'GET',
        success: function(data, textStatus, jqXHR)
        {
            AJS.$("#notification-report").html('');
            AJS.$("#notification-report").html(wittified.announcer.soy.pagination.paginate1(
                    {
                        "size":data.size,
                        "notificationId":notificationId,
                        "page":page,
                        "users":data.users,
                        "startPage":data.startPage,
                        "endPage":data.endPage,
                        "contextPath": AJS.contextPath(),
                        "product": window.wittified.appType,
                        "status":status,
                        "pageSize":pageSize,
                        "searchTerm":searchTerm
                    }
                ));
            AJS.$('#user-filter-submit').on('click', function( evt) {
                evt.preventDefault();
                window.wittified.paginateResults(notificationId,1,1,-1);

            });

            AJS.$('#user-filter-reset').on('click', function(evt){
                evt.preventDefault();
                window.wittified.resetPaginateResults(notificationId,1,1,-1);
            });
        }
    });
}

window.wittified.paginateResults = function(notificationId,startPage,page,endPage){

    var status = AJS.$('#user-filter-status').val() ? AJS.$('#user-filter-status').val() : "all";
    var pageSize = AJS.$('#user-filter-page-size').val() ? AJS.$('#user-filter-page-size').val() : "20";
    var usersPerPage = parseInt(pageSize);
    var searchTerm = AJS.$('#user-filter').val() ? AJS.$('#user-filter').val() : "";

    AJS.$("#notification-report").html('<aui-spinner size="medium"></aui-spinner>');

	AJS.$.ajax({
        url: AJS.contextPath()+'/rest/announcer/1.0/admin/report/'+notificationId+'/'+page,
        dataType: "json",
        contentType: "application/json",
        data:{
        	"startPage":startPage,
        	"endPage":endPage,
        	"status":status,
        	"pageSize":usersPerPage,
        	"searchTerm":searchTerm
        },
        type: 'GET',
        method: 'GET',
        success: function(data, textStatus, jqXHR)
        {
            AJS.$("#notification-report").html('');
        	AJS.$("#notification-report").html(wittified.announcer.soy.pagination.paginate1(
        			{
        				"size":data.size,
        				"notificationId":notificationId,
        				"page":page,
        				"users":data.users,
        				"startPage":data.startPage,
        				"endPage":data.endPage,
                        "contextPath": AJS.contextPath(),
                        "product": window.wittified.appType,
                        "status":status,
                        "pageSize":pageSize,
                        "searchTerm":searchTerm
        			}
        		));
        	AJS.$('#user-filter-submit').on('click', function( evt) {
        	    evt.preventDefault();
        	    window.wittified.paginateResults(notificationId,1,1,-1);

        	});

        	AJS.$('#user-filter-reset').on('click', function(evt){
        	    evt.preventDefault();
        	    window.wittified.resetPaginateResults(notificationId,1,1,-1);
        	});
        }
    });
}


window.wittified.report = {

    exportCsv: function(notificationId, currentUserEmail, exportedFilePath) {
        //debugger;
        AJS.$('#wittified-export-button').attr('disabled', 'disabled');
        AJS.$('#announcer-export-msg').html('');
        AJS.$.ajax({
            url: AJS.contextPath() + '/rest/announcer/1.0/admin/report/'+notificationId+'/export-csv',
            method: "GET",
            timeout:0
        }).done(function(data, textStatus, request) {

            var fileName ;
            if(request.getResponseHeader("Content-Disposition")) {
                AJS.$('#wittified-export-button').removeAttr('disabled');
                fileName = request.getResponseHeader("Content-Disposition").split("=")[1];
                wittified.report.downloadCsv(data, fileName);
            } else {
                console.log("job is running");
                AJS.$('#announcer-export-msg').html('');

                var title = AJS.I18n.getText("wittified.announcer.admin.report.banner.title");
                var msg = AJS.I18n.getText("wittified.announcer.admin.report.banner.body", currentUserEmail, exportedFilePath);

                AJS.messages.info("#announcer-export-msg", {

                    title: title,

                    body: msg

                });
              //Check for exportCsv status in case of export of csv in job
                setTimeout(window.wittified.report.checkExportProgress, 10000, notificationId);
            }

        }).fail(function(xhr) {
            AJS.$('#wittified-export-button').removeAttr('disabled');
            console.log('error', xhr);
        });
    },
    downloadCsv: function(csv, fileName) {
        var csvFile = new Blob([csv], {type: "text/csv"}); // CSV FILE
        var downloadLink = document.createElement("a"); // Download link
        downloadLink.download = fileName;  // File name
        downloadLink.href = window.URL.createObjectURL(csvFile);  // We have to create a link to the file
        downloadLink.style.display = "none"; // Make sure that the link is not displayed
        document.body.appendChild(downloadLink); // Add the link to your DOM
        downloadLink.click();
    },

    checkExportProgress: function(notificationId) {

        AJS.$.ajax({
            url: AJS.contextPath() + '/rest/announcer/1.0/admin/report/'+notificationId+'/export-csv/status',
            method: "GET",
            timeout:0
        }).done(function(data, textStatus, request) {
            if(data.isExportCsv) {
                AJS.$('#wittified-export-button').attr('disabled', 'disabled');
                AJS.$("#announcer-export-msg").css('display','block');
                setTimeout(window.wittified.report.checkExportProgress, 10000, notificationId);
            } else {
                AJS.$('#wittified-export-button').removeAttr('disabled');
                AJS.$('#announcer-export-msg').html('');
            }

        }).fail(function(xhr) {
            AJS.$('#wittified-export-button').removeAttr('disabled');
            console.log('error', xhr);
        });
    }
}

window.wittified.parseUserDetails= function (name, id, displayName, email, avatarUrl) {

    AJS.$('#inline-dialog-'+name)
    .html("")
    .append('<div class="aui-inline-dialog-contents" id="aui-inline-dialog-' + id + '"></div>');

    AJS.$("#aui-inline-dialog-" + id).html('')
    .append('<img src="'+ avatarUrl +'" width="32" height="32">')
    .append('<div id="fullName"></div>')
    .append('<div id="email"></div>')
    AJS.$("#aui-inline-dialog-" + id + " #fullName").text(displayName);
    AJS.$("#aui-inline-dialog-" + id + ' #email').text(email);
}

window.wittified.getBitbucketUserDetails = function (username) {
    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/api/1.0/users/' + username,
        dataType: "json",
        contentType: "application/json",
        type: 'GET',
        method: 'GET',
        success: function (data, textStatus, jqXHR) {

            console.log(data);

            var avatarUrls = AJS.contextPath()+'/users/'+data.name+'/avatar.png?s=32';

            window.wittified.parseUserDetails(data.name, data.id, data.displayName, data.emailAddress, avatarUrls);
        }
    });

}

window.wittified.getJiraUserDetails = function (username) {
    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/api/2/user?username=' + username,
        dataType: "json",
        contentType: "application/json",
        type: 'GET',
        method: 'GET',
        success: function (data, textStatus, jqXHR) {

            console.log(data);

            window.wittified.parseUserDetails(data.name, data.key, data.displayName, data.emailAddress,  data.avatarUrls['32x32']);

        }
    });

}

window.wittified.getConfluenceUserDetails = function (username) {
    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/prototype/1/user/non-system/' + username,
        // Hopefully by the time the above one stops working you can try using the below one; Expandable
        // details (which has username, displayName, email)  for user REST api is currently honored only
        // on cloud, expandable details for server is not yet implemented at the time of implementing this feature.
        // url: AJS.contextPath()+'/rest/api/user?username='+username+'&expand=details.personal,details.business',
        dataType: "json",
        contentType: "application/json",
        type: 'GET',
        method: 'GET',
        success: function (data, textStatus, jqXHR) {

            window.wittified.parseUserDetails(data.name, data.userKey, data.displayableEmail, data.avatarUrl);

        }
    });

}

window.wittified.fetchViewedContents = function (notificationId) {
    AJS.$.get(AJS.contextPath() + '/plugins/servlet/wittified/admin/notification/user-list?notification=' + notificationId, function (a) {
        AJS.$('#notification-view-list-' + notificationId).html(a);
    });
}

window.wittified.prepareViewOfContents = function () {
    AJS.InlineDialog(AJS.$(".view-viewed-contents"), 'view-contents-notification',
        function (content, trigger, showPopup) {
            var id = trigger.id.substring('notification-view-link-'.length, trigger.id.length);
            content.css({"padding": "20px"}).html('<div class="wittified-view-contents" id="notification-view-list-' + id + '">&nbsp</div');
            showPopup();

            window.wittified.fetchViewedContents(id);
            return false, {
                'width': 200

};
    }
);

}

wittified_announcer_cancelDialog = function(){
	AJS.dialog2('#announcer-dialog-delete').remove();
}

window.wittified.deleteItem = function(id,title)
{
  	AJS.dialog2(wittified.announcer.soy.dialog.deleteConfirmation({"id":id, "title":title})).show();
}

wittified_announcer_delete= function(id)
{
	AJS.$.ajax({
		url: AJS.contextPath()+'/rest/announcer/1.0/admin/delete/'+id,
		dataType: "json",
		contentType: "application/json",
		data: '{"delete":"'+id+'"}',
		type: 'POST',
		method: 'POST',
		success: function(data, textStatus, jqXHR)
		{
		window.location.reload(true);

		}
	});
}



window.wittified.editDialog = false;

wittified.assembleTargetGroups = function(selected, group)
{
	//reset sleect2
	AJS.$("#targetGroup").select2("val", "");
	window.wittified.pickers.hookGroupPicker();
}

wittified.assembleTargetCategories = function(selected)
{
	//reset sleect2
	AJS.$("#targetCategory").select2("val", "");
	window.wittified.pickers.hookCategoryPicker();
}
wittified.assembleTargetProjectRoles = function(selected) {
    AJS.$('#targetProjectRole').select2("val", "");
    window.wittified.pickers.hookProjectRolePicker();
}

wittified.displayTargetProjectRoles = function() {
	AJS.$('#filterProject-picker').toggleClass('displayContents');
	if(AJS.params.JiraVersion) {
		AJS.$('#filterProjectRole-container').toggleClass('displayContents');
	}
}

window.wittified.assembleTargetProjects = function( selected)
{
    var selected = selected+'';
    var selectedVal = '';
    AJS.$.each(selected.split(','),function(index,value){
        selectedVal = selectedVal+ ':'+value+':';
    });
    AJS.$('#targetProject').val(selectedVal);
}

window.wittified.showOrHideAdvancedEdit = function(product, shouldFilterProject)
{
	AJS.$('#wittified-advanced-edit').toggleClass('hide-advanced');
    if( AJS.$('#wittified-advanced-edit').hasClass('hide-advanced'))
    {
        AJS.$('#wittified-advanced-edit-button').html('Show advanced options...');
    }
    else
    {
        AJS.$('#wittified-advanced-edit-button').html('Hide advanced options');
    }
}

window.wittified.saveGlobalConfig = function(domId, name, value)
{
    AJS.$("#"+ domId).html('<span>&nbsp;</span>');

    AJS.$.ajax({
            url: AJS.contextPath()+'/rest/announcer/1.0/global-config/'+name,
        dataType: "json",
        contentType: "application/json",
            data: JSON.stringify({'value': value+''}),
            type: 'POST',
            method: 'POST',
            success: function(data, textStatus, jqXHR)
            {
                AJS.$("#"+ domId).html('&nbsp;<span class="aui-lozenge aui-lozenge-success">Saved</span>');

            },
            error: function(XMLHttpRequest, textStatus, errorThrown){
                AJS.$("#"+ domId).html('&nbsp;<span class="aui-lozenge aui-lozenge-error">Failed</span>');
                }
            });
}

window.wittified.globalConfigDialog = false;
window.wittified.displayGlobalConfig = function()
{
    if(! window.wittified.globalConfigDialog)
    {
    window.wittified.globalConfigDialog = new AJS.Dialog({
                                                width: 800,
                                                height: 600,
                                                id: "wittified-global-conf-dialog",
                                                closeOnOutsideClick: false
                                            });
        window.wittified.globalConfigDialog.addHeader("Global Announcer Configuration");
        window.wittified.globalConfigDialog.addPanel("Panel 1", '<div id="wittified-global-config-dialog-html">&nbsp;</div>');
        window.wittified.globalConfigDialog.addButton("Done", function(dialog)
        {
            dialog.hide();
        });

        AJS.$('#wittified-global-config-dialog-html').html(  AJS.$('#wittified-configuration-dialog').html() );


    }
    window.wittified.globalConfigDialog.show();
}


window.wittified.resetNotificationDialog = false;
window.wittified.resetNotification = function ( id )
{
		var itemID = id;
		if(!window.wittified.resetNotificationDialog)
		{
		window.wittified.resetNotificationDialog =  new AJS.Dialog({
		                                                   width: 350,
                                                           height: 350,
                                                           id: "wittified-reset-notification-dialog",
                                                           closeOnOutsideClick: false
                                                       });
         		window.wittified.resetNotificationDialog.addHeader("Are you sure?");
         		window.wittified.resetNotificationDialog.addPanel("Panel 1", '<div id="wittified-reset-dialog-html"><p>This will reset all counts and cannot be undone.</p></div>');
         		window.wittified.resetNotificationDialog.addButton("Cancel", function(dialog)
         		{
         			dialog.hide();
         		})
         		window.wittified.resetNotificationDialog.addButton("Yes - reset",
         		function(dialog)
         		{
         		    AJS.$.ajax({
                            url: AJS.contextPath()+'/rest/announcer/1.0/admin/reset/'+id,
                            dataType: "json",
                            contentType: "application/json",
                            data: '{"action":"reset"}',
                            method: 'POST',
                            type: 'POST',
                            success: function(data, textStatus, jqXHR)
                            {
                                window.location.reload(true);

                            }
                        });
                });
        }
        window.wittified.resetNotificationDialog.show();

}
window.wittified.recurringTypeSelectorChange = function (selectedValue) {

    var selectorValue = AJS.$("#recurringTypeSelector").val();
    var html = "";

    if(selectorValue == "weekly"){

        for(var i =1 ; i<=7 ; i++){
            html = html + "<option value='"+  i + "' onclick=this.value;";

            if(selectedValue == i){
               html = html + " selected='selected'>"
            }else {
                html = html + ">";
            }

            if(i==1){
               html = html + "Monday </option>"
            } else if(i==2) {
                html = html + "Tuesday </option>"
            } else if(i==3) {
                html = html + "Wednesday </option>"
            } else if(i==4) {
                html = html + "Thursday </option>"
            } else if(i==5) {
                html = html + "Friday </option>"
            } else if(i==6) {
                html = html + "Saturday </option>"
            } else if(i==7) {
                html = html + "Sunday </option>"
            }
        }
        AJS.$("#recurringDaySelector").removeAttr('disabled');
        AJS.$("#recurringDaySelector").html(html);

    } else if(selectorValue == "monthly") {

        for(var i =1 ; i<=31 ; i++){
            html = html + "<option value='" + i + "' onclick=this.value;";
            if(selectedValue == i){
                html = html + " selected='selected'>"
             }else {
                 html = html + ">";
             }
            html = html + i +"</option>";
        }
        AJS.$("#recurringDaySelector").removeAttr('disabled');
        AJS.$("#recurringDaySelector").html(html);
    } else if(selectorValue == "lastDayOfMonth"){
        AJS.$("#recurringDaySelector").attr('disabled', 'disabled');
    }


}

window.wittified.renderWeek = function(){
    var parentDiv = document.createElement('div');

    var alreadySelectedDays = document.getElementById('selectedDays').value; // Get the already persisted value for rendering.

    if(alreadySelectedDays){ // Expected input 1#2#3 (or) 1  (or) 1#2#3#4#5
        var daysSelected = [];
        if(alreadySelectedDays.length == 1){ // If only single day is selected, directly push to array
          daysSelected.push(parseInt(alreadySelectedDays));
        } else{
          daysSelected = alreadySelectedDays.split('#'); // Otherwise, split with delimiter
          daysSelected = daysSelected.map(Number);
        }
    }
            
    for(var i=1; i <=7; i++){ // Create new html nodes for each day of the week
        var spanId = "day" + i;
        var spanElement = document.createElement('span');
        spanElement.className='weekstyle';

        spanElement.id = spanId;
        spanElement.setAttribute('selected',false);

        if(daysSelected && daysSelected.includes(i)){
            spanElement.style.backgroundColor = "#1a8099";
            spanElement.style.color = 'white';
            spanElement.setAttribute('selected', true);
        }

        spanElement.innerHTML = window.wittified.getWeekLabelBasedOnIndex(i); // Get the day label (Sun / Mon / Tue)
        spanElement.addEventListener("click", window.wittified.selectDay);
        parentDiv.appendChild(spanElement);
    }

    parentDiv.id = 'weekdiv';
    document.getElementById('weeklyStartTime').disabled = '';
    document.getElementById('weeklyEndTime').disabled = '';

    document.getElementById('weekdiv').replaceWith(parentDiv) ; // Replacing an empty node with freshly generated node
}

window.wittified.disableWeek = function(){
    for(var i=1; i <=7; i++){ // Create new html nodes for each day of the week
        var spanId = "day" + i;
        var element = document.getElementById(spanId);

        element.removeEventListener('click',window.wittified.selectDay); // removing the click event when disabled
        AJS.$('#selected-time-error').html(''); // Resetting the validation error
        
        if(element.getAttribute('selected') === 'true'){
            element.style.backgroundColor = "#545757";
            element.style.color = 'white';
        } else {
            element.style.backgroundColor = "#bbbfbf";
        }
    }

    document.getElementById('weeklyStartTime').disabled = 'disabled';
    document.getElementById('weeklyEndTime').disabled = 'disabled';
    AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled'); // Disable the submit button
}

window.wittified.selectDay = function(event){
    var element = event.currentTarget;

    if(element.getAttribute('selected') === 'false'){
      element.style.backgroundColor = "#1a8099";
      element.setAttribute('selected', true);
      element.style.color = 'white';
    } else {
      element.setAttribute('selected', false);
      element.style.color = '';
      element.style.backgroundColor = "#d7e8ec";
    }

    window.wittified.setSelectedDays(); // For every select/unselect, update the selected dates.
}
  
window.wittified.getWeekLabelBasedOnIndex = function(id){
    switch(id){
        case 1:
            return 'Sun';
        case 2:
            return 'Mon';
        case 3:
            return 'Tue';
        case 4:
            return 'Wed';
        case 5:
            return 'Thu';
        case 6:
            return 'Fri';
        case 7:
            return 'Sat';
        default:
            return 'NA';
    }
}

window.wittified.setSelectedDays = function(){
    var selectedDays = '';

    for(var i=1; i <=7; i++){
      var spanId = "day" + i;
      var spanElement = document.getElementById(spanId);

      if(spanElement.getAttribute('selected') === 'true'){
        selectedDays = (selectedDays + i + '#');
      }
    }

    if(selectedDays.length > 1){
        selectedDays = selectedDays.substring(0, selectedDays.length - 1); // To remove the last character, avoid errors while splitting by #. Javascript can render '' as 0.
    }

    document.getElementById('selectedDays').value = selectedDays;
    window.wittified.validateInput(); // Enable the submit button if at least a day is selected
}

window.wittified.validateInput = function(event) {
    var startVal = $('#weeklyStartTime').val();
    var endVal = $('#weeklyEndTime').val();

    if(startVal === "" || endVal === ""){  // Data was not chosen in either / both of the fields
        return;
    }

    if(startVal > endVal){ // Direct comparison can be done on time values
        AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled');
        AJS.$('#selected-time-error').html('');
        AJS.$('#selected-time-error').append('<p style="color:red"> End time should not be before Start time </p>');
        return;
    }

    AJS.$('#selected-time-error').html(''); // Clear if any error message is present, since this validation is passed.

    var selectedDays = document.getElementById('selectedDays').value;

    if(selectedDays === ''){ // If no days were selected, hide the submit button
        AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled');
        return;
    }
    
	// After validation is passed, enable the submit button
    window.wittified.handleCustomRecurrenceValidations(); //ANNOUNCE-1178 : Enable the save button if only 'Start'/'End' time values were given
}

window.wittified.handleCustomRecurrenceValidations = function() {
	var isRunIndefinitely = AJS.$('#runIndefinitely').attr('checked');
    var disableSaveBtnForAnnouncer = false;
    
    if(isRunIndefinitely){
		if(AJS.$( "#start-datetime" ).val() === ''){
			disableSaveBtnForAnnouncer = true;
		}
	} else if(AJS.$( "#end-datetime" ).val() === '' || AJS.$( "#start-datetime" ).val() === ''){
		disableSaveBtnForAnnouncer = true;
	}
	
	AJS.$('#start-date-error').html('');
	
	if(disableSaveBtnForAnnouncer){
		AJS.$('#start-date-error').append('<p style="color:red"> Please select a time window.</p>');
		AJS.$('.wittified-announcement-edit-button').attr('disabled', true); // Disable Save button, since there is validation error.
	} else {
		AJS.$('.wittified-announcement-edit-button').attr('disabled', false); // Enable Save button, since all validations are passed.
	}
}

window.wittified.currentTimeCalculation = function () {
    var now = new Date();
    var hours = now.getHours();
    var minutes = now.getMinutes();
    return (hours <= 12 ? (hours == 0 ? "12" : hours) : hours-12) + ":" + (minutes < 10 ? '0' + minutes : minutes) + (hours >= 12 ? " PM": " AM");

}
window.wittified.displayEdit = function( id,filterProject, projectKey )
{
	if(!window.wittified.editDialog)
	{
		window.wittified.editDialog =  new AJS.Dialog({
                                                  width: 730,
                                                  height: 600,
                                                  id: "wittified-create-notification-dialog",
                                                  closeOnOutsideClick: false
                                              });
		window.wittified.editDialog.addHeader("Announcement editor");
		window.wittified.editDialog.addPanel("Panel 1", '<div id="wittified-edit-dialog-html">&nbsp;</div>');
		window.wittified.editDialog.addButton("Cancel", function(dialog)
		{
		    AJS.$('#wittified-edit-dialog-html').html('<span></span>');
			dialog.hide();
		})
		window.wittified.editDialog.addButton("Preview",
		function(dialog)
		{
            document.wittifiedPreviewAnnouncer.messageTitle.value = document.getElementById('d-title').value;
            document.wittifiedPreviewAnnouncer.htmlContents.value = document.getElementById('d-contents').value;
			document.wittifiedPreviewAnnouncer.type.value = AJS.$('#notification-type').val()
			document.wittifiedPreviewAnnouncer.format.value = AJS.$('#d-format-type').val();
			document.wittifiedPreviewAnnouncer.displayType.value = AJS.$('#d-displayType-type').val();

			document.wittifiedPreviewAnnouncer.buttonText.value = document.getElementById('d-buttonText').value;
			document.wittifiedPreviewAnnouncer.submit();
		});

		window.wittified.editDialog.addButton("Save", function(dialog)
		{
            if( AJS.$('#timeRestrict').is(':checked') && AJS.$("input[name='isActive']:checked").val()=='true')
            {
                var startTime = parseInt( AJS.$('#start-time').val());
                var endTime = parseInt( AJS.$('#end-time').val() );

                if(startTime < new Date().getTime() && endTime < new Date().getTime()){
                    return;
                }
            }

            if(AJS.$('#d-title').val() == '') {
                AJS.$('#title-error').html('');
                AJS.$('#title-error').append('<p style="color:red">Please enter a title of the announcement.</p>')
                AJS.$('.wittified-announcement-edit-button').attr('disabled', true); // Disable Save button, since there is validation error
                return;
            } else {
                AJS.$('#title-error').html('');
                AJS.$('.wittified-announcement-edit-button').attr('disabled', false); // Enable Save button, since the mandatory title field data is given
            }
            
            // SUPPORT-45084 : Capturing the user timezone offset, which will be used for showing week day recurring notifications.
            if( AJS.$('#timeRestrict').is(':checked')){
				// Below will return the offset corresponding to UTC, and tells how many minutes ahead/behind the UTC time.
				// For that comparison, the browser refers the timezone of the machine it was installed.
				// Sample examples
				//     For IST  ==> -330
				//     For PST  ==>  400
				
            	document.getElementById('announcer_browser_offset').value = new Date().getTimezoneOffset();
            }

            if(AJS.$('.bitbucket-theme').length > 0 && AJS.$('#shouldFilterProject').val() === "false") {
                window.wittified.assembleTargetProjects(AJS.$('#targetProjectSelector').val());
            }

            var formData = AJS.$('#wittified-submission').serialize();
            var toggle = document.getElementById('isActive');
            var isActive = toggle.checked;
            formData = formData.concat('&isActive=' + isActive );

			AJS.$.post( AJS.contextPath()+'/plugins/servlet/wittified/admin/notifications/edit', formData, function(data)
			{
				dialog.hide();
				window.location.reload(true);

			});
		},'aui aui-button aui-button-primary wittified-announcement-edit-button');

	}

	AJS.$('.wittified-announcement-edit-button').removeClass('button-panel-button');
	window.wittified.editDialog.show();


	var params = '';
	window.wittified.editDialog.timeWindow = false;
	if( filterProject && projectKey)
	{
		params='&project='+projectKey;
	}
	AJS.$.get( AJS.contextPath()+'/plugins/servlet/wittified/admin/notifications/edit?id='+id+params,{}, function(html)
	{
		AJS.$('#wittified-edit-dialog-html').html(html);
		AJS.$('#start-end-timer').hide();
		AJS.$('#customRecurrenceContents').hide();
		AJS.$('#customRecurrenceContentsDiv').hide();

		if(AJS.$(".wittified-tooltips").tooltip)
		{
			AJS.$(".wittified-tooltips").tooltip({aria:true});
		}

		AJS.$('#notification-type').on('change', function(evt)
        {
        console.log(evt);
            var s=AJS.$(this).val();
            if(s== 'intercept')
            {
                AJS.$('#filterProject').attr('disabled', true);
                AJS.$('#filterCategory').attr('disabled', true);
                if(AJS.$('#filterProject-picker').is(':visible')) {
                    AJS.$('#filterProject-picker').hide();
                }
                if(AJS.$('#filterProjectRole-container').is(':visible')) {
                    AJS.$('#filterProjectRole-container').hide();
                }
            }
            else
            {
                AJS.$('#filterProject').removeAttr('disabled');

                AJS.$('#filterCategory').removeAttr('disabled');
                if(!AJS.$('#filterProject-picker').is(':visible') && AJS.$('#filterProject').attr('checked')) {
                    AJS.$('#filterProject-picker').show();
                    if(AJS.$('#targetProjectSelector').val() != "") {
                        AJS.$('#filterProjectRole-container').show();
                    }

                }

            }
            if(s== 'banner' || s=='flag')
            {
                AJS.$('#showButton').removeAttr('disabled')
            }
            else
            {
                AJS.$('#showButton').attr('disabled', true);
            }
            // set the show button to true by default when the notification type is changed
            AJS.$('#showButton').attr('checked', true);
        });

		AJS.$('#d-title').on('blur', function(evt) {
		    evt.preventDefault();
		    if(AJS.$('#d-title').val() == '') {
                AJS.$('#title-error').html('');
                AJS.$('#title-error').append('<p style="color:red">Please enter a title of the announcement.</p>');
                AJS.$('.wittified-announcement-edit-button').attr('disabled', true); // Disable Save button, since there is validation error
            } else {
                AJS.$('#title-error').html('');
                AJS.$('.wittified-announcement-edit-button').attr('disabled', false); // Enable Save button, since the mandatory title field data is given
            }
		});
		
		// ANNOUNCE-1078 : Save button is disabled by default in edit mode even though all the required fields are filled
		// TODO : The current logic will allow saving notification with EMPTY title, this needs to be handled at all the applicable places
	    var titleValue = AJS.$('#d-title').val();
	    
	    if (titleValue !== '') {
			AJS.$('.wittified-announcement-edit-button').attr('disabled', false); // Enable Save button, since the mandatory title field data is given
		}

		if(AJS.$('#resetButton').attr('checked')) {
		    AJS.$('#newUserButton').attr('disabled', true);
		}

		AJS.$('#resetButton').on('change', function(evt) {
            evt.preventDefault();
            if(AJS.$('#resetButton').attr('checked')) {
                AJS.$('#newUserButton').attr('disabled', true);
                var msg = AJS.I18n.getText('wittified.announcer.newUsers.disabled.msg');
                AJS.$('label[for="newUserButton"]').tooltip({
                    title : function() {
                        return msg;
                    }
                });

            } else {
                AJS.$('#newUserButton').removeAttr('disabled');
                AJS.$('label[for="newUserButton"]').tooltip('destroy');
            }

        });

		if(AJS.$('#newUserButton').attr('checked')) {

            AJS.$('#resetButton').attr('disabled', true);
        }

		AJS.$('#newUserButton').on('change', function(evt) {
		    evt.preventDefault();
		    if(AJS.$('#newUserButton').attr('checked')) {

		        AJS.$('#resetButton').attr('disabled', true);
		        var msg = AJS.I18n.getText('wittified.announcer.reset.disabled.msg');
		        AJS.$('label[for="resetButton"]').tooltip({
		            title : function() {
		                return msg;
		            }
		        });

		    } else {
		        AJS.$('#resetButton').removeAttr('disabled');
		        AJS.$('label[for="resetButton"]').tooltip('destroy');
		    }


		});

		//ANNOUNCE-276
		AJS.$("#customRecurrence").on('change',  function(evt){
		    evt.preventDefault();
		    
		    // ANNOUNCE-1164 : If Custom Recurrence is unchecked; enable the 'Save' button, if start and end dates values were given.
	        // If 'Run Indefinitely' is checked, only start date is sufficient
		    var isRunIndefinitely = AJS.$('#runIndefinitely').attr('checked');
		    var disableSaveBtnForAnnouncer = false;
		    
		    if(isRunIndefinitely){
				if(AJS.$( "#start-datetime" ).val() === ''){
					disableSaveBtnForAnnouncer = true;
				}
			} else if(AJS.$( "#end-datetime" ).val() === '' || AJS.$( "#start-datetime" ).val() === ''){
				disableSaveBtnForAnnouncer = true;
			}
		    
		    if(AJS.$("#customRecurrence").attr('checked')){
		        AJS.$('#customRecurrenceContents').show();
		        
		        // If none of the checkboxes enabled, disable the Save button
	            if(!AJS.$('#isRunningType').attr('checked') && !AJS.$('#isRecurringType').attr('checked') && !AJS.$('#isRecurringWeeklyType').attr('checked')){
	                disableSaveBtnForAnnouncer = true;
	            }
		    } else {
		        if(AJS.$('#isRunningType').attr('checked')){
		            AJS.$('#isRunningType').attr('checked', false).change();
		        }
		        if(AJS.$('#isRecurringType').attr('checked')){
		            AJS.$('#isRecurringType').attr('checked', false).change();
		        }
                if(AJS.$('#isRecurringWeeklyType').attr('checked')){
                    AJS.$('#isRecurringWeeklyType').attr('checked', false).change();
		        }
		        AJS.$('#customRecurrenceContents').hide();
		    }
		    
		    if(disableSaveBtnForAnnouncer){
				AJS.$('.wittified-announcement-edit-button').attr('disabled', true); // Disable Save button, since there is validation error.
			} else {
				AJS.$('.wittified-announcement-edit-button').attr('disabled', false); // Enable Save button, since all validations are passed.
			}
		});

		if(AJS.$("#customRecurrence").attr('checked')){
		    AJS.$('#customRecurrenceContents').show();
		}

		if(AJS.$('#isRunningType').attr('checked')) {
            AJS.$('#isRecurringType').attr('disabled', true);
            AJS.$('#end-datetime').attr('disabled', true);
            AJS.$('.wittified-announcement-edit-button').removeAttr('disabled');
        }

        AJS.$('#runIndefinitely').on('change', function(evt) {
            if(AJS.$('#runIndefinitely').attr('checked')) {
                AJS.$('#end-datetime').attr('disabled', true);
            }else{
                AJS.$('#end-datetime').removeAttr('disabled');
                // Since 'Run Indefinitely' is unchecked, if the 'End Date' is not given, application is taking care of this condition by marking TempActive=false
            }
        });

        AJS.$('#isRunningType').on('change', function(evt) {
            evt.preventDefault();
            if(AJS.$('#isRunningType').attr('checked')) {
                AJS.$('#isRecurringType').attr('disabled', true);
                AJS.$('#isRecurringWeeklyType').attr('disabled', true);
                AJS.$('#runningFreq').removeAttr('disabled');
                AJS.$('#runningTypeSelector').removeAttr('disabled');
                AJS.$('#runIndefinitely').attr('disabled', true);

                AJS.$('#end-datetime').attr('disabled', true);
                if(!(AJS.$( "#start-datetime" ).val() == '')){
                    AJS.$('.wittified-announcement-edit-button').removeAttr('disabled');
                } else {
                    AJS.$('.wittified-announcement-edit-button').attr('disabled', true);
                }

            } else {
                AJS.$('#isRecurringType').removeAttr('disabled');
                AJS.$('#isRecurringWeeklyType').removeAttr('disabled');
                AJS.$('#runIndefinitely').removeAttr('disabled');
                AJS.$('#runningFreq').attr('disabled', true);
                AJS.$('#runningTypeSelector').attr('disabled',  true);
                AJS.$('#end-datetime').removeAttr('disabled');
                AJS.$('.wittified-announcement-edit-button').attr('disabled', true);


            }

        });

        if(AJS.$('#isRecurringType').attr('checked')) {

            AJS.$('#isRunningType').attr('disabled', true);
            AJS.$('#isRunningWeeklyType').attr('disabled', true);
        }

        AJS.$('#isRecurringType').on('change', function(evt) {
            evt.preventDefault();
            if(AJS.$('#isRecurringType').attr('checked')) {

                AJS.$('#isRunningType').attr('disabled', true);
                AJS.$('#isRecurringWeeklyType').attr('disabled', true);
                AJS.$('#recurringTypeSelector').removeAttr('disabled');
                AJS.$('#recurringDaySelector').removeAttr('disabled');
                
                window.wittified.handleCustomRecurrenceValidations(); //ANNOUNCE-1178 : Enable the save button if only 'Start'/'End' time values were given
                
            } else {
                AJS.$('#isRunningType').removeAttr('disabled');
                AJS.$('#isRecurringWeeklyType').removeAttr('disabled');
                AJS.$('#recurringTypeSelector').attr('disabled', true);
                AJS.$('#recurringDaySelector').attr('disabled', true);
                AJS.$('.wittified-announcement-edit-button').attr('disabled', true);
            }


        });

        AJS.$('#isRecurringWeeklyType').on('change', function(evt) {
            evt.preventDefault();
            if(AJS.$('#isRecurringWeeklyType').attr('checked')) {
                AJS.$('#isRunningType').attr('disabled', true);
                AJS.$('#isRecurringType').attr('disabled', true);
                window.wittified.renderWeek();
            } else {
                AJS.$('#isRunningType').removeAttr('disabled');
                AJS.$('#isRecurringType').removeAttr('disabled');
                window.wittified.disableWeek();
            }
        });


        var enableDateTimePicker = function()
        {
            //ANNOUNCE-518
            var startTime = parseInt( AJS.$('#start-time').val());
            var endTime = parseInt( AJS.$('#end-time').val() );
            var dtStartVal = '';
            var dtEndVal = '';

            if(startTime != 0)
            {
                dtStartVal = new Date( startTime);
            }

            if(endTime != 0)
            {
                dtEndVal = new Date( endTime);
            }

            /*Reference for datetime picker : https://github.com/xdan/datetimepicker/blob/master/MIT-LICENSE.txt
             * https://xdsoft.net/jqplugins/datetimepicker
             *
             *
             * */


            AJS.$("#start-datetime" ).datetimepicker({
                format:'Y/m/d h:i A',
                formatTime:'h:i A',
                step:15,
                value:dtStartVal,
                className:"start-datetime",
                onShow: function () {

                    var endVal = $('#end-datetime').val();
                    var now = new Date();
                    var currDate = new Date(Date.UTC(now.getUTCFullYear(), now.getUTCMonth(), now.getUTCDate() ));
                    var minTimeVal =  wittified.currentTimeCalculation();//set minimum time as current time
                    var maxTimeVal = false; // To set max Time of the start date time variable
                    var maxDateVal = false; // To set max Date of the start date time variable
                    // If end date is selected as current date, then select the max time for start date as time selected in end date
                    if(endVal && new Date(endVal).getDate() === now.getDate()){
                        var temp = endVal.split(" ");
                        maxTimeVal = temp[1] + " " + temp[2];
                    }

                    // If end date selected is after current date
                    // Then set max Date with the end date value

                    if(endVal && !(currDate > new Date(endVal))) {
                        maxDateVal = endVal;
                    }
                    this.setOptions({
                        minDate:0,
                        maxDate:maxDateVal,
                        maxTime:maxTimeVal,
                        minTime:minTimeVal
                    });
                },
                onChangeDateTime:function(dp,$input){
                    var minTimeVal = false;
                    var maxTimeVal = false;
                    var endVal = $('#end-datetime').val();

                    var now = new Date();
                    var currDate = new Date(Date.UTC(now.getUTCFullYear(), now.getUTCMonth(), now.getUTCDate() ));
                    var inputVal = $input.val();
                    var selectedDate = new Date(inputVal);

                    AJS.$('#start-date-error').html('');

                    // Restricting the maximum time value only if the end date is same as selected start date
                    if(new Date(endVal).getDate() === selectedDate.getDate()){

                        var temp = endVal.split(" ");
                        maxTimeVal = temp[1] + " " + temp[2];

                    } else if (selectedDate.getDate() === now.getDate()) { //Restricting min time to current time if current date selected
                        minTimeVal = wittified.currentTimeCalculation();
                    }

                    this.setOptions({
                        minTime:minTimeVal,
                        maxTime:maxTimeVal
                    });

                    // Date and time validation when user type in the input box
                    if(currDate > selectedDate ) {

                        AJS.$('#start-date-error').html('')
                        AJS.$('#start-date-error').append('<p style="color:red"> Start date should not be before today </p>');
                        AJS.$('#start-time').val( currDate.getTime());
                        AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled');

                    } else if (endVal && new Date(endVal) < selectedDate) {

                        AJS.$('#start-date-error').html('')
                        AJS.$('#start-date-error').append('<p style="color:red"> Start date should not be after end date </p>');
                        AJS.$('#start-time').val( currDate.getTime());
                        AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled');

                    } else if(inputVal) {
                        AJS.$('#start-time').val(selectedDate.getTime());
                        if(AJS.$('#isRunningType').attr('checked')){
                            AJS.$('.wittified-announcement-edit-button').removeAttr('disabled');
                        } else if(endVal){
                            AJS.$('.wittified-announcement-edit-button').removeAttr('disabled');
                        }

                    } else {
                        AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled');
                    }

                }
          });


          AJS.$( "#end-datetime" ).datetimepicker({
              format:'Y/m/d h:i A',
              formatTime:'h:i A',
              step:15,
              value:dtEndVal,
              className:"end-datetime",
              onShow: function () {
                  var startVal = $('#start-datetime').val();
                  var minTimeVal = wittified.currentTimeCalculation();
                  var minDateVal = 0;
                  var now = new Date();
                  var currDate = new Date(Date.UTC(now.getUTCFullYear(), now.getUTCMonth(), now.getUTCDate() ));

                  if(startVal && new Date(startVal).getDate() === now.getDate()){
                      var temp = startVal.split(' ');
                      minTimeVal = temp[1] + " " + temp[2]; //set end date min time to start date time if start date is current date
                  }


                  if(startVal && !(currDate > new Date(startVal))) {
                      minDateVal = startVal;
                  }
                    this.setOptions({
                        minDate: minDateVal,
                        minTime: minTimeVal
                    });
              },
              onChangeDateTime:function(dp,$input){
                  var minTimeVal = false;
                  var startVal = $('#start-datetime').val();
                  var inputVal = $input.val();
                  var now = new Date();
                  var currDate = new Date(Date.UTC(now.getUTCFullYear(), now.getUTCMonth(), now.getUTCDate() ));
                  var selectedDate = new Date(inputVal);

                  AJS.$('#end-date-error').html('');

                  if(new Date(startVal).getDate() === selectedDate.getDate()){
                      var temp = startVal.split(' ');
                      minTimeVal = temp[1] + " " + temp[2];
                  } else if (selectedDate.getDate() === now.getDate()) { //Restricting min time to current time if current date selected
                      minTimeVal = wittified.currentTimeCalculation();
                  }

                  this.setOptions({
                      minTime:minTimeVal
                  });

               // Date and time validation when user type in the input box
                  if(currDate > selectedDate ) {
                      AJS.$('#end-date-error').html('');
                      AJS.$('#end-date-error').append('<p style="color:red"> End date should not be before today </p>');
                      AJS.$('#end-time').val( currDate.getTime());
                      AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled');
                  } else if ( selectedDate < new Date(startVal)) {

                      AJS.$('#end-date-error').html('');
                      AJS.$('#end-date-error').append('<p style="color:red"> End date should not be before start date. </p>');
                      AJS.$('#end-time').val( currDate.getTime());
                      AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled');

                  } else if(inputVal)  {
                      AJS.$('#end-time').val(selectedDate.getTime())
                      if(startVal){
                          AJS.$('.wittified-announcement-edit-button').removeAttr('disabled');
                      } else {
                          AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled');
                      }

                  } else {
                      AJS.$('.wittified-announcement-edit-button').attr('disabled', 'disabled');
                  }

              }
          });
        }

        AJS.$('#timeRestrict').on('change', function(evt)
                {

                    evt.stopPropagation();

                    if(AJS.$(this).is(':checked'))
                    {
                       enableDateTimePicker();
                       AJS.$('#start-end-timer').show();
                       if(AJS.$( "#end-datetime" ).val() == '' || AJS.$( "#start-datetime" ).val() == ''){
                           AJS.$('.wittified-announcement-edit-button').attr('disabled', true);
                       }
                       AJS.$('#customRecurrenceContentsDiv').show();
                    }
                    else
                    {
                        AJS.$('#start-time').val(0);
                        AJS.$('#end-time').val(0);
                        AJS.$('#start-datetime').datetimepicker('reset').datetimepicker('destroy');
                        AJS.$('#end-datetime').datetimepicker('reset').datetimepicker('destroy');
                        AJS.$('#start-end-timer').hide();
                        AJS.$('.wittified-announcement-edit-button').removeAttr('disabled');
                        AJS.$('#customRecurrenceContentsDiv').hide();

                    }

                });
        if( AJS.$('#timeRestrict').is(':checked'))
        {

                enableDateTimePicker();
               AJS.$('#start-end-timer').show();
            AJS.$('#customRecurrenceContentsDiv').show();
        }

    });


}

window.wittified.cookie.getCookie = function (cname) {
    var name = cname + "=";
    var decodedCookie = decodeURIComponent(document.cookie);
    var ca = decodedCookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

window.wittified.cookie.getCookieKey = function (userKey) {
    var keyLength = 15;
    var value = "";
    if (userKey != "") {
        console.log("----window.wittified.forge.create1");
        console.log(window.wittified);
        var md = window.wittified.forge.create();
        md.update(userKey);
        value = md.digest().toHex().substring(0, keyLength);
    } else {
        var anonCookieValue = getCookie('announcer-anon-cookie-id');
        if (anonCookieValue == undefined || anonCookieValue == '') {
            var uuid = Math.random().toString(16).split('.')[1];
            console.log("----window.wittified.forge.create2");
            console.log(window.wittified);
            var md = window.wittified.forge.create();
            md.update(uuid);
            value = md.digest().toHex().substring(0, keyLength);
            setCookie('announcer-anon-cookie-id', value, false);
        } else {
            value = anonCookieValue;
        }
    }
    return 'com.wittified.mute_' + value;
}

var _MS_PER_MIN = 1000 * 60;

function getMutePeriod(current, past) {
    return Math.floor((current - past) / _MS_PER_MIN);
}

window.wittified.isAnnouncementMuted = function (notification, user, rmlTime) {
    var x = true;
    var cookieName = getCookieKey(user);
    var cookieValue = getCookie(cookieName);
    if (cookieValue) {
        var cookieValues = cookieValue.split(",");
        //console.log({cookieValues});
        var lastMuted = new Date().getTime();
        var mutedOnce = false;

        AJS.$.each(cookieValues, function (index, value) {
            var notificationId = value.split("#")[0];
            if (notificationId == notification.ID) {
                mutedOnce = true;
                lastMuted = value.split("#")[1];
                //configured mute value in global configuration.
                var configuredMuteValue = rmlTime;
                var mutePeriod = getMutePeriod(new Date().getTime(), lastMuted);
                if (mutePeriod < configuredMuteValue) {
                    x = false
                } else {
                    x = true
                }
            }
        });
        if (!mutedOnce) {
            console.log("===== cookie found but no entry ====");
            x = true
        }
    } else {
        console.log("==== cookie not found ====");
    }

    return x;
}

function setCookie(cookieName, cookieValue, options) {
    if (options) {
        const expires = options.expires;
        document.cookie = [
            cookieName, '=', cookieValue, ';', expires, ';path=/', ';SameSite=Strict;', (location.protocol === "https:" ? "Secure;" : "")
        ].join('')
    } else {
        document.cookie = cookieName + '=;path=/';
        document.cookie = [
            cookieName, '=', cookieValue.toString(), ';path=/', ';SameSite=Strict;', (location.protocol === "https:" ? "Secure;" : "")
        ].join('')
    }
}

function getCookie(cname) {
    var name = cname + "=";
    var decodedCookie = decodeURIComponent(document.cookie);
    var ca = decodedCookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function getCookieKey(userKey) {
    var keyLength = 15;
    var value = "";
    if (userKey != "") {
        var md = window.wittified.forge.create();
        md.update(userKey);
        value = md.digest().toHex().substring(0, keyLength);
    } else {
        var anonCookieValue = getCookie('announcer-anon-cookie-id');
        if (anonCookieValue == undefined || anonCookieValue == '') {
            var uuid = Math.random().toString(16).split('.')[1];
            var md = window.wittified.forge.create();
            md.update(uuid);
            value = md.digest().toHex().substring(0, keyLength);
            setCookie('announcer-anon-cookie-id', value, false);
        } else {
            value = anonCookieValue;
        }
    }
    return 'com.wittified.mute_' + value;
}


window.wittified.wittified_announcer_flag_remindmelater = function (bannerID, user, rmlTime) {
    window.wittifiedAllFlags[bannerID + ''].close();

    var cookieName = getCookieKey(user);
    var cookieValue = getCookie(cookieName);

    if (cookieValue) {
        // need to check for 256 charectors
        if (cookieValue.length >= 200) {
            cookieValue = cookieValue.substring(cookieValue.indexOf(",") + 1, cookieValue.length);
        }
        var cookieValues = cookieValue.split(",");
        var onceMuted = false;
        AJS.$.each(cookieValues, function (index, value) {
            if (value.split("#")[0] == bannerID) {
                // update the mute time.
                // need to take care of cookie length.
                cookieValues[index] = bannerID + "#" + new Date().getTime();
                onceMuted = true;
                return;
            }
        });
        // not muted till now
        if (!onceMuted) {
            // need to take care of cookie length.
            cookieValues.push(bannerID + "#" + new Date().getTime());
        }
        setCookie(cookieName, cookieValues, false);
    } else {
        var cookieItems = [];
        cookieItems.push(bannerID + "#" + new Date().getTime());
        setCookie(cookieName, cookieItems, false);
    }
}


window.wittified.flagDismiss = function (event, currentKey, id, loadTime) {
    if (event) {
        event.preventDefault();
        AJS.$('#wittified-notification-flag-' + id).html('<span class="aui-icon aui-icon-wait">Wait</span>');
        AJS.$.ajax({
            "contentType": "application/json",
            "data": JSON.stringify({"loadTime": loadTime, "id": id, "key": currentKey}),
            "url": AJS.contextPath() + '/rest/announcer/1.0/accept/accept',
            "type": "POST",
            "method": "POST"
        }).always(function (state) {
            if (state.status == 'success') {
                window.wittifiedAllFlags[id + ''].close();

            } else {
                AJS.$('#wittified-notification-state-' + id).html('Submission error, please reload the page');
            }
        });
    } else {
        console.log("initial load..")
    }
}


AJS.toInit(function () {
    window.wittified.prepareViewOfContents();
    AJS.InlineDialog(AJS.$("#wittified-about-link"), 1,
        function (content, trigger, showPopup) {
            content.css({"padding": "20px"}).html(AJS.$('#wittified-license-explanation').html());
            showPopup();
            return false;
        },
            {
                width: 600
            }
        );

		//status page announcements tool-tip
		AJS.$(".statuspage-tooltip").tooltip();

})
