/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.xwork;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.general.support.SupportBarService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.NotificationBean;
import com.wittified.services.InvalidNotificationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedMethods(value={RequestMethod.GET})
public class JiraProjectAction
extends ProjectActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(JiraProjectAction.class);
    private final ProjectManager projectManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private WebResourceManager webResourceManager;
    private LicenseCounter licenseCounter;
    private PluginLicenseManager licenseStorageManager;
    private NotificationService notificationService;
    private final SupportBarService supportBarService;
    private final InvalidNotificationService invalidNotificationService;
    private String projectKey;
    private Map<String, Object> context = null;

    public JiraProjectAction(ProjectManager projectManager, VelocityRequestContextFactory velocityRequestContextFactory, WebResourceManager webResourceManager, LicenseCounter licenseCounter, PluginLicenseManager licenseStorageManager, NotificationService notificationService, SupportBarService supportBarService, InvalidNotificationService invalidNotificationService) {
        this.projectManager = projectManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.webResourceManager = webResourceManager;
        this.licenseStorageManager = licenseStorageManager;
        this.licenseCounter = licenseCounter;
        this.notificationService = notificationService;
        this.supportBarService = supportBarService;
        this.invalidNotificationService = invalidNotificationService;
    }

    public void setProjectKey(String key) {
        this.projectKey = key;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public Project getProject() {
        return this.projectManager.getProjectObjByKey(this.projectKey);
    }

    public String getSupportbarHtml() {
        PluginLicense license = (PluginLicense)this.licenseStorageManager.getLicense().getOrElse((Object)null);
        return this.supportBarService.getHtml();
    }

    public String doDefault() throws Exception {
        this.context = new HashMap<String, Object>();
        HttpServletRequest request = ExecutingHttpRequest.get();
        request.setAttribute("com.atlassian.jira.projectconfig.util.ServletRequestProjectConfigRequestCache" + ":project", (Object)this.getProject());
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        session.setAttribute("atl.jira.admin.current.project", (Object)this.projectKey);
        logger.debug("default");
        this.webResourceManager.requireResourcesForContext("atl-notifier");
        String projectKey = this.getProjectKey();
        boolean filterProject = projectKey != null;
        logger.debug(this.licenseCounter.currentUserCanEdit(projectKey) + " they can edit?");
        if (this.licenseCounter.currentUserCanEdit(projectKey)) {
            List<Notification> notificationList = this.notificationService.getAllNotifications();
            boolean allNotificationsAreDisabled = true;
            List<Object> activeNotifications = new ArrayList();
            List<Object> deactiveNotifications = new ArrayList();
            ArrayList<NotificationBean> invalidNotifications = new ArrayList<NotificationBean>();
            for (Notification notification : notificationList) {
                boolean grabItem = false;
                if (filterProject) {
                    if (notification.getFilterProject() && notification.getTargetProject() != null && !notification.getTargetProject().isEmpty() && notification.getTargetProject().equals(":" + projectKey + ":")) {
                        grabItem = true;
                    }
                } else {
                    grabItem = true;
                }
                if (!grabItem) continue;
                if (notification.getActive()) {
                    if (Boolean.TRUE.equals(notification.getDateRestrict()) && notification.getEndDate().before(new Date())) {
                        notification.setActive(false);
                        this.notificationService.saveNotification(notification);
                        deactiveNotifications.add(new NotificationBean(notification));
                    } else {
                        allNotificationsAreDisabled = false;
                        activeNotifications.add(new NotificationBean(notification));
                    }
                } else {
                    deactiveNotifications.add(new NotificationBean(notification));
                }
                if (StringUtils.isNoneBlank(this.getMissedTargetGroups(notification)) || StringUtils.isNoneBlank(this.getMissedTargetProjects(notification))) {
                    notification.setActive(false);
                    this.notificationService.saveNotification(notification);
                    invalidNotifications.add(new NotificationBean(notification));
                }
                if (!this.licenseCounter.getApplicationType().equals("JIRA") || !StringUtils.isNoneBlank(this.getMissedTargetProjectRoles(notification)) || invalidNotifications.contains(notification)) continue;
                notification.setActive(false);
                this.notificationService.saveNotification(notification);
                invalidNotifications.add(new NotificationBean(notification));
            }
            deactiveNotifications = deactiveNotifications.stream().filter(notif -> !invalidNotifications.contains(notif)).collect(Collectors.toList());
            activeNotifications = activeNotifications.stream().filter(notif -> !invalidNotifications.contains(notif)).collect(Collectors.toList());
            Collections.sort(activeNotifications, Comparator.nullsLast(Comparator.comparing(NotificationBean::getTitle, Comparator.nullsLast(Comparator.naturalOrder()))));
            Collections.sort(deactiveNotifications, Comparator.nullsLast(Comparator.comparing(NotificationBean::getTitle, Comparator.nullsLast(Comparator.naturalOrder()))));
            Collections.sort(invalidNotifications, Comparator.nullsLast(Comparator.comparing(NotificationBean::getTitle, Comparator.nullsLast(Comparator.naturalOrder()))));
            this.context.put("notifications", notificationList);
            this.context.put("deactiveNotifications", deactiveNotifications);
            this.context.put("activeNotifications", activeNotifications);
            this.context.put("invalidNotifications", invalidNotifications);
            this.context.put("announcerHelper", new AnnouncerHelper());
            this.context.put("allNotificationsAreDisabled", allNotificationsAreDisabled);
            this.context.put("license", this.getCheckLicense());
            this.context.put("product", this.licenseCounter.getApplicationType());
            this.context.put("action", (Object)this);
            this.context.put("numUsers", this.licenseCounter.getNumberOfUsers());
            this.context.put("contextPath", request.getContextPath());
            this.context.put("filterProject", filterProject);
            this.context.put("projectKey", projectKey);
            this.context.put("wittifiedXsfrToken", this.licenseCounter.getXsfrToken(request, this.getHttpResponse()));
        }
        return "input";
    }

    public String getMissedTargetGroups(Notification notification) {
        return this.invalidNotificationService.getMissedTargetGroups(notification);
    }

    public String getMissedTargetProjectRoles(Notification notification) {
        return this.invalidNotificationService.getMissedTargetProjectRoles(notification);
    }

    public String getMissedTargetProjects(Notification notification) {
        return this.invalidNotificationService.getMissedTargetProjects(notification);
    }

    public String getWittifiedXsfrToken() {
        return this.licenseCounter.getXsfrToken(this.getHttpRequest(), this.getHttpResponse());
    }

    public List<Notification> getNotifications() {
        return (List)this.context.get("notifications");
    }

    public List<Notification> getDeactiveNotifications() {
        return (List)this.context.get("deactiveNotifications");
    }

    public List<Notification> getActiveNotifications() {
        return (List)this.context.get("activeNotifications");
    }

    public List<Notification> getInvalidNotifications() {
        return (List)this.context.get("invalidNotifications");
    }

    public AnnouncerHelper getAnnouncerHelper() {
        return (AnnouncerHelper)this.context.get("announcerHelper");
    }

    public boolean getAllNotificationsAreDisabled() {
        return (Boolean)this.context.get("allNotificationsAreDisabled");
    }

    public String getProduct() {
        return (String)this.context.get("product");
    }

    public ProjectActionSupport getAction() {
        return this;
    }

    public String getLicense() {
        return (String)this.context.get("license");
    }

    public int getNumUsers() {
        return this.licenseCounter.getNumberOfUsers();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public boolean getFilterProject() {
        return true;
    }

    public int getNumUsers(NotificationBean notification) {
        if (notification == null) {
            return this.licenseCounter.getNumberOfUsers();
        }
        String groupName = null;
        if (notification.getGroupTarget() != null) {
            groupName = notification.getGroupTarget().split(",")[0];
        }
        if (notification.getFilterGroups() == null) {
            groupName = null;
        }
        if (groupName == null || groupName.isEmpty()) {
            return this.licenseCounter.getNumberOfUsers();
        }
        String[] groups = new String[]{};
        if (notification.getGroupTarget() != null) {
            groups = notification.getGroupTarget().split(",");
        }
        HashSet<String> set = new HashSet<String>();
        for (String group : groups) {
            set.addAll(this.licenseCounter.getUserNamesInGroup(group));
        }
        return set.size();
    }

    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }
}

