/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.xwork;

import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.general.support.SupportBarService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.InvalidNotificationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSpaceAction
extends AbstractSpaceAdminAction {
    private final Logger logger = LoggerFactory.getLogger(ConfluenceSpaceAction.class);
    private WebResourceManager webResourceManager;
    private LicenseCounter licenseCounter;
    private PluginLicenseManager licenseStorageManager;
    private NotificationService notificationService;
    private HttpContext httpContext;
    private SupportBarService supportBarService;
    private InvalidNotificationService invalidNotificationService;
    public List<Notification> notifications = new ArrayList<Notification>();
    public List<Notification> deactiveNotifications = new ArrayList<Notification>();
    public List<Notification> activeNotifications = new ArrayList<Notification>();
    public List<Notification> invalidNotifications = new ArrayList<Notification>();
    public AnnouncerHelper announcerHelper = new AnnouncerHelper();
    public boolean allNotificationsAreDisabled = false;
    public boolean filterProject = true;
    public String projectKey = "";

    public void setSupportBarService(SupportBarService supportBarService) {
        this.supportBarService = supportBarService;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public void setLicenseCounter(LicenseCounter licenseCounter) {
        this.licenseCounter = licenseCounter;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setPluginLicenseManager(PluginLicenseManager licenseStorageManager) {
        this.licenseStorageManager = licenseStorageManager;
    }

    public void setInvalidNotificationService(InvalidNotificationService invalidNotificationService) {
        this.invalidNotificationService = invalidNotificationService;
    }

    public String execute() throws Exception {
        this.logger.debug("Display the space specific item");
        this.webResourceManager.requireResourcesForContext("atl-notifier");
        String projectKey = this.getSpaceKey();
        boolean missedProjectCategories = false;
        boolean filterProject = projectKey != null;
        this.logger.debug(this.licenseCounter.currentUserCanEdit(projectKey) + " they can edit?");
        if (this.licenseCounter.currentUserCanEdit(projectKey)) {
            List<Notification> notificationList = this.notificationService.getAllNotifications();
            boolean allNotificationsAreDisabled = true;
            ArrayList<Notification> activeNotifications = new ArrayList<Notification>();
            ArrayList<Notification> deactiveNotifications = new ArrayList<Notification>();
            ArrayList<Notification> invalidNotifications = new ArrayList<Notification>();
            for (Notification notification : notificationList) {
                boolean grabItem = false;
                if (filterProject) {
                    if (notification.getFilterProject() && notification.getTargetProject() != null && !notification.getTargetProject().isEmpty() && notification.getTargetProject().equals(":" + projectKey + ":")) {
                        grabItem = true;
                    }
                } else {
                    grabItem = true;
                }
                if (!grabItem) continue;
                if (notification.getActive()) {
                    if (Boolean.TRUE.equals(notification.getDateRestrict()) && notification.getEndDate().before(new Date())) {
                        notification.setActive(false);
                        this.notificationService.saveNotification(notification);
                        deactiveNotifications.add(notification);
                    } else {
                        allNotificationsAreDisabled = false;
                        activeNotifications.add(notification);
                    }
                } else {
                    deactiveNotifications.add(notification);
                }
                if (StringUtils.isNoneBlank(this.getMissedTargetGroups(notification)) || StringUtils.isNoneBlank(this.getMissedTargetProjects(notification))) {
                    notification.setActive(false);
                    this.notificationService.saveNotification(notification);
                    invalidNotifications.add(notification);
                }
                if (!StringUtils.isNoneBlank(this.getMissedTargetProjectCategories(notification)) || invalidNotifications.contains(notification)) continue;
                notification.setActive(false);
                this.notificationService.saveNotification(notification);
                invalidNotifications.add(notification);
            }
            Comparator<Notification> comparator = new Comparator<Notification>(){

                @Override
                public int compare(Notification a, Notification b) {
                    if (a != null && a.getTitle() != null && b != null && b.getTitle() != null) {
                        return a.getTitle().compareTo(b.getTitle());
                    }
                    return 1;
                }
            };
            Collections.sort(activeNotifications, comparator);
            Collections.sort(deactiveNotifications, comparator);
            Collections.sort(invalidNotifications, comparator);
            this.notifications = notificationList;
            this.deactiveNotifications = deactiveNotifications.stream().filter(notif -> !invalidNotifications.contains(notif)).collect(Collectors.toList());
            this.activeNotifications = this.activeNotifications.stream().filter(notif -> !invalidNotifications.contains(notif)).collect(Collectors.toList());
            this.activeNotifications = activeNotifications;
            this.invalidNotifications = invalidNotifications;
            this.allNotificationsAreDisabled = allNotificationsAreDisabled;
            this.filterProject = filterProject;
            this.projectKey = projectKey;
        }
        return "input";
    }

    public String getMissedTargetProjectCategories(Notification notification) {
        return this.invalidNotificationService.getMissedTargetProjectCategories(notification);
    }

    public String getMissedTargetGroups(Notification notification) {
        return this.invalidNotificationService.getMissedTargetGroups(notification);
    }

    public String getLicense() {
        return this.getCheckLicense();
    }

    public String getProduct() {
        return this.licenseCounter.getApplicationType();
    }

    public String getMissedTargetProjects(Notification notification) {
        return this.invalidNotificationService.getMissedTargetProjects(notification);
    }

    public String getWittifiedXsfrToken() {
        return this.licenseCounter.getXsfrToken(this.httpContext.getRequest(), this.httpContext.getResponse());
    }

    public int getNumUsers() {
        return this.licenseCounter.getNumberOfUsers();
    }

    public String getContextPath() {
        return this.getGlobalSettings().getBaseUrl();
    }

    public Map<String, Object> getContext() {
        Map context = super.getContext();
        return context;
    }

    public String getSupportbarHtml() {
        return this.supportBarService.getHtml();
    }

    public int getNumUsers(Notification notification) {
        String groupName;
        if (notification == null) {
            return this.licenseCounter.getNumberOfUsers();
        }
        String targetedGroups = notification.getGroupTarget();
        this.logger.debug("targetedGroups:" + targetedGroups);
        String string = groupName = StringUtils.isEmpty(targetedGroups) ? "" : targetedGroups.split(",")[0];
        if (!notification.getFilterGroups()) {
            groupName = null;
        }
        if (groupName == null || groupName.isEmpty()) {
            return this.licenseCounter.getNumberOfUsers();
        }
        String[] groups = notification.getGroupTarget().split(",");
        HashSet<String> set = new HashSet<String>();
        for (String group : groups) {
            set.addAll(this.licenseCounter.getUserNamesInGroup(group));
        }
        return set.size();
    }

    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }
}

