/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.panels;

import com.atlassian.jira.plugin.navigation.PluggableTopNavigation;
import com.atlassian.jira.plugin.navigation.TopNavigationModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.wittified.DisplayTypeHolder;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.cache.NotificationCacheList;
import com.wittified.format.FormatService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.GlobalConfigurationService;
import com.wittified.services.TokenChangeService;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraBanner
implements PluggableTopNavigation {
    private final NotificationService notificationService;
    private TopNavigationModuleDescriptor descriptor;
    private final UserManager userManager;
    private final TemplateRenderer templateRenderer;
    private final LicenseCounter licenseCounter;
    private final TokenChangeService tokenChangeService;
    private final WebResourceManager webResourceManager;
    private final FormatService formatService;
    private final GlobalConfigurationService globalConfigurationService;
    private final ProjectRoleManager projectRoleManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private static final Logger logger = LoggerFactory.getLogger(JiraBanner.class);

    public JiraBanner(NotificationService notificationService, UserManager userManager, TemplateRenderer templateRenderer, LicenseCounter licenseCounter, PluginSettingsFactory pluginSettingsFactory, TokenChangeService tokenChangeService, WebResourceManager webResourceManager, FormatService formatService, GlobalConfigurationService globalConfigurationService, ProjectRoleManager projectRoleManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.notificationService = notificationService;
        this.userManager = userManager;
        this.templateRenderer = templateRenderer;
        this.licenseCounter = licenseCounter;
        this.tokenChangeService = tokenChangeService;
        this.webResourceManager = webResourceManager;
        this.formatService = formatService;
        this.globalConfigurationService = globalConfigurationService;
        this.projectRoleManager = projectRoleManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    private Map<String, Object> getTopNavigationContext(HttpServletRequest request) {
        Map params = this.descriptor.getTopNavigationContext(request, null);
        params.put("user", params.get("currentUser"));
        params.put("helper", params.get("jiraHelperWithProject"));
        return params;
    }

    public void init(TopNavigationModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String format(NotificationCacheEntry notification) {
        return this.formatService.formatThis(notification.getFormat(), this.handleVars(notification.getHtml()));
    }

    public String handleVars(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        Map<String, String> replacements = this.licenseCounter.getVarData();
        for (String key : replacements.keySet()) {
            text = text.replaceAll("\\$ANNOUNCER_" + key, replacements.get(key));
        }
        return text;
    }

    public String getBannerType(NotificationCacheEntry notificationCacheEntry) {
        return DisplayTypeHolder.getBannerType(notificationCacheEntry.getDisplayType());
    }

    public String getHtml(HttpServletRequest request) {
        if (this.licenseCounter.areFlagsSupported()) {
            this.webResourceManager.requireResource("com.atlassian.auiplugin:aui-flag");
        }
        this.webResourceManager.requireResourcesForContext("atl.general");
        this.webResourceManager.requireResourcesForContext("wittified.announcements");
        Map<String, Object> context = this.getTopNavigationContext(request);
        String currentKey = request.getParameter("projectKey") != null ? request.getParameter("projectKey") : "null";
        try {
            String servletPath;
            if ((currentKey == null || "null".equals(currentKey)) && StringUtils.isNotBlank(servletPath = request.getServletPath())) {
                Object project;
                if (servletPath.startsWith("/projects/")) {
                    String[] projectPath;
                    if (StringUtils.isNotBlank(servletPath = servletPath.replace("/projects/", "")) && (projectPath = servletPath.split("/")).length > 0) {
                        currentKey = projectPath[0];
                    }
                } else if (servletPath.startsWith("/browse/") && (project = context.get("selectedProject")) != null) {
                    ProjectImpl selectedProject = (ProjectImpl)project;
                    currentKey = selectedProject.getKey();
                }
            }
        }
        catch (Exception e) {
            logger.info("ANNOUNCER-09122022 : Could not derive the current project ", (Throwable)e);
        }
        UserProfile user = this.userManager.getRemoteUser();
        String currentToken = this.tokenChangeService.getToken();
        String uKey = "anon";
        if (user != null) {
            uKey = DigestUtils.sha256Hex((String)user.getUserKey().getStringValue());
        }
        context.put("user", uKey);
        String value = this.getCookieValue("wit-announce-bnr", request);
        if (value != null) {
            logger.debug("Looking for " + value);
            logger.debug(" Found " + currentToken + "-" + uKey);
            if (currentToken == null || value.equals(currentToken + "-" + uKey)) {
                return "";
            }
        }
        Object announcerNotifications = request.getAttribute("Announcer_Notifications");
        List<NotificationCacheEntry> notifications = null;
        if (announcerNotifications != null) {
            NotificationCacheList allNotifications = (NotificationCacheList)announcerNotifications;
            notifications = allNotifications.getEntries();
        }
        if (CollectionUtils.isEmpty(notifications)) {
            HashMap<String, Object> cookieContext = new HashMap<String, Object>();
            cookieContext.put("cookieVal", currentToken + "-" + uKey);
            return this.render("templates/cookie-set.vm", cookieContext);
        }
        context.put("notifications", notifications);
        context.put("loadTime", System.currentTimeMillis());
        context.put("action", context.get("helper"));
        context.put("isRest", false);
        context.put("D", "$");
        context.put("config", this.globalConfigurationService.getGlobalConfiguration());
        context.put("remindMeLaterExplainerText", this.globalConfigurationService.getRemindMeLaterExplainerText().trim().replaceAll("[\n\r]", ""));
        context.put("wittifiedHelper", this);
        context.put("currentKey", currentKey);
        context.put("product", this.licenseCounter.getApplicationType());
        if (request.getRequestURI().contains("/plugins/servlet/wittified/admin") || request.getRequestURI().contains("/plugins/servlet/upm")) {
            context.put("ignoreThis", true);
        } else if (request.getRequestURI().contains("/secure/PortfolioPlanView.jspa")) {
            context.put("ignoreThis", true);
        } else {
            context.put("ignoreThis", false);
        }
        String content = this.render("templates/banner-notifications.vm", context);
        return content;
    }

    public String getCurrentKey(Object obj, String requestURI) {
        logger.debug("requestURI:" + requestURI);
        JiraHelper jiraHelper = (JiraHelper)obj;
        if (jiraHelper != null && jiraHelper.getProject() != null) {
            String projectKey = jiraHelper.getProject().getKey();
            if (requestURI.equals("/") || requestURI.contains("MyJiraHome.jspa") || requestURI.contains("Dashboard.jspa")) {
                return null;
            }
            return projectKey;
        }
        return null;
    }

    public boolean isUserInGroup(String group) {
        if (group == null || group.isEmpty()) {
            return true;
        }
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            return false;
        }
        return this.userManager.isUserInGroup(userKey, group);
    }

    public boolean displayNotification(NotificationCacheEntry notification, String projectKey) {
        return this.licenseCounter.displayNotification(notification, projectKey);
    }

    public boolean isUserInGroups(String username, NotificationCacheEntry notification) {
        String[] groups = notification.getGroupTarget().split(",");
        boolean found = false;
        for (String group : groups) {
            if (!this.userManager.isUserInGroup(username, group)) continue;
            found = true;
            break;
        }
        return found;
    }

    public String getDialogHeight() {
        String value = this.globalConfigurationService.getDialogHeight();
        if (value == null) {
            return "500";
        }
        if (value.equals("")) {
            return "500";
        }
        return value;
    }

    protected String render(String template, Map<String, Object> context) {
        try {
            String fragmentSource = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(template));
            return this.templateRenderer.renderFragment(fragmentSource, context);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getCookieValue(String name, HttpServletRequest request) {
        if (request.getCookies() == null) {
            return "";
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return "";
    }
}

