/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.panels;

import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.web.context.HttpContext;
import com.wittified.DisplayTypeHolder;
import com.wittified.ao.NotificationService;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.cache.NotificationCacheList;
import com.wittified.format.FormatService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.services.GlobalConfigurationService;
import com.wittified.services.TokenChangeService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BannerPanelContextProvider
implements ContextProvider {
    private static final Logger logger = LoggerFactory.getLogger(BannerPanelContextProvider.class);
    private final UserManager userManager;
    private final NotificationService notificationService;
    private final HttpContext httpContext;
    private final LicenseCounter licenseCounter;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TokenChangeService tokenChangeService;
    private final WebResourceManager webResourceManager;
    private final FormatService formatService;
    private final GlobalConfigurationService globalConfigurationService;

    public BannerPanelContextProvider(NotificationService notificationService, UserManager userManager, HttpContext httpContext, LicenseCounter licenseCounter, PluginSettingsFactory pluginSettingsFactory, TokenChangeService tokenChangeService, WebResourceManager webResourceManager, FormatService formatService, GlobalConfigurationService globalConfigurationService) {
        this.notificationService = notificationService;
        this.userManager = userManager;
        this.httpContext = httpContext;
        this.licenseCounter = licenseCounter;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.tokenChangeService = tokenChangeService;
        this.webResourceManager = webResourceManager;
        this.formatService = formatService;
        this.globalConfigurationService = globalConfigurationService;
    }

    public void init(Map<String, String> params) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        if (this.licenseCounter.areFlagsSupported()) {
            this.webResourceManager.requireResource("com.atlassian.auiplugin:aui-flag");
        }
        this.webResourceManager.requireResourcesForContext("atl-notifier");
        UserProfile user = this.userManager.getRemoteUser();
        List<NotificationCacheEntry> notifications = Collections.EMPTY_LIST;
        String value = this.getCookieValue("wit-announce-bnr", this.httpContext.getRequest());
        if (value != null) {
            String currentToken = this.tokenChangeService.getToken();
            logger.debug(currentToken);
            String uKey = "anon";
            if (user != null) {
                uKey = DigestUtils.sha256Hex((String)this.userManager.getRemoteUserKey().getStringValue());
            }
            logger.debug("Looking for " + value);
            logger.debug(" Found " + currentToken + "-" + uKey);
            if (currentToken != null && !value.equals(currentToken + "-" + uKey)) {
                Object announcerNotifications = this.httpContext.getRequest().getAttribute("Announcer_Notifications");
                if (announcerNotifications != null) {
                    NotificationCacheList allNotifications = (NotificationCacheList)announcerNotifications;
                    notifications = allNotifications.getEntries();
                }
                if (notifications.size() < 0) {
                    WeakHashMap<String, String> cookieContext = new WeakHashMap<String, String>();
                    cookieContext.put("cookieVal", currentToken + "-" + uKey);
                }
                context.put("notifications", notifications);
            }
            context.put("user", uKey);
        }
        String key = null;
        if (this.licenseCounter.getApplicationType().equals("CONFLUENCE")) {
            key = this.getCurrentKey(context.get("action"));
        } else if (this.licenseCounter.getApplicationType().equals("STASH") || this.licenseCounter.getApplicationType().equals("BITBUCKET")) {
            key = this.getCurrentKey(context.get("request"));
            logger.debug("KEY: " + key);
        }
        context.put("D", "$");
        context.put("currentKey", key);
        context.put("wittifiedHelper", this);
        context.put("config", this.globalConfigurationService.getGlobalConfiguration());
        context.put("remindMeLaterExplainerText", this.globalConfigurationService.getRemindMeLaterExplainerText().trim().replaceAll("[\n\r]", ""));
        context.put("isRest", false);
        context.put("loadTime", System.currentTimeMillis());
        String requestURI = this.httpContext.getRequest().getRequestURI();
        if (requestURI.contains("/plugins/servlet/wittified/admin") || requestURI.contains("/plugins/servlet/upm")) {
            context.put("ignoreThis", true);
        } else if (requestURI.contains("/secure/PortfolioPlanView.jspa")) {
            context.put("ignoreThis", true);
        } else {
            context.put("ignoreThis", false);
        }
        return context;
    }

    public String getBannerType(NotificationCacheEntry notificationCacheEntry) {
        return DisplayTypeHolder.getBannerType(notificationCacheEntry.getDisplayType());
    }

    public String format(NotificationCacheEntry notification) {
        return this.formatService.formatThis(notification.getFormat(), this.handleVars(notification.getHtml()));
    }

    public String handleVars(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        Map<String, String> replacements = this.licenseCounter.getVarData();
        for (String key : replacements.keySet()) {
            text = text.replaceAll("\\$ANNOUNCER_" + key, replacements.get(key));
        }
        return text;
    }

    public String getDialogHeight() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.dialog.height");
        if (value == null) {
            return "500";
        }
        if (value.equals("")) {
            return "500";
        }
        return value;
    }

    public boolean isUserInGroup(String group) {
        if (group == null || group.isEmpty()) {
            return false;
        }
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            return false;
        }
        return this.userManager.isUserInGroup(userKey, group);
    }

    public boolean isUserInGroups(String username, NotificationCacheEntry notification) {
        String[] groups = notification.getGroupTarget().split(",");
        boolean found = false;
        for (String group : groups) {
            if (!this.userManager.isUserInGroup(username, group)) continue;
            found = true;
            break;
        }
        return found;
    }

    public String getCurrentKey(Object confluenceActionSupport) {
        if (confluenceActionSupport == null) {
            return null;
        }
        return this.licenseCounter.getProjectKey(confluenceActionSupport);
    }

    public boolean displayNotification(NotificationCacheEntry notification, String projectKey) {
        boolean isDisplayProject = true;
        boolean isDisplayCategory = true;
        boolean isDisplayGroup = true;
        boolean isFilterProject = false;
        boolean isFilterCategory = false;
        boolean isFilterGroup = false;
        if (notification.isNewUser && !this.licenseCounter.isNewUser(this.userManager.getRemoteUser())) {
            return false;
        }
        if (notification.getFilterProject()) {
            isFilterProject = true;
            if (projectKey == null) {
                logger.debug("Returning project key false");
                return false;
            }
            if (notification.getTargetProject() != null) {
                if (!notification.getTargetProject().contains(":" + projectKey + ":")) {
                    isDisplayProject = false;
                }
            } else {
                isDisplayProject = false;
            }
        }
        if (notification.getFilterProjectCategory()) {
            String[] categories;
            isFilterCategory = true;
            if (projectKey == null) {
                logger.debug("Returning project key false");
                return false;
            }
            if (notification.getTargetProjectCategories() != null && !this.licenseCounter.isProjInCategory(categories = notification.getTargetProjectCategories().split(","), projectKey)) {
                isDisplayCategory = false;
            }
        }
        logger.debug("Returning user is in group open: " + this.isUserInGroup(notification.getGroupTarget()));
        if (notification.getFilterGroups()) {
            isFilterGroup = true;
            isDisplayGroup = this.isUserInGroups(this.userManager.getRemoteUsername(), notification);
        }
        if (isFilterProject && isFilterCategory) {
            if (isFilterGroup) {
                return (isDisplayCategory || isDisplayProject) && isDisplayGroup;
            }
            return isDisplayCategory || isDisplayProject;
        }
        if (isFilterCategory) {
            if (isFilterGroup) {
                return isDisplayCategory && isDisplayGroup;
            }
            return isDisplayCategory;
        }
        if (isFilterProject) {
            if (isFilterGroup) {
                return isDisplayProject && isDisplayGroup;
            }
            return isDisplayProject;
        }
        if (isFilterGroup) {
            return isDisplayGroup;
        }
        return true;
    }

    private String getCookieValue(String name, HttpServletRequest request) {
        if (request.getCookies() == null) {
            return "";
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return "";
    }
}

