/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.scheduler.compat.JobInfo;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.job.TemporalAnnouncementActivationJobHandler;
import com.wittified.services.TokenChangeService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporalAnnouncementActivationJobHandlerImpl
implements TemporalAnnouncementActivationJobHandler {
    private final Logger logger = LoggerFactory.getLogger(TemporalAnnouncementActivationJobHandlerImpl.class);
    private final NotificationService notificationService;
    private final TokenChangeService tokenChangeService;
    private boolean devMode = false;

    public TemporalAnnouncementActivationJobHandlerImpl(NotificationService notificationService, TokenChangeService tokenChangeService) {
        this.notificationService = notificationService;
        this.tokenChangeService = tokenChangeService;
        this.devMode = false;
    }

    @Override
    public void execute(JobInfo jobInfo) {
        this.logger.info("Executing of temporal activation job for Announcer ");
        Date currentDate = new Date();
        boolean resetTheToken = false;
        for (Notification notification : this.getNotifications()) {
            boolean updateNotification;
            if (notification == null || notification.getDateRestrict() == null || !notification.getActive() || !notification.getDateRestrict().booleanValue() || !(updateNotification = this.notificationService.getUpdatedSchedule(notification))) continue;
            resetTheToken = true;
            this.saveNotification(notification);
        }
        if (resetTheToken) {
            this.resetTokens();
        }
    }

    public List<Notification> getNotifications() {
        return this.notificationService.getAllNotifications();
    }

    public void saveNotification(Notification notification) {
        this.notificationService.saveNotification(notification);
    }

    public void resetTokens() {
        this.tokenChangeService.updateToken();
    }
}

