/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import com.wittified.ao.AnonUser;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.ao.NotificationToAnonUser;
import com.wittified.ao.NotificationToNotificationUser;
import com.wittified.ao.NotificationUser;
import com.wittified.cache.NotificationCacheEntry;
import com.wittified.cache.NotificationCacheList;
import com.wittified.services.TokenChangeService;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationServiceImpl
implements NotificationService {
    static final Logger logger = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private final ActiveObjects activeObjects;
    private final TokenChangeService tokenChangeService;
    private final UserManager userManager;
    private final CrowdService crowdService;
    private final Cache userCache;
    private final Cache anonCache;
    private static final String USER_CACHE_NAME = "wittified.announcer.users";
    private static final String ANON_CACHE_NAME = "wittified.announcer.anon";
    private static final String SPLIT_TIME_DELIMETER = ":";
    private static final String SPLIT_DAY_DELIMETER = "#";

    public NotificationServiceImpl(ActiveObjects activeObjects, TokenChangeService tokenChangeService, UserManager userManager, CacheManager cacheManager, CrowdService crowdService) {
        this.activeObjects = activeObjects;
        this.tokenChangeService = tokenChangeService;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.userCache = cacheManager.getCache(USER_CACHE_NAME, null, new CacheSettingsBuilder().flushable().local().maxEntries(10000).build());
        this.anonCache = cacheManager.getCache(ANON_CACHE_NAME, null, new CacheSettingsBuilder().flushable().local().maxEntries(1000).build());
    }

    @Override
    public Notification createNewNotification() {
        return (Notification)this.activeObjects.create(Notification.class, new DBParam[0]);
    }

    @Override
    @Transactional
    public void saveNotification(Notification notification) {
        logger.debug(String.format("Saving notification %s", notification.getTitle()));
        this.tokenChangeService.updateToken();
        if (this.getUserCache() != null) {
            this.getUserCache().removeAll();
        }
        if (this.getAnonCache() != null) {
            this.getAnonCache().removeAll();
        }
        notification.save();
    }

    @Override
    @Deprecated
    public void saveNotificationAndUpdateCache(Notification notification, String cacheKey) {
        notification.save();
        if (BooleanUtils.isFalse(notification.getTempActive())) {
            return;
        }
        NotificationCacheList cacheList = this.getUserCacheEntry(cacheKey);
        boolean isNotificationInCache = false;
        if (cacheList != null && CollectionUtils.isNotEmpty(cacheList.getEntries())) {
            for (NotificationCacheEntry cache : cacheList.getEntries()) {
                if (cache == null || cache.getID() != notification.getID()) continue;
                isNotificationInCache = true;
                break;
            }
            if (!isNotificationInCache) {
                cacheList.getEntries().add(this.convertToCache(notification));
                this.getUserCache().put((Object)cacheKey, (Object)cacheList.toString());
            }
        }
    }

    private Cache getUserCache() {
        return this.userCache;
    }

    private Cache getAnonCache() {
        return this.anonCache;
    }

    @Override
    @Transactional
    public void deleteNotification(Notification notification) {
        logger.debug(String.format("Deleting notification %s", notification.getTitle()));
        for (NotificationToNotificationUser notificationToNotificationUser : (NotificationToNotificationUser[])this.activeObjects.find(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_ID = ? ", new Object[]{notification.getID()}))) {
            this.activeObjects.delete(new RawEntity[]{notificationToNotificationUser});
        }
        for (NotificationToAnonUser notificationToAnonUser : (NotificationToAnonUser[])this.activeObjects.find(NotificationToAnonUser.class, Query.select().where(" NOTIFICATION_ID = ? ", new Object[]{notification.getID()}))) {
            this.activeObjects.delete(new RawEntity[]{notificationToAnonUser});
        }
        this.activeObjects.delete(new RawEntity[]{notification});
        this.tokenChangeService.updateToken();
        this.getUserCache().removeAll();
        this.getAnonCache().removeAll();
        logger.debug(String.format("Deleted notification %s", notification.getTitle()));
    }

    @Override
    @Transactional
    public Notification getThisNotification(int id) {
        return (Notification)this.activeObjects.get(Notification.class, (Object)id);
    }

    @Override
    @Transactional
    public List<Notification> getAllNotifications() {
        Notification[] searchResults = (Notification[])this.activeObjects.find(Notification.class);
        return Arrays.asList(searchResults);
    }

    @Override
    @Transactional
    public NotificationCacheList getAllNotificationsForAnonymous(String anonymousId, String type) {
        boolean isInterceptRequest = type.equals("intercept");
        NotificationCacheList cacheList = this.getAllNotificationsForAnonymous(anonymousId);
        if (cacheList != null) {
            ArrayList<NotificationCacheEntry> filteredEntries = new ArrayList<NotificationCacheEntry>();
            for (NotificationCacheEntry notificationCacheEntry : cacheList.getEntries()) {
                if (isInterceptRequest) {
                    if (notificationCacheEntry.getType() == null) {
                        filteredEntries.add(notificationCacheEntry);
                        continue;
                    }
                    if (!notificationCacheEntry.getType().equals("intercept")) continue;
                    filteredEntries.add(notificationCacheEntry);
                    continue;
                }
                if (!notificationCacheEntry.getType().equals(type)) continue;
                filteredEntries.add(notificationCacheEntry);
            }
            return new NotificationCacheList(filteredEntries);
        }
        return new NotificationCacheList(new ArrayList<NotificationCacheEntry>());
    }

    @Override
    @Transactional
    public NotificationCacheList getAllNotificationsForAnonymous(String anonymousId) {
        logger.debug("Fetching notifications for anonymous");
        String cacheKey = anonymousId + ":all";
        NotificationCacheList cacheList = this.getAnonCacheEntry(cacheKey);
        if (cacheList != null) {
            return cacheList;
        }
        ArrayList<NotificationCacheEntry> notifications = new ArrayList<NotificationCacheEntry>();
        for (Notification notification : (Notification[])this.activeObjects.find(Notification.class, Query.select().where(" ACTIVE = ? AND ANONYMOUS = ? AND TEMP_ACTIVE = ? ", new Object[]{true, true, true}))) {
            boolean hasApproved = false;
            for (AnonUser anonUser : notification.getAnonUsers()) {
                if (!anonUser.getAnonId().equals(anonymousId)) continue;
                hasApproved = true;
            }
            if (hasApproved) continue;
            notifications.add(this.convertToCache(notification));
        }
        cacheList = new NotificationCacheList(notifications);
        this.getAnonCache().put((Object)cacheKey, (Object)cacheList.toString());
        return cacheList;
    }

    @Override
    @Transactional
    public NotificationCacheList getAllNotificationsForUser(UserProfile userProfile) {
        Notification[] tempActiveNotifications;
        String username = userProfile.getUsername();
        String userKey = userProfile.getUserKey().getStringValue();
        if (this.getUserCache() != null) {
            this.getUserCache().remove((Object)(username + ":all"));
        }
        String cacheKey = userKey + ":all";
        Notification[] dateRestrictedAndActiveNotifications = (Notification[])this.activeObjects.find(Notification.class, Query.select().where(" DATE_RESTRICT = ? AND ACTIVE = ? ", new Object[]{true, true}));
        Date thisMoment = new Date();
        for (Notification notification : dateRestrictedAndActiveNotifications) {
            boolean isTempActive;
            Calendar curr = Calendar.getInstance();
            curr.setTime(thisMoment);
            Calendar start = Calendar.getInstance();
            start.setTime(notification.getStartDate());
            Calendar end = Calendar.getInstance();
            end.setTime(notification.getEndDate());
            boolean derivedTempActive = isTempActive = BooleanUtils.isTrue(notification.getTempActive());
            if (notification.getCustomRecurrenceOption() && notification.getRecurringTypeOption()) {
                if (notification.getEndDate().after(thisMoment)) {
                    derivedTempActive = this.isActiveNotification(notification, "recurring");
                }
            } else if (notification.getCustomRecurrenceOption() && notification.getRunningTypeOption()) {
                derivedTempActive = this.isActiveNotification(notification, "running");
            } else if (notification.getCustomRecurrenceOption() && BooleanUtils.isTrue(notification.getRecurringWeeklyType())) {
                derivedTempActive = this.isActiveNotification(notification, "weekly_running");
            }
            if (!(isTempActive ^ derivedTempActive)) continue;
            notification.setTempActive(derivedTempActive);
            this.saveNotification(notification);
        }
        NotificationCacheList cacheList = this.getUserCacheEntry(cacheKey);
        if (cacheList != null) {
            logger.debug("Found and will return the cacheList for user:" + cacheList);
            return cacheList;
        }
        logger.debug("Unable to find the cacheList for user. Will make a db call.");
        ArrayList<NotificationCacheEntry> notifications = new ArrayList<NotificationCacheEntry>();
        for (Notification notification : tempActiveNotifications = (Notification[])this.activeObjects.find(Notification.class, Query.select().where(" ACTIVE = ? AND TEMP_ACTIVE = ? ", new Object[]{true, true}))) {
            boolean shouldContinue;
            logger.debug("Looping thru the list of notifications to check if the user has approved or not. notification title:" + notification.getTitle());
            if (Boolean.TRUE.equals(notification.getDateRestrict()) && !(shouldContinue = this.shouldProcessNotification(notification, userKey))) continue;
            boolean hasApproved = false;
            for (NotificationUser user : notification.getNotificationUsers()) {
                if (!userKey.equals(user.getUserKey())) continue;
                if (notification.getRecurringTypeOption() || notification.getRunningTypeOption() || BooleanUtils.isTrue(notification.getRecurringWeeklyType())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    Date acceptedDate = this.getNotificationToUser(notification.getID(), userKey).getAcceptDate();
                    Date currDate = new Date();
                    if (sdf.format(acceptedDate).equals(sdf.format(currDate))) {
                        hasApproved = true;
                        logger.debug("user with userkey:" + userKey + " has approved the notification:" + notification.getTitle());
                        continue;
                    }
                    if (!acceptedDate.before(currDate)) continue;
                    this.unConfirmThisNotificationForUser(notification.getID(), userProfile);
                    hasApproved = false;
                    continue;
                }
                if (notification.getCustomRecurrenceOption()) continue;
                hasApproved = true;
                logger.debug("user with userkey:" + userKey + " has approved the notification:" + notification.getTitle());
            }
            if (hasApproved) continue;
            if (notification.getFilterGroups()) {
                if (notification.getGroupTarget() == null || notification.getGroupTarget().isEmpty() || !this.isUserInGroups(username, notification)) continue;
                notifications.add(this.convertToCache(notification));
                logger.debug("Inside notification.getFilterGroups()... user with userkey:" + userKey + " has approved the notification:" + notification.getTitle());
                continue;
            }
            notifications.add(this.convertToCache(notification));
            logger.debug("Not inside filteredGroups user with userkey:" + userKey + " has approved the notification:" + notification.getTitle());
        }
        cacheList = new NotificationCacheList(notifications);
        this.getUserCache().put((Object)cacheKey, (Object)cacheList.toString());
        logger.debug("Returning cacheList.toString:" + cacheList.toString());
        return cacheList;
    }

    private boolean isUserInGroups(String username, Notification notification) {
        String[] groups = notification.getGroupTarget().split(",");
        boolean found = false;
        for (String group : groups) {
            if (!this.userManager.isUserInGroup(username, group)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public NotificationCacheList getAllNotificationsForUser(UserProfile user, String type) {
        boolean isInterceptRequest = type.equals("intercept");
        NotificationCacheList cacheList = this.getAllNotificationsForUser(user);
        if (cacheList != null) {
            ArrayList<NotificationCacheEntry> filteredEntries = new ArrayList<NotificationCacheEntry>();
            for (NotificationCacheEntry notificationCacheEntry : cacheList.getEntries()) {
                if (isInterceptRequest) {
                    if (notificationCacheEntry.getType() == null) {
                        filteredEntries.add(notificationCacheEntry);
                        continue;
                    }
                    if (!notificationCacheEntry.getType().equals("intercept")) continue;
                    filteredEntries.add(notificationCacheEntry);
                    continue;
                }
                if (!notificationCacheEntry.getType().equals(type)) continue;
                filteredEntries.add(notificationCacheEntry);
            }
            return new NotificationCacheList(filteredEntries);
        }
        return new NotificationCacheList(new ArrayList<NotificationCacheEntry>());
    }

    @Override
    public List<Notification> getAllConfirmedNotificationsForUser(UserProfile user) {
        NotificationUser notificationUser = this.getNotificationUser(user);
        return Arrays.asList(notificationUser.getNotifications());
    }

    private List<Notification> getAllConfirmedNotificationsForAnonymous(String anonId) {
        AnonUser notificationUser = this.getNotificationAnon(anonId);
        return Arrays.asList(notificationUser.getNotifications());
    }

    @Override
    public void unConfirmThisNotificationForUser(int id, UserProfile user) {
        NotificationUser notificationUser = this.getNotificationUser(user);
        for (NotificationToNotificationUser notificationToNotificationUser : (NotificationToNotificationUser[])this.activeObjects.find(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_ID = ? AND NOTIFICATION_USER_ID = ? ", new Object[]{id, notificationUser.getID()}))) {
            this.activeObjects.delete(new RawEntity[]{notificationToNotificationUser});
        }
        if (this.getUserCache() != null) {
            for (Object kObj : this.getUserCache().getKeys()) {
                if (!((String)kObj).startsWith(user.getUserKey().getStringValue() + SPLIT_TIME_DELIMETER)) continue;
                this.getUserCache().remove(kObj);
                break;
            }
        }
    }

    @Override
    public boolean confirmNotificationForUser(int notificationId, UserProfile user) {
        return this.confirmNotificationForUser(notificationId, user, -1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldProcessNotification(Notification notification, String userKey) {
        logger.debug("in date restrict");
        if (notification.getStartDate().getTime() > new Date().getTime()) {
            logger.error("Start date:" + notification.getStartDate().getTime() + ":new Date().getTime():" + new Date().getTime());
            logger.error(userKey + " user is trying to acknoledge the notification before the start date. It will be ignored");
            return false;
        }
        if (notification.getCustomRecurrenceOption() && notification.getRecurringTypeOption()) {
            logger.debug("getCustomRecurrenceOption && getRecurringTypeOption");
            Date currentDate = new Date();
            if (!notification.getEndDate().after(currentDate)) return false;
            if (this.isActiveNotification(notification, "recurring")) return true;
            return false;
        }
        if (!(notification.getCustomRecurrenceOption() && notification.getRunningTypeOption() ? !this.isActiveNotification(notification, "running") : notification.getCustomRecurrenceOption() && BooleanUtils.isTrue(notification.getRecurringWeeklyType()) && !this.isActiveNotification(notification, "weekly_running"))) return true;
        return false;
    }

    @Override
    public boolean confirmNotificationForUser(int notificationId, UserProfile user, long dwellTime) {
        boolean shouldContinue;
        String userName = user.getUsername();
        String userKey = user.getUserKey().getStringValue();
        logger.debug("confirming for " + notificationId + " and " + userName);
        logger.debug("confirming for " + notificationId + " and userKey " + userKey);
        Notification notification = this.getThisNotification(notificationId);
        boolean hasAlreadyApproved = false;
        for (NotificationUser notificationUser : notification.getNotificationUsers()) {
            if (!userKey.equals(notificationUser.getUserKey())) continue;
            hasAlreadyApproved = true;
            logger.debug("User had already confired notification:" + userKey);
        }
        if (Boolean.TRUE.equals(notification.getDateRestrict()) && !(shouldContinue = this.shouldProcessNotification(notification, userKey))) {
            return false;
        }
        if (StringUtils.isNotEmpty(notification.getGroupTarget()) && !this.isUserInGroups(userName, notification)) {
            logger.error("Preventing userkey [" + userKey + "] to acknoledge the notification since they are not part of the target group [" + notification.getGroupTarget() + "]");
            return false;
        }
        logger.debug("User hasAlreadyApproved notification:" + hasAlreadyApproved);
        if (!hasAlreadyApproved) {
            NotificationUser notificationUser = this.getNotificationUser(user);
            NotificationToNotificationUser notificationToNotificationUser = (NotificationToNotificationUser)this.activeObjects.create(NotificationToNotificationUser.class, new DBParam[0]);
            notificationToNotificationUser.setNotification(notification);
            notificationToNotificationUser.setAcceptDate(new Date());
            notificationToNotificationUser.setNotificationUser(notificationUser);
            notificationToNotificationUser.setDwellTime(dwellTime);
            logger.debug("Saving notifcation acceptace for User:" + notificationUser);
            notificationToNotificationUser.save();
            logger.debug("Saved notifcation acceptace for User:" + notificationUser);
            if (this.getUserCache() != null) {
                this.getUserCache().remove((Object)(userKey + SPLIT_TIME_DELIMETER));
                for (Object kObj : this.getUserCache().getKeys()) {
                    logger.debug("filtering cache " + (String)kObj);
                    if (!((String)kObj).startsWith(userKey + SPLIT_TIME_DELIMETER)) continue;
                    logger.debug("userKey:" + userKey + SPLIT_TIME_DELIMETER);
                    this.getUserCache().remove(kObj);
                }
            }
        }
        return !hasAlreadyApproved;
    }

    @Override
    public List<NotificationToNotificationUser> getNotificationToUser(int notificationId) {
        return Arrays.asList(this.activeObjects.find(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_ID = ? ", new Object[]{notificationId})));
    }

    @Transactional
    public boolean confirmNotificationForAnonymous(int notificationId, String anonymousId) {
        return this.confirmNotificationForAnonymous(notificationId, anonymousId, -1L);
    }

    @Override
    @Transactional
    public boolean confirmNotificationForAnonymous(int notificationId, String anonymousId, long dwellTime) {
        Notification notification = this.getThisNotification(notificationId);
        if (!notification.getAnonymous()) {
            return false;
        }
        boolean hasAlreadyApproved = false;
        for (AnonUser anonUser : notification.getAnonUsers()) {
            if (!anonUser.getAnonId().equals(anonymousId)) continue;
            hasAlreadyApproved = true;
        }
        if (!hasAlreadyApproved) {
            AnonUser anonUser = this.getNotificationAnon(anonymousId);
            NotificationToAnonUser notificationToAnonUser = (NotificationToAnonUser)this.activeObjects.create(NotificationToAnonUser.class, new DBParam[0]);
            notificationToAnonUser.setNotification(notification);
            notificationToAnonUser.setAnonUser(anonUser);
            notificationToAnonUser.setDwellTime(dwellTime);
            notificationToAnonUser.save();
        }
        for (Object kObj : this.getAnonCache().getKeys()) {
            if (!((String)kObj).startsWith(anonymousId + SPLIT_TIME_DELIMETER) || this.getAnonCache() == null) continue;
            this.getAnonCache().remove(kObj);
        }
        return !hasAlreadyApproved;
    }

    @Override
    public NotificationUser getNotificationUser(UserProfile user) {
        String username = user.getUsername();
        String userKey = user.getUserKey().getStringValue();
        logger.debug("announcer userkey :" + userKey);
        NotificationUser[] userKeySearchResults = (NotificationUser[])this.activeObjects.find(NotificationUser.class, Query.select().where(" USER_KEY = ? ", new Object[]{userKey}));
        if (userKeySearchResults.length > 0) {
            return userKeySearchResults[0];
        }
        NotificationUser notificationUser = (NotificationUser)this.activeObjects.create(NotificationUser.class, new DBParam[0]);
        notificationUser.setUser(username);
        notificationUser.setUserKey(userKey);
        notificationUser.save();
        return notificationUser;
    }

    @Override
    @Transactional
    public AnonUser getNotificationAnon(String anonymousId) {
        AnonUser[] searchResults = (AnonUser[])this.activeObjects.find(AnonUser.class, Query.select().where(" ANON_ID = ? ", new Object[]{anonymousId}));
        if (searchResults.length > 0) {
            if (searchResults[0].getCreated() == null) {
                searchResults[0].setCreated(new Date());
                searchResults[0].save();
            }
            return searchResults[0];
        }
        AnonUser notificationUser = (AnonUser)this.activeObjects.create(AnonUser.class, new DBParam[0]);
        notificationUser.setAnonId(anonymousId);
        notificationUser.setCreated(new Date());
        notificationUser.save();
        return notificationUser;
    }

    @Override
    @Transactional
    public long getAnonDwellTime(int notificationId, int anonId) {
        NotificationToAnonUser[] notificationToAnonUsers = (NotificationToAnonUser[])this.activeObjects.find(NotificationToAnonUser.class, Query.select().where(" NOTIFICATION_ID = ? AND ANON_USER_ID = ? ", new Object[]{notificationId, anonId}));
        if (notificationToAnonUsers != null && notificationToAnonUsers.length > 0) {
            NotificationToAnonUser notificationToAnonUser = notificationToAnonUsers[0];
            if (notificationToAnonUser.getDwellTime() == null) {
                return 0L;
            }
            return notificationToAnonUser.getDwellTime();
        }
        return 0L;
    }

    @Override
    @Transactional
    public long getTotalAnonDwellTime(int notificationId) {
        Notification theNotification = this.getThisNotification(notificationId);
        if (theNotification == null) {
            return 0L;
        }
        long totalDwellTime = 0L;
        if (theNotification.getTotalAnonDwell() != null) {
            totalDwellTime = theNotification.getTotalAnonDwell();
        }
        for (NotificationToAnonUser notificationToAnonUser : (NotificationToAnonUser[])this.activeObjects.find(NotificationToAnonUser.class, Query.select().where(" NOTIFICATION_ID = ?  ", new Object[]{notificationId}))) {
            if (notificationToAnonUser == null || notificationToAnonUser.getDwellTime() == null) continue;
            totalDwellTime += notificationToAnonUser.getDwellTime().longValue();
        }
        return totalDwellTime;
    }

    @Override
    @Transactional
    public long getTotalUserDwellTime(int notificationId) {
        Notification theNotification = this.getThisNotification(notificationId);
        if (theNotification == null) {
            return 0L;
        }
        long totalDwellTime = 0L;
        for (NotificationToNotificationUser notificationUser : (NotificationToNotificationUser[])this.activeObjects.find(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_ID = ?  ", new Object[]{notificationId}))) {
            if (notificationUser == null || notificationUser.getDwellTime() == null) continue;
            totalDwellTime += notificationUser.getDwellTime().longValue();
        }
        return totalDwellTime;
    }

    @Override
    @Transactional
    public Map<Integer, Date> getNotificationMapForNotification(int id) {
        HashMap<Integer, Date> userMap = new HashMap<Integer, Date>();
        for (NotificationToNotificationUser notificationToNotificationUser : (NotificationToNotificationUser[])this.activeObjects.find(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_ID = ? ", new Object[]{id}))) {
            userMap.put(notificationToNotificationUser.getID(), notificationToNotificationUser.getAcceptDate());
        }
        return userMap;
    }

    @Override
    @Transactional
    public void deleteAnonUser(int notificationId, String anonId) {
        AnonUser anonUser = this.getNotificationAnon(anonId);
        boolean deleteThis = true;
        for (NotificationToAnonUser notificationToAnonUser : (NotificationToAnonUser[])this.activeObjects.find(NotificationToAnonUser.class, Query.select().where(" ANON_USER_ID = ? ", new Object[]{anonUser.getID()}))) {
            if (notificationId == notificationToAnonUser.getNotification().getID()) {
                this.activeObjects.delete(new RawEntity[]{notificationToAnonUser});
                continue;
            }
            deleteThis = false;
        }
        if (deleteThis) {
            this.activeObjects.delete(new RawEntity[]{anonUser});
        }
    }

    @Override
    @Transactional
    public void migrateFromAnonToReal(String anonId, UserProfile user) {
        AnonUser anonUser = this.getNotificationAnon(anonId);
        for (NotificationToAnonUser notificationToAnonUser : (NotificationToAnonUser[])this.activeObjects.find(NotificationToAnonUser.class, Query.select().where(" ANON_USER_ID = ? ", new Object[]{anonUser.getID()}))) {
            int id = notificationToAnonUser.getNotification().getID();
            this.confirmNotificationForUser(id, user);
            this.activeObjects.delete(new RawEntity[]{notificationToAnonUser});
        }
        this.activeObjects.delete(new RawEntity[]{anonUser});
        for (Object kObj : this.getUserCache().getKeys()) {
            if (!((String)kObj).startsWith(user.getUserKey().getStringValue() + SPLIT_TIME_DELIMETER) || this.getUserCache() == null) continue;
            this.getUserCache().remove(kObj);
        }
    }

    @Override
    public List<Notification> getAllResetEnabledNotifications() {
        return Arrays.asList(this.activeObjects.find(Notification.class, Query.select().where("RESET_BUTTON = ? ", new Object[]{true})));
    }

    @Override
    @Transactional
    public void resetNotification(Notification notification) {
        this.deleteTheseItems(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_ID = ? ", new Object[]{notification.getID()}));
        this.deleteTheseItems(NotificationToAnonUser.class, Query.select().where(" NOTIFICATION_ID = ? ", new Object[]{notification.getID()}));
        notification.setTotalAnonDwell(0L);
        notification.setNumAnon(0);
        this.saveNotification(notification);
        this.tokenChangeService.updateToken();
        if (this.getAnonCache() != null) {
            this.getAnonCache().removeAll();
        }
        if (this.getUserCache() != null) {
            this.getUserCache().removeAll();
        }
    }

    @Override
    @Transactional
    public List<NotificationUser> getAllNotificationUsers() {
        NotificationUser[] searchResults = (NotificationUser[])this.activeObjects.find(NotificationUser.class);
        return Arrays.asList(searchResults);
    }

    @Override
    @Transactional
    public List<NotificationUser> getAllNotificationUsersWithKeyNull() {
        NotificationUser[] searchResults = (NotificationUser[])this.activeObjects.find(NotificationUser.class, Query.select().where("USER_KEY IS NULL", new Object[0]));
        return Arrays.asList(searchResults);
    }

    @Transactional
    private void deleteTheseItems(Class entityClass, Query baseQuery) {
        RawEntity[] selection = this.activeObjects.find(entityClass, baseQuery.limit(1000));
        while (selection.length != 0) {
            this.activeObjects.delete(selection);
            selection = this.activeObjects.find(entityClass, baseQuery.limit(1000));
        }
    }

    private NotificationCacheEntry convertToCache(Notification notification) {
        NotificationCacheEntry cacheEntry = new NotificationCacheEntry();
        cacheEntry.setID(notification.getID());
        cacheEntry.setTitle(notification.getTitle());
        cacheEntry.setHtml(notification.getHtml());
        cacheEntry.setDescription(notification.getDescription());
        cacheEntry.setFormat(notification.getFormat());
        cacheEntry.setType(notification.getType());
        cacheEntry.setIsRequired(notification.getIsRequired());
        cacheEntry.setAnonymous(notification.getAnonymous());
        cacheEntry.setFilterGroups(notification.getFilterGroups());
        if (notification.getNumAnon() != null) {
            cacheEntry.setNumAnon(notification.getNumAnon());
        }
        if (notification.getTotalAnonDwell() != null) {
            cacheEntry.setTotalAnonDwell(notification.getTotalAnonDwell());
        }
        if (notification.getGroupTarget() != null) {
            cacheEntry.setGroupTarget(notification.getGroupTarget());
        } else {
            cacheEntry.setGroupTarget("");
        }
        if (notification.getTargetProject() != null) {
            cacheEntry.setTargetProject(notification.getTargetProject());
        } else {
            cacheEntry.setTargetProject("::");
        }
        cacheEntry.setActive(notification.getActive());
        cacheEntry.setButtonText(notification.getButtonText());
        cacheEntry.setFilterProject(notification.getFilterProject());
        cacheEntry.setDelayButton(notification.getDelayButton());
        cacheEntry.setDisplayType(notification.getDisplay());
        cacheEntry.setShowButton(notification.getShowButton());
        cacheEntry.setFilterProjectCategory(notification.getFilterCategory());
        cacheEntry.setTargetProjectCategories(notification.getTargetCategories());
        cacheEntry.setFilterProjectRole(notification.getFilterProjectRole());
        cacheEntry.setTargetProjectRole(notification.getTargetProjectRole());
        cacheEntry.setNewUser(notification.getNewUserOption());
        return cacheEntry;
    }

    private NotificationCacheList getAnonCacheEntry(String cacheKey) {
        String stringVal = (String)this.getAnonCache().get((Object)cacheKey);
        if (stringVal == null) {
            return null;
        }
        NotificationCacheList list = new NotificationCacheList(stringVal);
        if (list.getExpirationTime() < System.currentTimeMillis()) {
            if (this.getAnonCache() != null) {
                this.getAnonCache().remove((Object)cacheKey);
            }
            return null;
        }
        return list;
    }

    private NotificationCacheList getUserCacheEntry(String cacheKey) {
        String stringVal = (String)this.getUserCache().get((Object)cacheKey);
        if (stringVal == null) {
            return null;
        }
        NotificationCacheList list = new NotificationCacheList(stringVal);
        if (list.getExpirationTime() < System.currentTimeMillis()) {
            if (this.getUserCache() != null) {
                this.getUserCache().remove((Object)cacheKey);
            }
            return null;
        }
        return list;
    }

    @Override
    public List<String> getPaginatedAcceptedUsers(Notification theNotification, int usersPerPage, int page) {
        List<RawEntity> notificationToNotificationUsers = Arrays.asList(this.activeObjects.find(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_ID = ? ", new Object[]{theNotification.getID()}).order("NOTIFICATION_USER_ID ASC").offset((page - 1) * usersPerPage).limit(usersPerPage)));
        return notificationToNotificationUsers.stream().map(notifToNotifUser -> notifToNotifUser.getNotificationUser().getUser()).collect(Collectors.toList());
    }

    @Override
    public NotificationToNotificationUser getNotificationToUser(int id, String userKey) {
        NotificationUser[] userKeySearchResults = (NotificationUser[])this.activeObjects.find(NotificationUser.class, Query.select().where(" USER_KEY = ? ", new Object[]{userKey}));
        if (userKeySearchResults.length > 0) {
            NotificationUser notifUser = userKeySearchResults[0];
            List<RawEntity> notifToUser = Arrays.asList(this.activeObjects.find(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_ID = ? AND NOTIFICATION_USER_ID = ?", new Object[]{id, notifUser.getID()})));
            if (notifToUser.isEmpty()) {
                return null;
            }
            return (NotificationToNotificationUser)notifToUser.get(0);
        }
        return null;
    }

    @Override
    public int getNotificationToUserCount(int id) {
        return this.activeObjects.count(NotificationToNotificationUser.class, Query.select().where(" NOTIFICATION_ID = ? ", new Object[]{id}));
    }

    @Override
    public List<User> getNotificationToUserForReport(int notificationId, final String searchTerm) {
        final ArrayList acceptedUsers = Lists.newArrayList();
        this.activeObjects.stream(NotificationToNotificationUser.class, Query.select((String)"ACCEPT_DATE, DWELL_TIME, NOTIFICATION_ID, NOTIFICATION_USER_ID, ID").where(" NOTIFICATION_ID = ? ", new Object[]{notificationId}), (EntityStreamCallback)new EntityStreamCallback<NotificationToNotificationUser, Integer>(){

            public void onRowRead(NotificationToNotificationUser notifToNotiUser) {
                User user = NotificationServiceImpl.this.crowdService.getUser(notifToNotiUser.getNotificationUser().getUser());
                if (StringUtils.isNoneBlank(searchTerm)) {
                    if (user.isActive() && (user.getName().toLowerCase().contains(searchTerm.toLowerCase()) || user.getDisplayName().toLowerCase().contains(searchTerm.toLowerCase()) || user.getEmailAddress().toLowerCase().contains(searchTerm.toLowerCase()))) {
                        acceptedUsers.add(user);
                    }
                } else {
                    acceptedUsers.add(user);
                }
            }
        });
        return acceptedUsers;
    }

    @Override
    public boolean isActiveNotification(Notification notification, String recurring) {
        Date currentDate = new Date();
        Calendar currCal = Calendar.getInstance();
        currCal.setTime(currentDate);
        if (recurring.equals("recurring")) {
            Date startDate = notification.getStartDate();
            Date endDate = notification.getEndDate();
            if (!currentDate.after(startDate) || !currentDate.before(endDate)) {
                return false;
            }
            String recurringType = notification.getRecurringType();
            if (StringUtils.isNoneBlank(recurringType) && recurringType.equals("weekly")) {
                int notifDayOfWeek;
                int dayOfWeek = currCal.get(7);
                return dayOfWeek == (notifDayOfWeek = notification.getDayOfWeek() % 7 + 1);
            }
            if (StringUtils.isNoneBlank(recurringType) && recurringType.equals("monthly")) {
                int dayOfMonth = currCal.get(5);
                return dayOfMonth == notification.getDayOfMonth();
            }
            if (StringUtils.isNoneBlank(recurringType) && recurringType.equals("lastDayOfMonth")) {
                int lastDayOfMonth;
                int dayOfMonth = currCal.get(5);
                return dayOfMonth == (lastDayOfMonth = currCal.getActualMaximum(5));
            }
        } else if (recurring.equals("running")) {
            String runningType = notification.getRunningType();
            Date startDate = notification.getStartDate();
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            Date endDate = null;
            if (StringUtils.isNoneBlank(runningType) && runningType.equals("days")) {
                cal.add(5, notification.getRunningFreq());
                endDate = cal.getTime();
                return currentDate.before(endDate);
            }
            if (StringUtils.isNoneBlank(runningType) && runningType.equals("weeks")) {
                cal.add(5, notification.getRunningFreq() * 7);
                endDate = cal.getTime();
                return currentDate.before(endDate);
            }
            if (StringUtils.isNoneBlank(runningType) && runningType.equals("months")) {
                cal.add(5, notification.getRunningFreq() * 30);
                endDate = cal.getTime();
                return currentDate.before(endDate);
            }
        } else if (recurring.equals("weekly_running")) {
            Date startDate = notification.getStartDate();
            Date endDate = notification.getEndDate();
            Date thisMoment = new Date();
            if (thisMoment.after(startDate) && thisMoment.before(endDate)) {
                String startTime = notification.getWeeklyStartTime();
                String endTime = notification.getWeeklyEndTime();
                String selectedDays = notification.getSelectedDays();
                if (StringUtils.isNotBlank(startTime) && StringUtils.isNotEmpty(endTime) && StringUtils.isNotEmpty(selectedDays)) {
                    Calendar start;
                    int day;
                    String[] startTimeHHMM = startTime.split(SPLIT_TIME_DELIMETER);
                    String[] endTimeHHMM = endTime.split(SPLIT_TIME_DELIMETER);
                    int[] days = Arrays.asList(selectedDays.split(SPLIT_DAY_DELIMETER)).stream().mapToInt(Integer::parseInt).toArray();
                    if (ArrayUtils.contains(days, day = (start = Calendar.getInstance()).get(7))) {
                        start.set(11, Integer.parseInt(startTimeHHMM[0]));
                        start.set(12, Integer.parseInt(startTimeHHMM[1]));
                        start.set(13, 0);
                        start.set(14, 0);
                        Calendar end = Calendar.getInstance();
                        end.set(11, Integer.parseInt(endTimeHHMM[0]));
                        end.set(12, Integer.parseInt(endTimeHHMM[1]));
                        end.set(13, 0);
                        end.set(14, 0);
                        Date dayStartTime = this.adjustTimetoLocalTimeZone(start.getTime(), notification);
                        Date dayEndTime = this.adjustTimetoLocalTimeZone(end.getTime(), notification);
                        return thisMoment.after(dayStartTime) && thisMoment.before(dayEndTime);
                    }
                }
            }
        }
        return false;
    }

    private Date adjustTimetoLocalTimeZone(Date date, Notification notification) {
        long epoch = date.getTime();
        Integer browserOffset = notification.getBrowserOffset();
        if (browserOffset == null) {
            return date;
        }
        try {
            Instant instant = Instant.now();
            String offset = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()).getOffset().toString();
            if (StringUtils.isNotBlank(offset) && offset.length() < 2) {
                return date;
            }
            String[] offsetArray = offset.split(SPLIT_TIME_DELIMETER);
            String offsetHours = offsetArray[0];
            String offsetMinutes = offsetArray[1];
            String sign = offsetHours.substring(0, 1);
            int hours = Integer.parseInt(offsetHours.substring(1, 3));
            int minutes = Integer.parseInt(offsetMinutes);
            int jvmTimeZoneOffset = hours * 60 + minutes;
            if ("-".equals(sign)) {
                jvmTimeZoneOffset *= -1;
            }
            long offsetMinsToAdjust = browserOffset + jvmTimeZoneOffset;
            long adjustedEpoch = epoch + offsetMinsToAdjust * 60L * 1000L;
            return new Date(adjustedEpoch);
        }
        catch (Exception e) {
            logger.debug("ANNOUNCER : Error while adjusting the timezone value for weekly announcements ", (Throwable)e);
            return date;
        }
    }

    @Override
    @Transactional
    public void saveNotificationExportStatus(Notification notification, boolean status) {
        notification.setActiveExportCsv(status);
        notification.save();
    }

    @Override
    public List<NotificationToAnonUser> getNotificationToAnonUser(int notificationId) {
        return Arrays.asList(this.activeObjects.find(NotificationToAnonUser.class, Query.select().where(" NOTIFICATION_ID = ? ", new Object[]{notificationId})));
    }

    @Override
    public boolean getUpdatedSchedule(Notification notification) {
        Date currentDate = new Date();
        boolean returnVal = false;
        boolean tempActive = notification.getTempActive();
        if (notification.getStartDate().before(currentDate)) {
            if (notification.getCustomRecurrenceOption() && notification.getRecurringTypeOption()) {
                boolean isActive;
                if (notification.getEndDate().after(currentDate) && tempActive != (isActive = this.isActiveNotification(notification, "recurring"))) {
                    notification.setTempActive(isActive);
                    returnVal = true;
                }
            } else if (notification.getCustomRecurrenceOption() && notification.getRunningTypeOption()) {
                boolean isActive = this.isActiveNotification(notification, "running");
                if (tempActive != isActive) {
                    notification.setTempActive(isActive);
                    returnVal = true;
                }
            } else if (notification.getCustomRecurrenceOption() && BooleanUtils.isTrue(notification.getRecurringWeeklyType())) {
                boolean isActive = this.isActiveNotification(notification, "weekly_running");
                if (tempActive != isActive) {
                    notification.setTempActive(isActive);
                    returnVal = true;
                }
            } else if (!tempActive && notification.getEndDate().after(currentDate)) {
                notification.setTempActive(true);
                returnVal = true;
            } else if (tempActive && notification.getEndDate().before(currentDate)) {
                notification.setTempActive(false);
                returnVal = true;
            }
        }
        return returnVal;
    }
}

