/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.servlets;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.collect.Lists;
import com.wittified.AnnouncerHelper;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.ao.statuspage.Incident;
import com.wittified.general.support.SupportBarService;
import com.wittified.licensecounters.LicenseCounter;
import com.wittified.rest.NotificationBean;
import com.wittified.services.InvalidNotificationService;
import com.wittified.services.statuspage.StatusPageService;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationAdminServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(NotificationAdminServlet.class);
    private final SupportBarService supportBarService;
    private final LicenseCounter licenseCounter;
    private final TemplateRenderer templateRenderer;
    private final WebResourceManager webResourceManager;
    private final UserManager userManager;
    private final NotificationService notificationService;
    private final PluginLicenseManager licenseStorageManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final WebSudoManager webSudoManager;
    private final InvalidNotificationService invalidNotificationService;
    private final StatusPageService statusPageService;

    public NotificationAdminServlet(TemplateRenderer templateRenderer, WebResourceManager webResourceManager, UserManager userManager, NotificationService notificationService, PluginLicenseManager licenseStorageManager, LicenseCounter licenseCounter, PluginSettingsFactory pluginSettingsFactory, WebSudoManager webSudoManager, SupportBarService supportBarService, InvalidNotificationService invalidNotificationService, StatusPageService statusPageService) {
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.licenseStorageManager = licenseStorageManager;
        this.licenseCounter = licenseCounter;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.webSudoManager = webSudoManager;
        this.supportBarService = supportBarService;
        this.invalidNotificationService = invalidNotificationService;
        this.statusPageService = statusPageService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.webResourceManager.requireResourcesForContext("atl-notifier");
        List<Object> notificationIds = Lists.newArrayList();
        String username = this.userManager.getRemoteUsername();
        String projectKey = req.getParameter("project");
        String pid = req.getParameter("pid");
        boolean filterProject = projectKey != null;
        boolean missedProjectCategories = false;
        String enabledProjectConfig = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (enabledProjectConfig == null) {
            enabledProjectConfig = "false";
        }
        enabledProjectConfig = enabledProjectConfig.toLowerCase();
        if (!filterProject || !enabledProjectConfig.equals("true")) {
            try {
                this.webSudoManager.willExecuteWebSudoRequest(req);
            }
            catch (WebSudoSessionException wes) {
                this.webSudoManager.enforceWebSudoProtection(req, res);
            }
        }
        if (username != null && (this.userManager.isAdmin(username) || this.licenseCounter.currentUserCanEdit(projectKey) && enabledProjectConfig.equals("true"))) {
            this.licenseCounter.prepareProjectView(projectKey);
            List<Notification> notificationList = this.notificationService.getAllNotifications();
            List<NotificationBean> notificationBeanList = AnnouncerHelper.getAllNotifications(notificationList);
            boolean allNotificationsAreDisabled = true;
            List<Object> activeNotifications = new ArrayList();
            List<Object> deactiveNotifications = new ArrayList();
            ArrayList<NotificationBean> invalidNotifications = new ArrayList<NotificationBean>();
            for (Notification notification : notificationList) {
                boolean grabItem = false;
                if (filterProject) {
                    if (notification.getFilterProject() && notification.getTargetProject() != null && !notification.getTargetProject().isEmpty() && notification.getTargetProject().equals(":" + projectKey + ":")) {
                        grabItem = true;
                    }
                } else {
                    grabItem = true;
                }
                if (!grabItem) continue;
                if (notification.getActive()) {
                    if (Boolean.TRUE.equals(notification.getDateRestrict())) {
                        boolean tempActive;
                        Date now = new Date();
                        if (!notification.getRunningTypeOption() && notification.getEndDate().getTime() < new Date().getTime()) {
                            notification.setActive(false);
                            notification.setTempActive(false);
                            this.notificationService.saveNotification(notification);
                            deactiveNotifications.add(new NotificationBean(notification));
                        } else if (BooleanUtils.isTrue((Boolean)notification.getRecurringWeeklyType())) {
                            boolean derivedActive = notification.getActive();
                            tempActive = notification.getTempActive();
                            if (now.after(notification.getStartDate()) && now.before(notification.getEndDate())) {
                                derivedActive = true;
                            }
                            if (derivedActive) {
                                boolean derivedTempActive = this.notificationService.isActiveNotification(notification, "weekly_running");
                                if (tempActive ^ derivedTempActive) {
                                    notification.setTempActive(derivedTempActive);
                                    this.notificationService.saveNotification(notification);
                                }
                                allNotificationsAreDisabled = false;
                                activeNotifications.add(new NotificationBean(notification));
                            } else {
                                notification.setActive(false);
                                notification.setTempActive(false);
                                this.notificationService.saveNotification(notification);
                                deactiveNotifications.add(new NotificationBean(notification));
                            }
                        } else if (!notification.getRunningTypeOption() && notification.getStartDate().getTime() < now.getTime()) {
                            boolean active = notification.getActive();
                            tempActive = notification.getTempActive();
                            if (!active || !tempActive) {
                                notification.setActive(true);
                                notification.setTempActive(true);
                                this.notificationService.saveNotification(notification);
                            }
                            allNotificationsAreDisabled = false;
                            activeNotifications.add(new NotificationBean(notification));
                        } else if (notification.getRunningTypeOption()) {
                            boolean isActive = this.notificationService.isActiveNotification(notification, "running");
                            notification.setActive(isActive);
                            notification.setTempActive(isActive && now.compareTo(notification.getStartDate()) > -1);
                            this.notificationService.saveNotification(notification);
                            if (isActive) {
                                allNotificationsAreDisabled = false;
                                activeNotifications.add(new NotificationBean(notification));
                            } else {
                                deactiveNotifications.add(new NotificationBean(notification));
                            }
                        } else {
                            allNotificationsAreDisabled = false;
                            activeNotifications.add(new NotificationBean(notification));
                        }
                    } else {
                        allNotificationsAreDisabled = false;
                        activeNotifications.add(new NotificationBean(notification));
                    }
                } else {
                    notification.setTempActive(false);
                    this.notificationService.saveNotification(notification);
                    deactiveNotifications.add(new NotificationBean(notification));
                }
                if (StringUtils.isNoneBlank(this.getMissedTargetGroups(notification)) || StringUtils.isNoneBlank(this.getMissedTargetProjects(notification))) {
                    notification.setActive(false);
                    notification.setTempActive(false);
                    this.notificationService.saveNotification(notification);
                    invalidNotifications.add(new NotificationBean(notification));
                }
                if ((this.licenseCounter.getApplicationType().equals("CONFLUENCE") || this.licenseCounter.getApplicationType().equals("JIRA")) && StringUtils.isNoneBlank(this.getMissedProjectCategories(notification)) && !invalidNotifications.contains(notification)) {
                    notification.setActive(false);
                    notification.setTempActive(false);
                    this.notificationService.saveNotification(notification);
                    invalidNotifications.add(new NotificationBean(notification));
                }
                if (!this.licenseCounter.getApplicationType().equals("JIRA") || !StringUtils.isNoneBlank(this.getMissedTargetProjectRoles(notification)) || invalidNotifications.contains(notification)) continue;
                notification.setActive(false);
                notification.setTempActive(false);
                this.notificationService.saveNotification(notification);
                invalidNotifications.add(new NotificationBean(notification));
            }
            deactiveNotifications = deactiveNotifications.stream().filter(notif -> !invalidNotifications.contains(notif)).collect(Collectors.toList());
            activeNotifications = activeNotifications.stream().filter(notif -> !invalidNotifications.contains(notif)).collect(Collectors.toList());
            logger.debug("---------SUPPORT-3882---------");
            logger.debug("sorting active notifications");
            Collections.sort(activeNotifications, Comparator.nullsLast(Comparator.comparing(NotificationBean::getTitle, Comparator.nullsLast(Comparator.naturalOrder()))));
            logger.debug("sorting deactive notifications");
            Collections.sort(deactiveNotifications, Comparator.nullsLast(Comparator.comparing(NotificationBean::getTitle, Comparator.nullsLast(Comparator.naturalOrder()))));
            logger.debug("sorting invalid notifications");
            Collections.sort(invalidNotifications, Comparator.nullsLast(Comparator.comparing(NotificationBean::getTitle, Comparator.nullsLast(Comparator.naturalOrder()))));
            logger.debug("---------SUPPORT-3882---------");
            Incident[] incidents = this.statusPageService.getAllIncidents();
            notificationIds = Arrays.asList(incidents).stream().map(e -> e.getNotification().getID()).collect(Collectors.toList());
            PluginLicense license = (PluginLicense)this.licenseStorageManager.getLicense().getOrElse((Object)null);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("notifications", notificationBeanList);
            context.put("deactiveNotifications", deactiveNotifications);
            context.put("activeNotifications", activeNotifications);
            context.put("invalidNotifications", invalidNotifications);
            context.put("announcerHelper", new AnnouncerHelper());
            context.put("pid", pid);
            context.put("allNotificationsAreDisabled", allNotificationsAreDisabled);
            context.put("license", this.getCheckLicense());
            context.put("product", this.licenseCounter.getApplicationType());
            context.put("action", (Object)this);
            context.put("numUsers", this.licenseCounter.getNumberOfUsers());
            context.put("contextPath", req.getContextPath());
            context.put("filterProject", filterProject);
            context.put("projectKey", projectKey);
            context.put("supportbarHtml", this.supportBarService.getHtml());
            context.put("wittifiedXsfrToken", this.licenseCounter.getXsfrToken(req, res));
            context.put("notificationIds", notificationIds);
            res.setContentType("text/html");
            this.render("/templates/admin-wrapper.vm", context, res);
        } else {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("message", "The user that you're currently logged in as is not an administrator. This page is limited to administrator access.");
            res.setContentType("text/html");
            this.render("/templates/security-breach.vm", context, res);
        }
    }

    public String getMissedTargetGroups(Notification notification) {
        return this.invalidNotificationService.getMissedTargetGroups(notification);
    }

    public String getMissedProjectCategories(Notification notification) {
        return this.invalidNotificationService.getMissedTargetProjectCategories(notification);
    }

    protected void render(String template, Map<String, Object> context, HttpServletResponse response) throws IOException {
        this.templateRenderer.render(template, context, (Writer)response.getWriter());
    }

    public boolean getProjectConfigEnabled() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.projects");
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public String getUserAgent() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.ignored.userAgents");
        if (value == null) {
            return "";
        }
        return value;
    }

    public String getDialogHeight() {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get("wittified.announcer.dialog.height");
        if (value == null) {
            return "";
        }
        return value;
    }

    public int getNumUsers(NotificationBean notification) {
        if (notification == null) {
            return this.licenseCounter.getNumberOfUsers();
        }
        String groupName = null;
        if (notification.getGroupTarget() != null) {
            groupName = notification.getGroupTarget().split(",")[0];
        }
        if (notification.getFilterGroups() == null) {
            groupName = null;
        }
        logger.debug("Looking up " + groupName);
        if (groupName == null || groupName.isEmpty()) {
            return this.licenseCounter.getNumberOfUsers();
        }
        String[] groups = new String[]{};
        if (notification.getGroupTarget() != null) {
            groups = notification.getGroupTarget().split(",");
        }
        HashSet<String> set = new HashSet<String>();
        for (String group : groups) {
            set.addAll(this.licenseCounter.getUserNamesInGroup(group));
        }
        return set.size();
    }

    public String getMissedTargetProjects(Notification notification) {
        return this.invalidNotificationService.getMissedTargetProjects(notification);
    }

    public String getMissedTargetProjectRoles(Notification notification) {
        return this.invalidNotificationService.getMissedTargetProjectRoles(notification);
    }

    public String getCheckLicense() {
        if (this.licenseStorageManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseStorageManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                if (((LicenseError)pluginLicense.getError().get()).name().equals("EXPIRED")) {
                    return "The evaluation license has expired. Please contact your System administrator";
                }
                return "An error occurred while validating your license for this plugin: " + ((LicenseError)pluginLicense.getError().get()).name();
            }
            return null;
        }
        return "Plugin is not licensed. In order to evaluate this plugin you need to create an evaluation license";
    }
}

