/*
 * Decompiled with CFR 0.152.
 */
package com.wittified.job;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.wittified.ao.Notification;
import com.wittified.ao.NotificationService;
import com.wittified.services.TokenChangeService;
import java.util.Date;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceTemporalAnnouncementJob
implements JobRunner {
    private final Logger logger = LoggerFactory.getLogger(ConfluenceTemporalAnnouncementJob.class);
    private final NotificationService notificationService;
    private final TokenChangeService tokenChangeService;

    public ConfluenceTemporalAnnouncementJob(NotificationService notificationService, TokenChangeService tokenChangeService) {
        this.notificationService = notificationService;
        this.tokenChangeService = tokenChangeService;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            boolean resetTheToken = false;
            long currentTime = new Date().getTime();
            for (Notification notification : this.notificationService.getAllNotifications()) {
                if (!Boolean.TRUE.equals(notification.getActive()) || !Boolean.TRUE.equals(notification.getDateRestrict())) continue;
                long endTime = 0L;
                long startTime = 99999999999999999L;
                if (notification.getEndDate() != null) {
                    endTime = notification.getEndDate().getTime();
                }
                if (notification.getStartDate() != null) {
                    startTime = notification.getStartDate().getTime();
                }
                this.logger.debug("Comparing notification date for: " + notification.getTitle() + " (" + notification.getID() + ")");
                this.logger.debug("  " + notification.getTempActive() + " " + notification.getEndDate() + " " + notification.getStartDate() + " " + new Date());
                this.logger.debug("  " + notification.getTempActive() + " " + endTime + " " + startTime + " " + currentTime);
                boolean updateNotification = this.notificationService.getUpdatedSchedule(notification);
                if (!updateNotification) continue;
                resetTheToken = true;
                this.notificationService.saveNotification(notification);
            }
            if (resetTheToken) {
                this.tokenChangeService.updateToken();
            }
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return JobRunnerResponse.failed((Throwable)e);
        }
    }
}

