/*
 * Decompiled with CFR 0.152.
 */
package com.tse.confluence.purgerecyclebin.plugin.api;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.permissions.Operation;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.Target;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.api.service.permissions.OperationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeRecycleBinUtil;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeTrashAO;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeTrashAOMgr;
import com.tse.confluence.purgerecyclebin.plugin.model.MessageBean;
import com.tse.confluence.purgerecyclebin.plugin.model.PurgeConfigBean;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

@Path(value="/utility")
public class PurgeRecycleBinResource {
    private static final Logger LOGGER = Logger.getLogger(PurgeRecycleBinResource.class);
    private final PurgeRecycleBinUtil purgeRecycleBinUtill;
    @ComponentImport
    private final PersonService personService;
    @ComponentImport
    private final OperationService operationService;
    @ComponentImport
    private final SpaceService spaceService;
    private final PurgeTrashAOMgr purgeTrashAOMgr;

    @Inject
    public PurgeRecycleBinResource(PurgeRecycleBinUtil purgeRecycleBinUtill, PersonService personService, OperationService operationService, SpaceService spaceService, PurgeTrashAOMgr purgeTrashAOMgr) {
        this.purgeRecycleBinUtill = purgeRecycleBinUtill;
        this.personService = personService;
        this.operationService = operationService;
        this.spaceService = spaceService;
        this.purgeTrashAOMgr = purgeTrashAOMgr;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/config")
    public Response getPurgeConfigSummary(@QueryParam(value="spaceKey") String spaceKey) {
        MessageBean messageBean = new MessageBean();
        if (spaceKey == null || "".equals(spaceKey)) {
            messageBean.setMessage("Space key field value missing.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Space space = (Space)this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetchOrNull();
        if (space == null) {
            messageBean.setMessage("Space key (" + spaceKey + ") not exists.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Person loggedInAppUser = this.personService.getCurrentUser(new Expansion[0]);
        boolean isSpaceAdminPermission = this.operationService.canPerform(loggedInAppUser, (Operation)OperationKey.ADMINISTER, Target.forModelObject((Object)space)).isAuthorized();
        if (!isSpaceAdminPermission) {
            messageBean.setMessage("[Error] Space Admin Permission denied.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        PurgeConfigBean configBean = new PurgeConfigBean();
        PurgeTrashAO purgeTrashConfigEntity = this.purgeTrashAOMgr.getPurgeTrashSpaceConfig(space);
        if (purgeTrashConfigEntity != null) {
            configBean.setDaysKeep(purgeTrashConfigEntity.getDaysKeep());
            configBean.setSpaceId(purgeTrashConfigEntity.getSpaceId());
            configBean.setSpaceKey(purgeTrashConfigEntity.getSpaceKey());
            configBean.setStatus(purgeTrashConfigEntity.getStatus());
        }
        return Response.ok((Object)configBean).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/config")
    public Response updatePurgeConfigSummary(PurgeConfigBean configBean) {
        MessageBean messageBean = new MessageBean();
        if (configBean.getSpaceKey() == null || "".equals(configBean.getSpaceKey())) {
            messageBean.setMessage("Space key field value missing.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Space space = (Space)this.spaceService.find(new Expansion[0]).withKeys(new String[]{configBean.getSpaceKey()}).fetchOrNull();
        if (space == null) {
            messageBean.setMessage("Space key (" + configBean.getSpaceKey() + ") not exists.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Person loggedInAppUser = this.personService.getCurrentUser(new Expansion[0]);
        boolean isSpaceAdminPermission = this.operationService.canPerform(loggedInAppUser, (Operation)OperationKey.ADMINISTER, Target.forModelObject((Object)space)).isAuthorized();
        if (!isSpaceAdminPermission) {
            messageBean.setMessage("[Error] Space Admin Permission denied.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        PurgeTrashAO purgeTrashConfigEntity = this.purgeTrashAOMgr.updatePurgeTrashSpaceKey(space, configBean);
        if (purgeTrashConfigEntity != null) {
            messageBean.setMessage("Updated configuration.");
        }
        return Response.ok((Object)messageBean).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/config")
    public Response deletePurgeConfigSummary(@QueryParam(value="spaceKey") String spaceKey) {
        MessageBean messageBean = new MessageBean();
        if (spaceKey == null || "".equals(spaceKey)) {
            messageBean.setMessage("Space key field value missing.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Space space = (Space)this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetchOrNull();
        if (space == null) {
            messageBean.setMessage("Space key (" + spaceKey + ") not exists.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Person loggedInAppUser = this.personService.getCurrentUser(new Expansion[0]);
        boolean isSpaceAdminPermission = this.operationService.canPerform(loggedInAppUser, (Operation)OperationKey.ADMINISTER, Target.forModelObject((Object)space)).isAuthorized();
        if (!isSpaceAdminPermission) {
            messageBean.setMessage("[Error] Space Admin Permission denied.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        long index = this.purgeTrashAOMgr.removePurgeConfig(space);
        messageBean.setMessage("Removed Space Trash Config #" + index);
        messageBean.setStatus(index);
        return Response.ok((Object)messageBean).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/run/config")
    public Response getPurgeConfigRun(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="dryRun") boolean dryRun) {
        MessageBean messageBean = new MessageBean();
        if (spaceKey == null || "".equals(spaceKey)) {
            messageBean.setMessage("Space key field value missing.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        if (!this.purgeRecycleBinUtill.isActivePluginLicense()) {
            messageBean.setMessage("Purge Trash addon - " + this.purgeRecycleBinUtill.getPluginLicenseString());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Space space = (Space)this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetchOrNull();
        if (space == null) {
            messageBean.setMessage("Space key (" + spaceKey + ") not exists.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Person loggedInAppUser = this.personService.getCurrentUser(new Expansion[0]);
        boolean isSpaceAdminPermission = this.operationService.canPerform(loggedInAppUser, (Operation)OperationKey.ADMINISTER, Target.forModelObject((Object)space)).isAuthorized();
        if (!isSpaceAdminPermission) {
            messageBean.setMessage("[Error] Space Admin Permission denied.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        LOGGER.info((Object)MessageFormat.format("User {0} purging trash for spaceKey {1}", loggedInAppUser.getDisplayName(), space.getKey()));
        PurgeTrashAO purgeTrashConfigEntity = this.purgeTrashAOMgr.getPurgeTrashSpaceConfig(space);
        if (purgeTrashConfigEntity == null) {
            messageBean.setMessage("Purge configuration not saved yet.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        long startTime = System.currentTimeMillis();
        ArrayList<String> logs = new ArrayList<String>();
        long index = this.purgeRecycleBinUtill.purgeTrashForSpace(space, purgeTrashConfigEntity.getDaysKeep(), logs, dryRun);
        long totalTime = System.currentTimeMillis() - startTime;
        String dryTag = !dryRun ? "[Info]" : "[Dry run]";
        messageBean.setMessage(dryTag + " Space Trash purge Update (" + index + "). Took " + (double)totalTime / 1000.0 + " Seconds.");
        messageBean.setLogs(logs);
        return Response.ok((Object)messageBean).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/run/all/config")
    public Response getPurgeConfigRunAll(@QueryParam(value="daysKeep") int daysKeep, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="dryRun") boolean dryRun) {
        MessageBean messageBean = new MessageBean();
        if (daysKeep <= 0) {
            messageBean.setMessage("Keep days must be greater than 0.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        if (spaceKey == null || "".equals(spaceKey)) {
            messageBean.setMessage("Space key is required.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        if (!this.purgeRecycleBinUtill.isActivePluginLicense()) {
            messageBean.setMessage("Purge Trash addon - " + this.purgeRecycleBinUtill.getPluginLicenseString());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        long startTime = System.currentTimeMillis();
        ArrayList<String> logs = new ArrayList<String>();
        long index = 0L;
        if ("ALL-GLOBAL".equals(spaceKey) || "ALL-PERSONAL".equals(spaceKey)) {
            PageResponse spaceResponse = "ALL-GLOBAL".equalsIgnoreCase(spaceKey) ? this.spaceService.find(new Expansion[0]).withType(SpaceType.GLOBAL).fetchMany((PageRequest)new SimplePageRequest(0, 100000)) : this.spaceService.find(new Expansion[0]).withType(SpaceType.PERSONAL).fetchMany((PageRequest)new SimplePageRequest(0, 100000));
            List spaceObjects = spaceResponse.getResults();
            LOGGER.debug((Object)("All Global Spaces Count >>> " + spaceObjects.size()));
            Person loggedInAppUser = this.personService.getCurrentUser(new Expansion[0]);
            for (Space space : spaceObjects) {
                boolean isSpaceAdminPermission = this.operationService.canPerform(loggedInAppUser, (Operation)OperationKey.ADMINISTER, Target.forModelObject((Object)space)).isAuthorized();
                if (!isSpaceAdminPermission) {
                    LOGGER.info((Object)("[Error] Skipping space [" + space.getKey() + "], Space Admin Permission denied."));
                    continue;
                }
                index += this.purgeRecycleBinUtill.purgeTrashForSpace(space, daysKeep, logs, dryRun);
            }
        }
        long totalTime = System.currentTimeMillis() - startTime;
        String dryTag = !dryRun ? "[Info]" : "[Dry run]";
        messageBean.setMessage(dryTag + " All Spaces Trash purge Update (" + index + "). Took " + (double)totalTime / 1000.0 + " Seconds.");
        messageBean.setLogs(logs);
        return Response.ok((Object)messageBean).build();
    }
}

