/*
 * Decompiled with CFR 0.152.
 */
package com.tse.confluence.purgerecyclebin.plugin.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeTrashAO;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeTrashAOMgr;
import com.tse.confluence.purgerecyclebin.plugin.model.PurgeConfigBean;
import java.text.MessageFormat;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;

@Named
public class PurgeTrashAOMgrImpl
implements PurgeTrashAOMgr {
    private static final Logger LOGGER = Logger.getLogger(PurgeTrashAOMgrImpl.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public PurgeTrashAOMgrImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public PurgeTrashAO[] getPurgeTrashSpaces() {
        return (PurgeTrashAO[])this.ao.find(PurgeTrashAO.class, Query.select());
    }

    @Override
    public PurgeTrashAO[] getPurgeTrashSpacesActive() {
        return (PurgeTrashAO[])this.ao.find(PurgeTrashAO.class, Query.select().where("STATUS = 'true'", new Object[0]).order("ID DESC"));
    }

    @Override
    public PurgeTrashAO getPurgeTrashSpaceConfig(Space space) {
        PurgeTrashAO[] properties = (PurgeTrashAO[])this.ao.find(PurgeTrashAO.class, Query.select().where("SPACE_ID = ?", new Object[]{space.getId()}).order("ID DESC"));
        return properties.length > 0 ? properties[0] : null;
    }

    @Override
    public PurgeTrashAO updatePurgeTrashSpaceKey(Space space, PurgeConfigBean configBean) {
        PurgeTrashAO[] properties = (PurgeTrashAO[])this.ao.find(PurgeTrashAO.class, Query.select().where("SPACE_ID = ?", new Object[]{space.getId()}).order("ID DESC"));
        if (properties.length > 0) {
            LOGGER.debug((Object)MessageFormat.format("Updating. {0} : {1}.", space.getKey(), configBean.getDaysKeep()));
            PurgeTrashAO property = properties[0];
            property.setSpaceKey(space.getKey());
            property.setSpaceId(space.getId());
            property.setDaysKeep(configBean.getDaysKeep());
            property.setStatus(configBean.isStatus());
            property.save();
            return property;
        }
        LOGGER.debug((Object)MessageFormat.format("Adding. {0} : {1}.", space.getKey(), configBean.getDaysKeep()));
        PurgeTrashAO property = (PurgeTrashAO)this.ao.create(PurgeTrashAO.class, new DBParam[0]);
        property.setSpaceKey(space.getKey());
        property.setSpaceId(space.getId());
        property.setDaysKeep(configBean.getDaysKeep());
        property.setStatus(configBean.isStatus());
        property.save();
        return property;
    }

    @Override
    public long removePurgeConfig(Space space) {
        long status = 0L;
        PurgeTrashAO[] properties = (PurgeTrashAO[])this.ao.find(PurgeTrashAO.class, Query.select().where("SPACE_ID = ?", new Object[]{space.getId()}));
        if (properties.length > 0) {
            PurgeTrashAO property = properties[0];
            status = property.getID();
            this.ao.delete(new RawEntity[]{property});
        }
        return status;
    }
}

