/*
 * Decompiled with CFR 0.152.
 */
package com.tse.confluence.purgerecyclebin.plugin.api;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeRecycleBinUtil;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MyTrashSummaryMacro
implements Macro {
    private static final Logger LOGGER = Logger.getLogger(MyTrashSummaryMacro.class);
    private final PageBuilderService pageBuilderService;
    private final PurgeRecycleBinUtil purgeRecycleBinUtil;
    private final SpaceManager spaceManager;

    @Autowired
    public MyTrashSummaryMacro(@ComponentImport PageBuilderService pageBuilderService, PurgeRecycleBinUtil purgeRecycleBinUtil, SpaceManager spaceManager) {
        this.pageBuilderService = pageBuilderService;
        this.purgeRecycleBinUtil = purgeRecycleBinUtil;
        this.spaceManager = spaceManager;
    }

    public String execute(Space space, RenderContext renderContext) throws MacroException {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("spacekey", space.getKey());
        if ("preview".equals(renderContext.getOutputType())) {
            context.put("preview", "true");
        }
        return VelocityUtils.getRenderedTemplate((String)"templates/trash-summary-macro.vm", (Map)context);
    }

    public String execute(Map<String, String> map, String string, ConversionContext conversionContext) throws MacroExecutionException {
        try {
            this.pageBuilderService.assembler().resources().requireWebResource("com.tse.confluence.spaces3documents.plugin.confluence-space-s3-documents-plugin:confluence-space-s3-documents-plugin-resources");
            if (!this.purgeRecycleBinUtil.isActivePluginLicense()) {
                return "[Error] " + this.purgeRecycleBinUtil.getPluginLicenseString();
            }
            DefaultConversionContext defaultConversionContext = (DefaultConversionContext)conversionContext;
            PageContext renderContext = defaultConversionContext.getPageContext();
            Space space = this.spaceManager.getSpace(defaultConversionContext.getSpaceKey());
            if (map.get("spaceKey") != null && (space = this.spaceManager.getSpace(map.get("spaceKey"))) == null) {
                return "[Error] Invalid space key";
            }
            return this.execute(space, (RenderContext)renderContext);
        }
        catch (MacroException e) {
            throw new MacroExecutionException((Throwable)e);
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

