/* global AJS */

/*function tse_purgerecyclebin_validate_form() {
    AJS.$("#TsePurgeRecyclebinMessage").html("");
    if(AJS.$("#retentionInterval").val() === ""){
        AJS.$("#TsePurgeRecyclebinMessage").html("<span style='color: red;'>Retention Days Input required!</span>");
        return false;
    }else if(AJS.$.isNumeric(AJS.$("#retentionInterval").val()) === false){
        AJS.$("#TsePurgeRecyclebinMessage").html("<span style='color: red;'>Retention Days Input should be number!</span>");
        return false;
    }
    return true;
}

function tse_purgerecyclebin_details(spacekey) 
{
    AJS.$.ajax({
        url: "/rest/purgerecyclebin/1.0/content/list/space/key/"+spacekey,
        type: 'get',
        dataType: 'json',
        beforeSend: function() {
            AJS.$(".tse-message").text("Loading ...");
        },
        success: function(data) {
            console.log(JSON.stringify(data));
            
            AJS.$(".tse-message").text(""); //clear loading
            
            var trash_summary_tbody = AJS.$(".tse_trash_summary_tbody");
            trash_summary_tbody.empty();
            
            for( var i in data )
            {
                var j = data[i];
                var row = AJS.$("<tr />");
                row.append(AJS.$("<td />").append(i));
                row.append(AJS.$("<td />").append(j));
                trash_summary_tbody.append(row);
            }
        }
    });
}*/

function load_purge_trash_config() 
{
    var contextPath = AJS.$('meta[name="contextPath"]').attr('content');
    var currSpaceKey = AJS.$('meta[name="currSpaceKey"]').attr('content');
    AJS.$.ajax({
        url: contextPath+"/rest/purgerecyclebin/1.0/utility/config?spaceKey="+currSpaceKey,
        type: "GET",
        headers: {
            'Content-Type' : 'application/json',
            'Accept' : 'application/json'
        },
        beforeSend: function() {
            AJS.$(".tse-purgetrash-summary-loading").addClass("tse_loading_gif");
        },
        success: function(data) {
            AJS.$(".tse-purgetrash-summary-loading").removeClass("tse_loading_gif");
            
            if( data !== null )
            {
                AJS.$("#daysKeep").val(data.daysKeep);
                AJS.$(".purge-trash-days-keep").text(data.daysKeep);
                if(data.status) {
                    AJS.$("#status").attr('checked', 'true');
                }
            }
        },
        error: function(xhr, statusText, errorThrown) {
            AJS.$(".tse-purgetrash-summary-loading").removeClass("tse_loading_gif");
            try {
                var error_response = JSON.parse(xhr.responseText);
                if(error_response.message) AJS.$("#tse-purgetrash-summary-message")
                    .removeClass()
                    .addClass("aui-message aui-message-error")
                    .text(error_response.message);
            } catch (e) {
                console.log(e);
            }
            console.log(xhr.responseText);
            console.log(statusText);
            console.log(errorThrown);
        }
    });
}

function updateConfiguration() 
{
    var contextPath = AJS.$('meta[name="contextPath"]').attr('content');
    var currSpaceKey = AJS.$('meta[name="currSpaceKey"]').attr('content');
    var config = {};
    config.daysKeep = AJS.$("#daysKeep").val();
    config.status = AJS.$("#status").prop('checked');
    config.spaceKey = currSpaceKey;
    
    AJS.$.ajax({
        url: contextPath+"/rest/purgerecyclebin/1.0/utility/config",
        type: "POST",
        data: JSON.stringify(config),
        headers: {
            'Content-Type' : 'application/json',
            'Accept' : 'application/json'
        },
        beforeSend: function() {
            AJS.$("#TsePurgeTrashConfigForm :input[type='button']").prop('disabled', true);
            AJS.$(".tse-purgetrash-summary-loading").addClass("tse_loading_gif");
        },
        success: function(data) {
            AJS.$("#TsePurgeTrashConfigForm :input[type='button']").prop('disabled', false);
            AJS.$(".tse-purgetrash-summary-loading").removeClass("tse_loading_gif");
            AJS.$("#tse-purgetrash-summary-message")
                    .removeClass()
                    .addClass("aui-message")
                    .text(data.message);
            AJS.$("#TsePurgeTrashConfigForm").trigger("reset");
            load_purge_trash_config();
        },
        error: function(xhr, statusText, errorThrown) {
            AJS.$("#TsePurgeTrashConfigForm :input[type='button']").prop('disabled', false);
            AJS.$(".tse-purgetrash-summary-loading").removeClass("tse_loading_gif");
            try {
                var error_response = JSON.parse(xhr.responseText);
                if(error_response.message) AJS.$("#tse-purgetrash-summary-message")
                    .removeClass()
                    .addClass("aui-message aui-message-error")
                    .text(error_response.message);
            } catch (e) {
                console.log(e);
            }
            console.log(xhr.responseText);
            console.log(statusText);
            console.log(errorThrown);
        }
    });
}

function runPurgeTrash() 
{
    var contextPath = AJS.$('meta[name="contextPath"]').attr('content');
    var currSpaceKey = AJS.$('meta[name="currSpaceKey"]').attr('content');
    var dryRun = AJS.$("#dryRun").prop('checked') || false;
    
    AJS.$.ajax({
        url: contextPath+"/rest/purgerecyclebin/1.0/utility/run/config?spaceKey="+currSpaceKey
                +"&dryRun="+dryRun,
        type: "POST",
        headers: {
            'Content-Type' : 'application/json',
            'Accept' : 'application/json'
        },
        beforeSend: function() {
            AJS.$("#TsePurgeTrashRunForm :input[type='button']").prop('disabled', true);
            AJS.$(".tse-purgetrash-run-loading").addClass("tse_loading_gif");
        },
        success: function(data) {
            AJS.$("#TsePurgeTrashRunForm :input[type='button']").prop('disabled', false);
            AJS.$(".tse-purgetrash-run-loading").removeClass("tse_loading_gif");
            AJS.$("#tse-purgetrash-run-message")
                    .removeClass()
                    .addClass("aui-message")
                    .text(data.message);
            
            var logs = AJS.$("#tse-purgetrash-log-message");
            logs.empty();
            for(var log in data["logs"])
            {
                var logMessage = data["logs"][log];
                logs.append(AJS.$("<div class='tse-purgetrash-log' />").append(logMessage));
            }
        },
        error: function(xhr, statusText, errorThrown) {
            AJS.$("#TsePurgeTrashRunForm :input[type='button']").prop('disabled', false);
            AJS.$(".tse-purgetrash-run-loading").removeClass("tse_loading_gif");
            try {
                var error_response = JSON.parse(xhr.responseText);
                if(error_response.message) AJS.$("#tse-purgetrash-run-message")
                    .removeClass()
                    .addClass("aui-message aui-message-error")
                    .text(error_response.message);
            } catch (e) {
                console.log(e);
            }
            console.log(xhr.responseText);
            console.log(statusText);
            console.log(errorThrown);
        }
    });
}

function runPurgeTrashAll() 
{
    var contextPath = AJS.$('meta[name="contextPath"]').attr('content');
    var daysKeep = AJS.$("#daysKeep").val() || 0;
    var dryRun = AJS.$("#dryRun").prop('checked') || false;
    
    AJS.$.ajax({
        url: contextPath+"/rest/purgerecyclebin/1.0/utility/run/all/config"
                +"?daysKeep="+daysKeep+"&dryRun="+dryRun,
        type: "POST",
        headers: {
            'Content-Type' : 'application/json',
            'Accept' : 'application/json'
        },
        beforeSend: function() {
            AJS.$("#TsePurgeTrashRunForm :input[type='button']").prop('disabled', true);
            AJS.$(".tse-purgetrash-run-loading").addClass("tse_loading_gif");
        },
        success: function(data) {
            AJS.$("#TsePurgeTrashRunForm :input[type='button']").prop('disabled', false);
            AJS.$(".tse-purgetrash-run-loading").removeClass("tse_loading_gif");
            AJS.$("#tse-purgetrash-run-message")
                    .removeClass()
                    .addClass("aui-message")
                    .text(data.message);
            
            var logs = AJS.$("#tse-purgetrash-log-message");
            logs.empty();
            for(var log in data["logs"])
            {
                var logMessage = data["logs"][log];
                logs.append(AJS.$("<div class='tse-purgetrash-log' />").append(logMessage));
            }
        },
        error: function(xhr, statusText, errorThrown) {
            AJS.$("#TsePurgeTrashRunForm :input[type='button']").prop('disabled', false);
            AJS.$(".tse-purgetrash-run-loading").removeClass("tse_loading_gif");
            try {
                var error_response = JSON.parse(xhr.responseText);
                if(error_response.message) AJS.$("#tse-purgetrash-run-message")
                    .removeClass()
                    .addClass("aui-message aui-message-error")
                    .text(error_response.message);
            } catch (e) {
                console.log(e);
            }
            console.log(xhr.responseText);
            console.log(statusText);
            console.log(errorThrown);
        }
    });
}