/*
 * Decompiled with CFR 0.152.
 */
package com.tse.confluence.purgerecyclebin.plugin.api;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.user.User;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeRecycleBinUtil;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeTrashAO;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeTrashAOMgr;
import com.tse.confluence.purgerecyclebin.plugin.model.MessageBean;
import com.tse.confluence.purgerecyclebin.plugin.model.PurgeConfigBean;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/utility")
@Scanned
public class PurgeRecycleBinResource {
    private static final Logger LOGGER = Logger.getLogger(PurgeRecycleBinResource.class);
    private final PurgeRecycleBinUtil purgeRecycleBinUtill;
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;
    private final PurgeTrashAOMgr purgeTrashAOMgr;

    public PurgeRecycleBinResource(PurgeRecycleBinUtil purgeRecycleBinUtill, PermissionManager permissionManager, SpaceManager spaceManager, PurgeTrashAOMgr purgeTrashAOMgr) {
        this.purgeRecycleBinUtill = purgeRecycleBinUtill;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.purgeTrashAOMgr = purgeTrashAOMgr;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/config")
    public Response getPurgeConfigSummary(@QueryParam(value="spaceKey") String spaceKey) {
        MessageBean messageBean = new MessageBean();
        if (spaceKey == null || "".equals(spaceKey)) {
            messageBean.setMessage("Space key field value missing.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            messageBean.setMessage("Space key (" + spaceKey + ") not exists.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        ConfluenceUser loggedInAppUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)loggedInAppUser, Permission.ADMINISTER, (Object)space)) {
            messageBean.setMessage("Space Admin Permission denied.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        PurgeConfigBean configBean = new PurgeConfigBean();
        PurgeTrashAO purgeTrashConfigEntity = this.purgeTrashAOMgr.getPurgeTrashSpaceConfig(space);
        if (purgeTrashConfigEntity != null) {
            configBean.setDaysKeep(purgeTrashConfigEntity.getDaysKeep());
            configBean.setSpaceId(purgeTrashConfigEntity.getSpaceId());
            configBean.setSpaceKey(purgeTrashConfigEntity.getSpaceKey());
            configBean.setStatus(purgeTrashConfigEntity.getStatus());
        }
        return Response.ok((Object)configBean).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/config")
    public Response updatePurgeConfigSummary(PurgeConfigBean configBean) {
        MessageBean messageBean = new MessageBean();
        if (configBean.getSpaceKey() == null || "".equals(configBean.getSpaceKey())) {
            messageBean.setMessage("Space key field value missing.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Space space = this.spaceManager.getSpace(configBean.getSpaceKey());
        if (space == null) {
            messageBean.setMessage("Space key (" + configBean.getSpaceKey() + ") not exists.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        ConfluenceUser loggedInAppUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)loggedInAppUser, Permission.ADMINISTER, (Object)space)) {
            messageBean.setMessage("Space Admin Permission denied.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        PurgeTrashAO purgeTrashConfigEntity = this.purgeTrashAOMgr.updatePurgeTrashSpaceKey(space, configBean);
        if (purgeTrashConfigEntity != null) {
            messageBean.setMessage("Updated configuration.");
        }
        return Response.ok((Object)messageBean).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/config")
    public Response deletePurgeConfigSummary(@QueryParam(value="spaceKey") String spaceKey) {
        MessageBean messageBean = new MessageBean();
        if (spaceKey == null || "".equals(spaceKey)) {
            messageBean.setMessage("Space key field value missing.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            messageBean.setMessage("Space key (" + spaceKey + ") not exists.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        ConfluenceUser loggedInAppUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator((User)loggedInAppUser)) {
            messageBean.setMessage("Confluence Admin Permission denied.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        long index = this.purgeTrashAOMgr.removePurgeConfig(space);
        messageBean.setMessage("Removed Space Trash Config #" + index);
        messageBean.setStatus(index);
        return Response.ok((Object)messageBean).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/run/config")
    public Response getPurgeConfigRun(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="dryRun") boolean dryRun) {
        MessageBean messageBean = new MessageBean();
        if (spaceKey == null || "".equals(spaceKey)) {
            messageBean.setMessage("Space key field value missing.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        if (!this.purgeRecycleBinUtill.isActivePluginLicense()) {
            messageBean.setMessage("Purge Trash addon - " + this.purgeRecycleBinUtill.getPluginLicenseString());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            messageBean.setMessage("Space key (" + spaceKey + ") not exists.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        ConfluenceUser loggedInAppUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)loggedInAppUser, Permission.ADMINISTER, (Object)space)) {
            messageBean.setMessage("Space Admin Permission denied.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)messageBean).build();
        }
        PurgeTrashAO purgeTrashConfigEntity = this.purgeTrashAOMgr.getPurgeTrashSpaceConfig(space);
        if (purgeTrashConfigEntity == null) {
            messageBean.setMessage("Purge configuration not saved yet.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        long startTime = System.currentTimeMillis();
        ArrayList<String> logs = new ArrayList<String>();
        long index = this.purgeRecycleBinUtill.purgeTrashForSpace(space, purgeTrashConfigEntity.getDaysKeep(), logs, dryRun);
        long totalTime = System.currentTimeMillis() - startTime;
        String dryTag = !dryRun ? "[Info]" : "[Dry run]";
        messageBean.setMessage(dryTag + " Space Trash purge Update (" + index + "). Took " + (double)totalTime / 1000.0 + " Seconds.");
        messageBean.setLogs(logs);
        return Response.ok((Object)messageBean).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/run/all/config")
    public Response getPurgeConfigRunAll(@QueryParam(value="daysKeep") int daysKeep, @QueryParam(value="dryRun") boolean dryRun) {
        MessageBean messageBean = new MessageBean();
        if (daysKeep <= 0) {
            messageBean.setMessage("Keep days must be greater than 0.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        if (!this.purgeRecycleBinUtill.isActivePluginLicense()) {
            messageBean.setMessage("Purge Trash addon - " + this.purgeRecycleBinUtill.getPluginLicenseString());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        ConfluenceUser loggedInAppUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator((User)loggedInAppUser)) {
            messageBean.setMessage("Confluence Administrator Permission required.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messageBean).build();
        }
        long startTime = System.currentTimeMillis();
        ArrayList<String> logs = new ArrayList<String>();
        long index = 0L;
        List allSpaces = this.spaceManager.getAllSpaces();
        LOGGER.debug((Object)("Total Spaces processing for trash purge *" + allSpaces.size()));
        for (Space space : allSpaces) {
            index += this.purgeRecycleBinUtill.purgeTrashForSpace(space, daysKeep, logs, dryRun);
        }
        long totalTime = System.currentTimeMillis() - startTime;
        String dryTag = !dryRun ? "[Info]" : "[Dry run]";
        messageBean.setMessage(dryTag + " All Spaces Trash purge Update (" + index + "). Took " + (double)totalTime / 1000.0 + " Seconds.");
        messageBean.setLogs(logs);
        return Response.ok((Object)messageBean).build();
    }
}

