/*
 * Decompiled with CFR 0.152.
 */
package com.tse.confluence.purgerecyclebin.plugin.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeRecycleBinUtil;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeTrashAO;
import com.tse.confluence.purgerecyclebin.plugin.api.PurgeTrashAOMgr;
import com.tse.confluence.purgerecyclebin.plugin.model.MessageBean;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;

@ExportAsService(value={PurgeRecycleBinUtil.class})
@Named
public class PurgeRecycleBinUtilImpl
implements PurgeRecycleBinUtil {
    private static final Logger LOGGER = Logger.getLogger(PurgeRecycleBinUtilImpl.class);
    @ComponentImport
    private final BandanaManager bandanaManager;
    private final SpaceManager spaceManager;
    private final TrashManager trashManager;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    private final PurgeTrashAOMgr purgeTrashAOMgr;

    @Inject
    public PurgeRecycleBinUtilImpl(BandanaManager bandanaManager, SpaceManager spaceManager, TrashManager trashManager, PluginLicenseManager pluginLicenseManager, PurgeTrashAOMgr purgeTrashAOMgr) {
        this.bandanaManager = bandanaManager;
        this.spaceManager = spaceManager;
        this.trashManager = trashManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.purgeTrashAOMgr = purgeTrashAOMgr;
    }

    @Override
    public String getPluginLicenseString() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense licenseObject = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (licenseObject.getError().isDefined()) {
                return ((LicenseError)licenseObject.getError().get()).toString();
            }
            return "valid";
        }
        return "Unlicensed";
    }

    @Override
    public boolean isActivePluginLicense() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense licenseObject = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            return !licenseObject.getError().isDefined();
        }
        return false;
    }

    @Override
    public int getRetentionInterval() {
        int defaultInterval = 90;
        Object retentionIntervalObj = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "com.tse.confluence.purgerecyclebin.plugin.retention.days");
        if (retentionIntervalObj != null) {
            int retentionInterval = (Integer)retentionIntervalObj;
            return retentionInterval >= 1 ? retentionInterval : defaultInterval;
        }
        return defaultInterval;
    }

    @Override
    public void setRetentionInterval(int retentionInterval) {
        if (retentionInterval >= 1) {
            this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "com.tse.confluence.purgerecyclebin.plugin.retention.days", (Object)retentionInterval);
        }
    }

    @Override
    public Date getNextRetentionDate(Date pageLastModified, int retentionDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(pageLastModified);
        cal.add(5, retentionDays);
        return cal.getTime();
    }

    @Override
    public Map<String, Long> getTrashDetails(Space space) {
        LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>();
        try {
            int trashCount = this.trashManager.getNumberOfItemsInTrash(space);
            map.put("Total Contents", Long.valueOf(trashCount));
            long attachments = 0L;
            long pages = 0L;
            long page_versions = 0L;
            List trashPageContents = this.trashManager.getTrashContents(space, 0, trashCount);
            for (ContentEntityObject content : trashPageContents) {
                String contentType = content.getType();
                if ("ATTACHMENT".equalsIgnoreCase(contentType)) {
                    ++attachments;
                    continue;
                }
                if (!"PAGE".equalsIgnoreCase(contentType)) continue;
                page_versions += (long)content.getVersion();
                ++pages;
            }
            map.put("Total Pages", pages);
            map.put("Total Page Versions", page_versions);
            map.put("Total Attachments", attachments);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
        return map;
    }

    @Override
    public long purgeTrashForSpace(Space space, int retentionDays, List<String> logs, boolean dryRun) {
        long index = 0L;
        try {
            int trashCount = this.trashManager.getNumberOfItemsInTrash(space);
            LOGGER.debug((Object)("Total Trash content for space *" + space.getKey() + "* processing for purge: " + trashCount));
            List trashPageContents = this.trashManager.getTrashContents(space, 0, trashCount);
            Date todayRunDate = new Date();
            for (ContentEntityObject content : trashPageContents) {
                ContentId contentId = content.getContentId();
                Date contentLastModified = null;
                if (content.getLastModificationDate() != null) {
                    contentLastModified = content.getLastModificationDate();
                } else if (content.getCreationDate() != null) {
                    contentLastModified = content.getCreationDate();
                }
                if (contentLastModified != null) {
                    Date contentRetentionTime = this.getNextRetentionDate(contentLastModified, retentionDays);
                    if (contentRetentionTime.before(todayRunDate)) {
                        LOGGER.debug((Object)MessageFormat.format("Purging content id*{0} type*{3} title*{4} lastmodified*{1} retention*{2}", contentId.asLong(), contentLastModified, contentRetentionTime, content.getType(), content.getTitle()));
                        if (logs != null) {
                            logs.add(MessageFormat.format("[Info] Purging | Space*{0} | Content ID*{1} | Type*{2} | Title*{3} | lastmodified*{4}", space.getKey(), contentId.asLong(), content.getType(), content.getTitle(), contentLastModified));
                        }
                        if (!dryRun) {
                            this.trashManager.purge(space.getKey(), contentId.asLong());
                        }
                        ++index;
                        continue;
                    }
                    LOGGER.debug((Object)MessageFormat.format("Skipping content id*{0} type*{3} title*{4} lastmodified*{1} retention*{2}", contentId.asLong(), contentLastModified, contentRetentionTime, content.getType(), content.getTitle()));
                    continue;
                }
                LOGGER.debug((Object)("Skipping Unable to find modified/create dates for Content ID*" + content.getContentId().asLong()));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
        return index;
    }

    @Override
    public MessageBean runPurgeTrash() {
        MessageBean message = new MessageBean();
        long startTime = System.currentTimeMillis();
        LOGGER.debug((Object)"Purge Trash - START.");
        if (!this.isActivePluginLicense()) {
            LOGGER.warn((Object)("Purge Trash addon - " + this.getPluginLicenseString()));
            message.setMessage("Purge Trash addon - " + this.getPluginLicenseString());
            return message;
        }
        PurgeTrashAO[] activeSpaces = this.purgeTrashAOMgr.getPurgeTrashSpacesActive();
        LOGGER.debug((Object)("Total active spaces processing for trash purge: " + activeSpaces.length));
        long index = 0L;
        for (PurgeTrashAO entity : activeSpaces) {
            Space space = this.spaceManager.getSpace(entity.getSpaceId());
            if (space == null) continue;
            index += this.purgeTrashForSpace(space, entity.getDaysKeep(), null, false);
        }
        long totalTime = System.currentTimeMillis() - startTime;
        LOGGER.debug((Object)("Purge Trash Update (" + index + ") - END. Took " + (double)totalTime / 1000.0 + " Seconds."));
        message.setMessage("Purge Trash Update (" + index + ") - END. Took " + (double)totalTime / 1000.0 + " Seconds.");
        return message;
    }
}

