/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.atlassian.apps.util.iframe.confluence.iframe;

import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.tngtech.atlassian.apps.util.iframe.VelocityService;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceVelocityService
implements VelocityService {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceVelocityService.class);
    private final VelocityHelperService velocityHelperService;

    public ConfluenceVelocityService(VelocityHelperService velocityHelperService) {
        this.velocityHelperService = velocityHelperService;
    }

    public Map<String, Object> getDefaultContext() {
        return MacroUtils.defaultVelocityContext();
    }

    public String getProduct() {
        return "Confluence";
    }

    public int getMajorVersion() {
        return Integer.parseInt(GeneralUtil.getVersionNumber().split("\\.")[0]);
    }

    public void render(String templateLocation, Map<String, Object> context, Writer writer) {
        try {
            writer.write(this.velocityHelperService.getRenderedTemplate(templateLocation, context));
        }
        catch (IOException e) {
            log.error("Error occurred rendering template: {}", (Object)templateLocation, (Object)e);
        }
    }
}

