/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.confluence.plugins.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.sal.api.message.I18nResolver;
import com.tngtech.atlassian.apps.util.iframe.confluence.iframe.macro.IFrameMacro;
import com.tngtech.confluence.plugins.macro.service.LicenseWarningService;
import java.util.Collections;
import java.util.Map;

public class ImageDarkModeAndRotationMacro
extends IFrameMacro {
    private final LicenseWarningService licenseWarningService;
    private final I18nResolver i18n;

    public ImageDarkModeAndRotationMacro(LicenseWarningService licenseWarningService, I18nResolver i18n, VelocityHelperService velocityHelperService) {
        super("image-dark-mode-and-rotation", velocityHelperService);
        this.licenseWarningService = licenseWarningService;
        this.i18n = i18n;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (this.licenseWarningService.isInvalidLicense()) {
            return this.licenseWarningService.createRenderedLicenseWarningForPreviewAndDisplay(conversionContext, "com.tngtech.confluence.plugins.rotate-images.image-dark-mode-and-rotation.label") + body;
        }
        if (conversionContext.getEntity() == null) {
            throw new MacroExecutionException(this.i18n.getText("com.tngtech.confluence.plugins.rotate-images.macro.error.pageId"));
        }
        parameters.put("pageId", conversionContext.getEntity().getIdAsString());
        return this.renderInIframe("com.tngtech.confluence.plugins.rotate-images", parameters, Collections.singletonList("com.tngtech.confluence.plugins.rotate-images:entrypoint-imageDarkModeMacroDisplay"));
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

