AJS.toInit(function ($) {
    function addRotateButtons() {
        const dataColorMode = AJS.$('html').attr('data-color-mode');
        if (dataColorMode !== 'dark' && dataColorMode !== 'light') {
            console.error('data-color-mode not set to dark or light');
        }
        AJS.Confluence.PropertyPanel.Image.pluginButtons.push(
            null, // spacer
            {
                create: function (img) {
                    return {
                        className:
                            dataColorMode === 'dark'
                                ? 'image-rotate-counter-clockwise-dark'
                                : 'image-rotate-counter-clockwise',
                        text: null,
                        tooltip: AJS.I18n.getText(
                            'com.tngtech.confluence.plugins.rotate-images.property-panel.button.tooltip.counter-clockwise'
                        ),
                        disabled: false,
                        selected: false,
                        click: function (a, img) {
                            rotate(AJS.$(img), true);
                        },
                    };
                },
            },
            {
                create: function (img) {
                    return {
                        className: dataColorMode === 'dark' ? 'image-rotate-clockwise-dark' : 'image-rotate-clockwise',
                        text: null,
                        tooltip: AJS.I18n.getText(
                            'com.tngtech.confluence.plugins.rotate-images.property-panel.button.tooltip.clockwise'
                        ),
                        disabled: false,
                        selected: false,
                        click: function (a, img) {
                            rotate(AJS.$(img), false);
                        },
                    };
                },
            }
        );
    }

    function addRotateButtonsAfterRessourceLoaded() {
        if (AJS.Confluence.PropertyPanel.Image !== undefined) {
            addRotateButtons();
        } else {
            setTimeout(addRotateButtonsAfterRessourceLoaded, 1000);
        }
    }

    addRotateButtonsAfterRessourceLoaded();

    var waitDialogHeader = AJS.I18n.getText('com.tngtech.confluence.plugins.rotate-images.dialog.wait');

    rotate = function ($img, counterClockwise) {
        var url =
            [
                AJS.Meta.get('context-path'),
                'rest/rotate-images/1.0/attachment',
                $img.attr('data-linked-resource-id'),
            ].join('/') +
            '?' +
            AJS.$.param({ counterClockwise: counterClockwise });

        waitDialog.show(waitDialogHeader);

        AJS.safe
            .post(url, {}, null, 'text')
            .done(function (newImgUrl, textStatus, jqXHR) {
                var imageProps = AJS.Confluence.PropertyPanel.current.imageProps;
                adjustImageProps(newImgUrl, imageProps);
                waitDialog.hide(); // must be closed before updateImageElement
                updateImageElement($img, imageProps);
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                waitDialog.hide();

                if (jqXHR.responseText.includes('LICENSE_REQUIRED')) {
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText(
                            'com.tngtech.confluence.plugins.rotate-images.alert.license-invalid.alert.title'
                        ),
                        body: AJS.I18n.getText(
                            'com.tngtech.confluence.plugins.rotate-images.alert.license-invalid.alert.body'
                        ),
                        close: 'auto',
                    });
                    AJS.logError('Request for rotating image could not be sent due to: App license is invalid.');
                } else if (jqXHR.responseJSON.reason === 'READ_ONLY') {
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText(
                            'com.tngtech.confluence.plugins.rotate-images.alert.read-only-mode.alert.title'
                        ),
                        body: AJS.I18n.getText(
                            'com.tngtech.confluence.plugins.rotate-images.alert.read-only-mode.alert.body'
                        ),
                        close: 'auto',
                    });
                    AJS.logError('Request for rotating image could not be sent due to: Read-only mode active.');
                } else {
                    AJS.logError(
                        'Request for rotating image could not be sent due to: Please reload page and try again.'
                    );
                }
            });

        /**
         * copied from "confluence-project/confluence-plugins/confluence-editor-plugins/confluence-editor/src/main/resources/tinymce3/plugins/propertypanel/js/tinyMce-property-panel-images.js"
         * and adjusted a bit
         */
        function adjustImageProps(newImageUrl, imageProps) {
            imageProps.destination = newImageUrl;

            delete imageProps['height']; // delete height because it might have change due to rotation
            imageProps.thumbnail =
                !tinymce.confluence.ImageUtils.isRemoteImg(newImageUrl) &&
                imageProps.width <= AJS.Meta.get('max-thumb-width');
        }

        /**
         * Update the image element to match the ImageProperties passed in, relocate the property panel to match the
         * resized image, and cleanup any image-selection handles.
         *
         * copied from "confluence-project/confluence-plugins/confluence-editor-plugins/confluence-editor/src/main/resources/tinymce3/plugins/propertypanel/js/tinyMce-property-panel-images.js"
         * and adjusted a bit
         */
        function updateImageElement($img, imageProps) {
            var ppanel = AJS.Confluence.PropertyPanel.current,
                oldSrc = $img.attr('src'),
                oldHeight = $img.height();

            // Turn off scroll binding, in case an img resize causes a scroll event, and rebind after the resize.
            ppanel.updating = true;
            var rebindAndSnap = function () {
                ppanel.updating = false;
                ppanel.snapToElement({
                    animate: true,
                    animateDuration: 100,
                });
            };

            tinymce.confluence.ImageUtils.updateImageElement($img, imageProps);
            if (tinymce.isGecko) {
                // Repaint to clear the image handles from their old positions.
                AJS.Rte.getEditor().execCommand('mceRepaint', false);
            }

            if (imageProps.src !== oldSrc) {
                // Image source changed - may have to wait for height to change to snapToElement
                var snapInterval = setInterval(function () {
                    var newHeight = $img.height();
                    if (newHeight !== oldHeight) {
                        AJS.log(
                            'updateImageElement : height changed after image src change - ' +
                                oldHeight +
                                ' to ' +
                                newHeight
                        );
                        clearTimeout(snapInterval);
                        snapInterval = null;
                        rebindAndSnap();
                    }
                }, 10);
                setTimeout(function () {
                    if (snapInterval) {
                        clearTimeout(snapInterval);
                        snapInterval = null;
                        rebindAndSnap();
                    }
                }, 1000);
            } else {
                rebindAndSnap();
            }
        }
    };
});
