/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.confluence.plugins.rest.endpoints;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.sun.jersey.spi.container.ResourceFilters;
import com.tngtech.atlassian.compat.common.response.ResponseHelper;
import com.tngtech.atlassian.license.util.v1.V1LicenseResourceFilter;
import com.tngtech.atlassian.license.util.v2.V2LicenseResourceFilterBinding;
import com.tngtech.atlassian.license.util.v3.V3LicenseResourceFilterBinding;
import com.tngtech.confluence.plugins.ImageWriterService;
import com.tngtech.confluence.plugins.permissions.PermissionService;
import jakarta.inject.Inject;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import lombok.Generated;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@jakarta.ws.rs.Path(value="/")
@ResourceFilters(value={V1LicenseResourceFilter.class})
@V2LicenseResourceFilterBinding
@V3LicenseResourceFilterBinding
public class RotateImagesRestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RotateImagesRestService.class);
    private final AttachmentManager attachmentManager;
    private final BootstrapManager bootstrapManager;
    private final ImageWriterService imageWriterService;
    private final PermissionService permissionService;
    private final ResponseHelper responseHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @jakarta.ws.rs.POST
    @Path(value="/attachment/{attachmentId}")
    @jakarta.ws.rs.Path(value="/attachment/{attachmentId}")
    public Object rotate(@javax.ws.rs.PathParam(value="attachmentId") @PathParam(value="attachmentId") int attachmentId, @javax.ws.rs.QueryParam(value="counterClockwise") @QueryParam(value="counterClockwise") boolean counterClockwise) {
        Attachment attachment = this.attachmentManager.getAttachment((long)attachmentId);
        if (attachment == null) {
            log.warn("Cannot find attachment for id " + attachmentId);
            return this.responseHelper.status(ResponseHelper.Status.NOT_FOUND).build();
        }
        if (log.isDebugEnabled()) {
            log.debug("Found " + attachment + " for id " + attachmentId + " which should be rotated counterClockwise=" + counterClockwise);
        }
        if (!this.permissionService.isUserAuthorizedToEditAttachment(attachment)) {
            log.warn("Request from unauthorized user with name " + AuthenticatedUserThreadLocal.getUsername());
            return this.responseHelper.status(ResponseHelper.Status.UNAUTHORIZED).build();
        }
        Scalr.Rotation rotation = counterClockwise ? Scalr.Rotation.CW_270 : Scalr.Rotation.CW_90;
        ByteArrayOutputStream rotatedImageOutputStream = null;
        try {
            rotatedImageOutputStream = this.getRotatedImageAsOutputStreamOf(attachment, rotation);
            this.saveNewVersionOfAttachment(attachment, rotatedImageOutputStream);
        }
        catch (Exception e) {
            log.error("failed to rotate attachment " + attachment + " with id " + attachmentId, (Throwable)e);
            Object object = this.responseHelper.status(ResponseHelper.Status.INTERNAL_SERVER_ERROR).build();
            return object;
        }
        finally {
            this.closeQuietly(rotatedImageOutputStream);
        }
        return this.responseHelper.ok().entity((Object)(this.bootstrapManager.getWebAppContextPath() + attachment.getDownloadPath())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream getRotatedImageAsOutputStreamOf(Attachment attachment, Scalr.Rotation rotation) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        InputStream sourceImageInputStream = null;
        try {
            sourceImageInputStream = attachment.getContentsAsStream();
            BufferedImage image = ImageIO.read(sourceImageInputStream);
            image = Scalr.rotate((BufferedImage)image, (Scalr.Rotation)rotation, (BufferedImageOp[])new BufferedImageOp[0]);
            String imageFormat = attachment.getFileExtension();
            this.imageWriterService.write(image, imageFormat, result);
        }
        finally {
            this.closeQuietly(sourceImageInputStream);
        }
        return result;
    }

    private void saveNewVersionOfAttachment(Attachment attachment, ByteArrayOutputStream newImageOutputStream) throws IOException {
        Attachment oldAttachment = attachment.copy();
        attachment.setFileSize((long)newImageOutputStream.size());
        this.attachmentManager.saveAttachment(attachment, oldAttachment, (InputStream)new ByteArrayInputStream(newImageOutputStream.toByteArray()));
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @javax.inject.Inject
    @Inject
    @Generated
    public RotateImagesRestService(AttachmentManager attachmentManager, BootstrapManager bootstrapManager, ImageWriterService imageWriterService, PermissionService permissionService, ResponseHelper responseHelper) {
        this.attachmentManager = attachmentManager;
        this.bootstrapManager = bootstrapManager;
        this.imageWriterService = imageWriterService;
        this.permissionService = permissionService;
        this.responseHelper = responseHelper;
    }
}

