/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.confluence.plugins.macro.service;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.RichTextMacroBody;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.sal.api.message.I18nResolver;
import com.tngtech.atlassian.license.util.LicenseService;
import java.io.Serializable;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseWarningService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseWarningService.class);
    private final LicenseService licenseService;
    private final I18nResolver i18nResolver;
    private final XhtmlContent xhtmlContent;

    public LicenseWarningService(LicenseService licenseService, I18nResolver i18nResolver, XhtmlContent xhtmlContent) {
        this.licenseService = licenseService;
        this.i18nResolver = i18nResolver;
        this.xhtmlContent = xhtmlContent;
    }

    public boolean isInvalidLicense() {
        return !this.licenseService.isValid() && !this.licenseService.isDevMode();
    }

    public String createRenderedLicenseWarningForPreviewAndDisplay(ConversionContext conversionContext, String i18nMacroLabelKey) throws MacroExecutionException {
        try {
            if (this.isPreviewOrDisplayOutputType(conversionContext.getOutputType())) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("title", this.i18nResolver.getText(i18nMacroLabelKey));
                MacroDefinition warningMacro = MacroDefinition.builder().withName("warning").withMacroBody((MacroBody)RichTextMacroBody.withStorage((Streamable)Streamables.from((String)this.i18nResolver.getText("com.tngtech.confluence.plugins.rotate-images.image-dark-mode-and-rotation.warning.license.invalid", (Serializable[])new String[]{this.i18nResolver.getText(i18nMacroLabelKey)})))).withParameters(parameters).build();
                return this.xhtmlContent.convertMacroDefinitionToView(warningMacro, conversionContext);
            }
            return "";
        }
        catch (XhtmlException e) {
            throw new MacroExecutionException((Throwable)e);
        }
    }

    private boolean isPreviewOrDisplayOutputType(String outputType) {
        return outputType.equals(ConversionContextOutputType.PREVIEW.value()) || outputType.equals(ConversionContextOutputType.DISPLAY.value());
    }
}

