/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.atlassian.license.util;

import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;

public class LicenseService {
    private static final String ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    private final PluginLicenseManager pluginLicenseManager;
    private final LicenseHandler licenseHandler;

    public LicenseService(PluginLicenseManager pluginLicenseManager, LicenseHandler licenseHandler) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseHandler = licenseHandler;
    }

    public boolean isValidSubscription() {
        return this.getLicenseStatus() == LicenseStatus.VALID_SUBSCRIPTION;
    }

    public boolean isValid() {
        return this.getLicenseStatus() == LicenseStatus.VALID || this.getLicenseStatus() == LicenseStatus.VALID_SUBSCRIPTION;
    }

    private LicenseStatus getLicenseStatus() {
        Option licenseOption = this.pluginLicenseManager.getLicense();
        if (licenseOption.isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.isValid()) {
                return license.isSubscription() ? LicenseStatus.VALID_SUBSCRIPTION : LicenseStatus.VALID;
            }
            return LicenseStatus.ERROR;
        }
        return LicenseStatus.UNLICENSED;
    }

    public boolean isDataCenter() {
        return this.licenseHandler.getAllProductLicenses().stream().allMatch(BaseLicenseDetails::isDataCenter);
    }

    public boolean isDevMode() {
        return Boolean.getBoolean(ATLASSIAN_DEV_MODE);
    }

    static enum LicenseStatus {
        ERROR,
        VALID_SUBSCRIPTION,
        VALID,
        UNLICENSED;

    }
}

