/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.confluence.plugins;

import com.tngtech.confluence.plugins.writer.image.CustomImageWriter;
import com.tngtech.confluence.plugins.writer.image.JpegImageWriter;
import com.tngtech.confluence.plugins.writer.image.PngImageWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageWriterService {
    private static final List<CustomImageWriter> customImageWriters = Arrays.asList(new JpegImageWriter(), new PngImageWriter());

    public void write(BufferedImage image, String imageFormat, OutputStream output) throws IOException {
        for (CustomImageWriter writer : customImageWriters) {
            if (!writer.accepts(imageFormat) || !writer.write(image, imageFormat, output)) continue;
            return;
        }
        ImageIO.write((RenderedImage)image, imageFormat, output);
    }
}

