/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.confluence.plugins.writer.image;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngWriter;
import com.tngtech.confluence.plugins.writer.image.CustomImageWriter;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

public class PngImageWriter
implements CustomImageWriter {
    @Override
    public boolean accepts(String imageFormat) {
        return "png".equalsIgnoreCase(imageFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(BufferedImage image, String imageFormat, OutputStream output) throws IOException {
        ImageWriter writer;
        if (this.writeImageUsingPngJ(image, output)) {
            return true;
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(imageFormat);
        if (writers.hasNext() && (writer = writers.next()) != null) {
            ImageWriteParam params = writer.getDefaultWriteParam();
            params.setProgressiveMode(0);
            writer.setOutput(ImageIO.createImageOutputStream(output));
            try {
                writer.write(null, new IIOImage(image, null, null), params);
                boolean bl = true;
                return bl;
            }
            finally {
                writer.dispose();
                output.flush();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeImageUsingPngJ(BufferedImage image, OutputStream output) {
        if (Arrays.asList(2, 6).contains(image.getType())) {
            ImageInfo imi = new ImageInfo(image.getWidth(), image.getHeight(), 8, true);
            PngWriter pngw = null;
            try {
                DataBufferByte db;
                pngw = new PngWriter(output, imi);
                pngw.setCompLevel(8);
                pngw.setFilterType(FilterType.FILTER_DEFAULT);
                if (2 == image.getType()) {
                    DataBufferInt db2 = (DataBufferInt)image.getRaster().getDataBuffer();
                    if (db2.getNumBanks() == 1) {
                        int row;
                        SinglePixelPackedSampleModel samplemodel = (SinglePixelPackedSampleModel)image.getSampleModel();
                        ImageLineInt line = new ImageLineInt(imi);
                        int[] dbbuf = db2.getData();
                        for (row = 0; row < imi.rows; ++row) {
                            int elem = samplemodel.getOffset(0, row);
                            int j = 0;
                            for (int col = 0; col < imi.cols; ++col) {
                                int sample = dbbuf[elem++];
                                line.getScanline()[j++] = (sample & 0xFF0000) >> 16;
                                line.getScanline()[j++] = (sample & 0xFF00) >> 8;
                                line.getScanline()[j++] = sample & 0xFF;
                                line.getScanline()[j++] = (sample & 0xFF000000) >> 24 & 0xFF;
                            }
                            pngw.writeRow((IImageLine)line, row);
                        }
                        row = 1;
                        return row != 0;
                    }
                } else if (image.getType() == 6 && (db = (DataBufferByte)image.getRaster().getDataBuffer()).getNumBanks() == 1) {
                    ComponentSampleModel samplemodel = (ComponentSampleModel)image.getSampleModel();
                    ImageLineInt line = new ImageLineInt(imi);
                    byte[] dbbuf = db.getData();
                    for (int row = 0; row < imi.rows; ++row) {
                        int elem = samplemodel.getOffset(0, row);
                        int col = 0;
                        int j = 0;
                        while (col < imi.cols) {
                            line.getScanline()[j++] = dbbuf[elem--];
                            line.getScanline()[j++] = dbbuf[elem--];
                            line.getScanline()[j++] = dbbuf[elem--];
                            line.getScanline()[j++] = dbbuf[elem];
                            ++col;
                            elem += 7;
                        }
                        pngw.writeRow((IImageLine)line, row);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (pngw != null) {
                    pngw.end();
                }
            }
        }
        return false;
    }
}

