/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.confluence.plugins;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AuthenticationContext;
import com.atlassian.user.User;
import com.sun.jersey.spi.container.ResourceFilters;
import com.tngtech.confluence.plugins.ImageWriterService;
import com.tngtech.confluence.plugins.LicenseFilter;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import javax.imageio.ImageIO;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@ResourceFilters(value={LicenseFilter.class})
public class RotateImagesRestService {
    private static final Logger log = LoggerFactory.getLogger(RotateImagesRestService.class);
    private final AttachmentManager attachmentManager;
    private final PermissionManager permissionManager;
    private final BootstrapManager bootstrapManager;
    private final ImageWriterService imageWriterService;
    private final UserAccessor userAccessor;

    public RotateImagesRestService(AttachmentManager attachmentManager, PermissionManager permissionManager, BootstrapManager bootstrapManager, ImageWriterService imageWriterService, UserAccessor userAccessor) {
        this.attachmentManager = attachmentManager;
        this.permissionManager = permissionManager;
        this.bootstrapManager = bootstrapManager;
        this.imageWriterService = imageWriterService;
        this.userAccessor = userAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/attachment/{attachmentId}")
    public Response rotate(@PathParam(value="attachmentId") int attachmentId, @QueryParam(value="counterClockwise") boolean counterClockwise, @Context AuthenticationContext authenticationContext) {
        String userName;
        User user;
        Attachment attachment = this.attachmentManager.getAttachment((long)attachmentId);
        if (attachment == null) {
            log.warn("Cannot find attachment for id " + attachmentId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (log.isDebugEnabled()) {
            log.debug("Found " + attachment + " for id " + attachmentId + " which should be rotated counterClockwise=" + counterClockwise);
        }
        if (!this.isUserAuthorizedToEditAttachment(user = this.getUser(userName = this.getUserNameFrom(authenticationContext)), attachment)) {
            log.warn("Request from unauthorized user with name " + userName);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Scalr.Rotation rotation = counterClockwise ? Scalr.Rotation.CW_270 : Scalr.Rotation.CW_90;
        ByteArrayOutputStream rotatedImageOutputStream = null;
        try {
            rotatedImageOutputStream = this.getRotatedImageAsOutputStreamOf(attachment, rotation);
            this.saveNewVersionOfAttachment(attachment, rotatedImageOutputStream);
        }
        catch (Exception e) {
            log.error("failed to rotate attachment " + attachment + " with id " + attachmentId, (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            this.closeQuietly(rotatedImageOutputStream);
        }
        return Response.ok((Object)(this.bootstrapManager.getWebAppContextPath() + attachment.getDownloadPath())).build();
    }

    private String getUserNameFrom(AuthenticationContext context) {
        if (context == null) {
            return null;
        }
        Principal principal = context.getPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    private User getUser(String userName) {
        return this.userAccessor.getUser(userName);
    }

    private boolean isUserAuthorizedToEditAttachment(User user, Attachment attachment) {
        return user != null && this.permissionManager.hasPermission(user, Permission.EDIT, (Object)attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream getRotatedImageAsOutputStreamOf(Attachment attachment, Scalr.Rotation rotation) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        InputStream sourceImageInputStream = null;
        try {
            sourceImageInputStream = attachment.getContentsAsStream();
            BufferedImage image = ImageIO.read(sourceImageInputStream);
            image = Scalr.rotate((BufferedImage)image, (Scalr.Rotation)rotation, (BufferedImageOp[])new BufferedImageOp[0]);
            String imageFormat = attachment.getFileExtension();
            this.imageWriterService.write(image, imageFormat, result);
        }
        finally {
            this.closeQuietly(sourceImageInputStream);
        }
        return result;
    }

    private void saveNewVersionOfAttachment(Attachment attachment, ByteArrayOutputStream newImageOutputStream) throws IOException {
        Attachment oldAttachment = attachment.copy();
        attachment.setFileSize((long)newImageOutputStream.size());
        this.attachmentManager.saveAttachment(attachment, oldAttachment, (InputStream)new ByteArrayInputStream(newImageOutputStream.toByteArray()));
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

