(function($) {

    if (window.ZEPTO_DIALOG_JS_ALREADY_LOADED === undefined) {
        if (!AJS.Dialog) {
            AJS.Dialog = function(options) {
                this.options = options;
                this.dialog = $(ZeptoDialog.dialog({width: options.width, height: options.height, id: options.id}));
                $('body').append(this.dialog);
            };

            AJS.Dialog.prototype.addHeader = function(text) {
                this.dialog.find('.dialog-components').prepend(ZeptoDialog.header({text: text}));
            };

            AJS.Dialog.prototype.addPanel = function(type, body, cssClass) {
                this.dialog.find('.dialog-page-body').prepend(ZeptoDialog.page({class: cssClass, height: this.options.height, body: body}));
            };

            AJS.Dialog.prototype.addButton = function(text, callback, cssClass) {
                var btn = $(ZeptoDialog.button({class: cssClass, text: text}));
                this.dialog.find('.dialog-button-panel').prepend(btn);
                btn.bind('click', callback);
            };

            AJS.Dialog.prototype.addLink = function(text, callback, href) {
                var dialog = this;
                var link = $(ZeptoDialog.link({text: text}));
                this.dialog.find('.dialog-button-panel').append(link);
                link.bind('click', function() {
                    callback(dialog);
                    return false;
                });
            };

            AJS.Dialog.prototype.show = function() {
                this.dialog.show();
                $('body').css('overflow', 'hidden');
            };

            AJS.Dialog.prototype.remove = function() {
                this.dialog.remove();
                $('body').css('overflow', '');
            };
        }

        window.ZEPTO_DIALOG_JS_ALREADY_LOADED = true;
    }
})(Zepto);




