(function($) {

    window.UserMacroAutoComplete = {

        collectParticipantParams: function(params) {
            var entities = {user: [], email: [], group: []};

            $('#macro-param-div-users .recipient').each(function() {
                var recipient = $(this);
                entities[recipient.data('type')].push(recipient.data('key'));
            });

            params['users'] = entities.user.join(',');
            params['emails'] = entities.email.join(',');
            params['groups'] = entities.group.join(',');

            return params;
        },

        showUserCompletion: function(params) {
            var users = params['users'] ? params['users'].split(',') : [];
            var emails = params['emails'] ? params['emails'].split(',') : [];
            var groups = params['groups'] ? params['groups'].split(',') : [];

            var usersInput = $('#macro-param-users');
            var autocomplete = $(QuizzesMacro.input({ph: AJS.I18n.getText('quiz.share.dialog.participants.placeholder')}));
            usersInput.hide().after(autocomplete);

            var usersContainer = $('#macro-param-div-users');
            var container = $(QuizUsers.usersContainer());
            container.css('margin-top', '5px');
            usersContainer.append(container);

            CQAutocomplete.init(autocomplete, addParticipant, CQAutocomplete.findParticipants);

            users.forEach(function(name) {
                $.ajax({
                    type: 'GET',
                    async: false,
                    url: Confluence.getContextPath() + "/rest/api/user",
                    data: {
                        username: name
                    },
                    dataType: 'json',
                    success: function(data) {
                        addExistingParticipant('user', name, data.profilePicture.path, data.displayName);
                    }
                });
            });
            emails.forEach(function(name) {
                addExistingParticipant('email', name, getPathToImage("envelope"), name);
            });
            groups.forEach(function(name) {
                addExistingParticipant('group', name, getPathToImage("group"), name);
            });

            return params;
        }
    };

    function getPathToImage(imageName) {
        return Confluence.getContextPath() + "/download/resources/com.stiltsoft.confluence.quiz/images/" + imageName + ".png";
    }

    function addParticipant($suggestion) {
        var usersContainer = $('#macro-param-div-users');
        CQAutocomplete.autocompleteParticipants($suggestion, usersContainer, $('<button></button>'))
    }

    function addExistingParticipant(type, key, img, title) {
        var $suggestion = $('<div/>');
        $suggestion.data('type', type).data('key', key).data('img', img).text(title);
        addParticipant($suggestion);
    }

})(AJS.$);