(function($) {
    window.TableSorterFixer = {
        fix: function (tables) {
            tables.each(function () {
                var table = $(this);
                var body = table.children('tbody');
                var heads = table.children('thead');
                if (heads.length > 1) {
                    for (var i = 1; i < heads.length; i++) {
                        var head = heads.eq(i);
                        body.prepend(head.children());
                        head.remove();
                    }

                    table.trigger('update', false);
                }
                body.before(heads);
                table.find('thead:not(:has(tr))').remove();

                body.find('td.tablesorter-header').unbind('mousedown mouseup').removeClass('tablesorter-header sortableHeader').attr('tabindex', '');
            });
        }
    };
})(AJS.$);




