(function($) {
    AJS.toInit(function() {
        var pageId = AJS.params.pageId;
        var collapse = function(header) {
            var name = header.data('name');
            var index = header.data('qi');
            var content = $('.' + name).eq(index);

            if (header.is('.collapsed')) {
                header.removeClass('collapsed');
                content.show();
                QuizCookies.setCookie(pageId + name + index, false);
            } else {
                header.addClass('collapsed');
                content.hide();
                QuizCookies.setCookie(pageId + name + index, true);
            }
        };

        $('.quiz-hider').each(function() {
            var header = $(this);
            var name = header.data('name');
            var content = header.next('.' + name);
            var index = $('.' + name).index(content);
            header.data('qi', index);

            var h2s = $('h2:contains("' + header.text().trim() + '")').filter(function() {
                return $(this).text().trim() == header.text().trim();
            });
            var hiderIndex = h2s.index(header);
            if (hiderIndex > 0 && h2s.eq(hiderIndex - 1).is(':not(.quiz-hider)')) {
                var newHeader = h2s.eq(hiderIndex - 1).addClass('quiz-hider').data('name', name).data('qi', index).html(header.html());
                header.remove();
                header = newHeader;
            }

            if (QuizCookies.getCookie(pageId + name + index) == 'true') {
                header.addClass('collapsed');
                content.hide();
            }
        });

        $('.quiz-hider .aui-icon, .quiz-hider .text').click(function() {
            collapse($(this).parent());
        });

    });
})(AJS.$);



