(function($) {

    window.QuizNumberUtils = {

        bindNumberInputs: function(container) {
            var checkMinMax = function(input) {
                var val = parseInt(input.val());
                var max = input.attr('max');
                if (isNaN(val) || val < parseInt(input.attr('min'))) {
                    input.val('');
                } else if(max && val > max) {
                    input.val(max);
                } else {
                    input.val(val);
                }
            };

            container.find('input[type="number"]').keydown(function(e) {
                if (e.which == 109 || e.which == 189 || e.which == 107 || e.which == 187 || e.which == 110 || e.which == 190 || e.which == 191 || e.which == 69) {
                    return false;
                }
            }).bind('paste', function() {
                var input = $(this);
                setTimeout(function() {
                    checkMinMax(input);
                }, 50);
            }).bind('input', function() {
                checkMinMax($(this));
            });
        }
    };

})(AJS.$);



