require(["confluence-user-profile/avatar-picker/avatar-picker-dialog"], function(ImagePickerDialog) {
    (function ($) {
        AJS.toInit(function () {

            var imagePickerDialog;
            var container = $('#course-content');
            var imageName;

            $('#upload-course-icon').click(function() {
                if (!imagePickerDialog) {
                    imagePickerDialog = new ImagePickerDialog({
                        onCrop: function(croppedDataURI) {
                            $.ajax({
                                type:'POST',
                                dataType:"json",
                                contentType:"application/json",
                                url: Confluence.getContextPath() + "/rest/quiz/1.0/course/settings/image",
                                data: JSON.stringify({
                                    name: imageName || 'Course image',
                                    courseId: container.data('id'),
                                    imageDataURI: croppedDataURI
                                }),
                                success: function(path) {
                                    $('#course-icon, #course-image').attr('src', Confluence.getContextPath() + path);
                                    imagePickerDialog.hide();
                                },
                                error: function () {
                                    imagePickerDialog.setMessage(AJS.I18n.getText('quiz.course.icon.dialog.error'));
                                }
                            });
                        }, dialogOptions: {
                            width: 310,
                            height: 400,
                            id: "course-image-picker-dialog",
                            closeOnOutsideClick: false
                        }
                    });
                }
                imagePickerDialog.show();

                var dialog = $('#course-image-picker-dialog');
                dialog.find('.dialog-components .dialog-title').text(AJS.I18n.getText('quiz.course.icon.dialog.title'));
                dialog.find('.image-upload-field-replacement.aui-button').text(AJS.I18n.getText('quiz.course.icon.dialog.btn'));

                if (dialog.find('#course-image-desc').length === 0) {
                    dialog.find('.image-upload-and-crop-field-container').append('<div id="course-image-desc" class="desc">' +
                        AJS.I18n.getText('quiz.course.icon.dialog.desc') + '</div>');
                }

                $('#image-upload-and-crop-upload-field').bind('change input', function () {
                    imageName = $(this).val().replace(/C:\\fakepath\\/i, '');
                });

                return false;
            });
        });
    })(AJS.$);
});
