import {DC_FEEDBACK_LINK, SERVER_FEEDBACK_LINK} from "./constants/feedback-links";
import AJS from 'ajs';

AJS.toInit(function() {
    let $ = AJS.$;

    if (AJS.params && AJS.params.remoteUser) {
        const FEEDBACK_COOKIE_KEY = 'hide-quiz-feedback'; //deprecated since 3.15.0
        const CQ_FEEDBACK_STATUS = 'cq-feedback-status';
        const ONE_DAY_MS = convertDaysToMS(1);
        const SEVEN_DAYS_MS = convertDaysToMS(7);
        const FOURTEEN_DAYS_MS = convertDaysToMS(14);
        const HALF_YEAR_MS = convertDaysToMS(183);
        const STATUS_TYPES = {
            DONT_SHOW_IT_AGAIN: 0,
            MAY_BE_LATER: 1,
            NOT_SHOWN: 2,
            NOT_AN_AUTHOR: 3
        };

        if (localStorage.getItem(FEEDBACK_COOKIE_KEY) != "true") {
            var feedbackStatus = localStorage.getItem(CQ_FEEDBACK_STATUS);
            if (feedbackStatus == null) {
                updateFeedbackStatus();
            } else {
                var now = new Date().getTime();
                var status = JSON.parse(feedbackStatus);

                if (status.statusType === STATUS_TYPES.NOT_AN_AUTHOR && status.timestamp + ONE_DAY_MS < now) {
                    updateFeedbackStatus();
                } else if (status.statusType === STATUS_TYPES.DONT_SHOW_IT_AGAIN && status.timestamp + HALF_YEAR_MS < now ||
                    status.statusType === STATUS_TYPES.MAY_BE_LATER && status.timestamp + FOURTEEN_DAYS_MS < now ||
                    status.statusType === STATUS_TYPES.NOT_SHOWN && status.timestamp + SEVEN_DAYS_MS < now) {

                    showDialog();
                }
            }
        }

        function updateFeedbackStatus() {
            $.ajax({
                type: 'GET',
                cache: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/settings/check-user-access-to-cq-entities",
                success: function(hasAccess) {
                    localStorage.setItem(CQ_FEEDBACK_STATUS, JSON.stringify({
                        timestamp: new Date().getTime(),
                        statusType: hasAccess ? STATUS_TYPES.NOT_SHOWN : STATUS_TYPES.NOT_AN_AUTHOR
                    }));
                },
                error: QuizErrorHandler.showError
            });
        }

        function showDialog() {
            $.ajax({
                type: 'GET',
                cache: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/settings/check-dc-license",
                success: function(isDcLicense) {
                    var feedbackLinkHref = isDcLicense ? DC_FEEDBACK_LINK : SERVER_FEEDBACK_LINK;
                    var dialog = AJS.dialog2(QuizFeedback.dialog({feedbackLinkHref: feedbackLinkHref})).show();
                    var status = {
                        timestamp: new Date().getTime()
                    };

                    dialog.$el.find('#cq-feedback-controls-dont-show').on('click', function() {
                        dialog.hide();
                        status.statusType = STATUS_TYPES.DONT_SHOW_IT_AGAIN;
                        localStorage.setItem(CQ_FEEDBACK_STATUS, JSON.stringify(status));
                    });

                    dialog.$el.find('#cq-feedback-controls-may-be-later').on('click', function() {
                        dialog.hide();
                        status.statusType = STATUS_TYPES.MAY_BE_LATER;
                        localStorage.setItem(CQ_FEEDBACK_STATUS, JSON.stringify(status));
                    });
                },
                error: QuizErrorHandler.showError
            });

        }

        function convertDaysToMS(days) {
            return days * 24 * 60 * 60 * 1000;
        }
    }
});

