import QuizDateLocalisations from "./date-locales";

export default function initDueDateSettings(AJS, $content) {
    var $ = AJS.$;
    $content.find('input[type="radio"]').change(function() {
        $('.aui-datepicker-dialog').hide();
        var parent = $(this).parent();
        var container = parent.parent();
        container.find('input[data-type]:not(.due-date), .due-date-text, .param-colon, .clear-due-date').hide();
        container.find('.due-date-text').text('');
        container.find('input[data-type]').val('').trigger('change');
        parent.find('input[data-type]:not(.due-date)').show().focus();
        parent.find('.due-date-text').html('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;').show().click();
        parent.find('.param-colon').show();
    });

    var clearDDBtn = $content.find('.clear-due-date');
    var dateInput = $content.find('.aui-date-picker');
    var dueDateText = $content.find('.due-date-text');

    dueDateText.one('click', function() {
        var minDate = $.datepicker.formatDate('yy-mm-dd', new Date());
        dateInput.attr('min', minDate);

        var localeDateFormat = (AJS.Meta.get("date.format") || AJS.Meta.get("user-date-pattern"));
        localeDateFormat = localeDateFormat ? localeDateFormat.replace('yyyy', 'yy').replace('MMM', 'M').replace('MM', 'mm') : 'yy-mm-dd';
        var locale = AJS.Meta.get("user-locale");

        if ($.fn.datePicker) {
            if (!AJS.DatePicker.prototype.localisations) {  //Scroll Viewport
                AJS.DatePicker.prototype.localisations = [];
            }
            if (AJS.DatePicker.prototype.localisations.monthNames) {
                AJS.DatePicker.prototype.localisations = QuizDateLocalisations[locale];
            } else {
                AJS.DatePicker.prototype.localisations[locale] = QuizDateLocalisations[locale];
            }
            dateInput.datePicker({overrideBrowserDefault: true, dateFormat: "yy-mm-dd", languageCode: locale});
        } else {
            dateInput.datepicker({dateFormat: "yy-mm-dd", minDate: new Date()});
        }

        dateInput.change(function() {
            var date = dateInput.val();
            if (date) {
                date = $.datepicker.parseDate('yy-mm-dd', date, QuizDateLocalisations[locale]);
                date = $.datepicker.formatDate(localeDateFormat, date, QuizDateLocalisations[locale]);
                clearDDBtn.show();
            }
            dueDateText.text(date);
        });
    });
    dueDateText.click(function() {
        dateInput.focus();
        $('.aui-datepicker-dialog').click(function(e) {
            e.stopPropagation();
        });
    });
    $content.find('.quiz-due-date-settings label').click(function() {
        var label = $(this);
        label.parent().find('#' + label.attr('for')).prop('checked', true).trigger('change');
        return false;
    });
    clearDDBtn.click(function() {
        dueDateText.html('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
        dateInput.val('');
        clearDDBtn.hide();
    });
}
