(function($) {

    window.CourseMacroAutoComplete = {
        showCourseCompletion: function(params) {
            var autocomplete = $(QuizzesMacro.input({ph: AJS.I18n.getText('courses.macro.placeholder')}));
            var courseInput = $('#macro-param-courses').hide().after(autocomplete);

            var container = $(QuizzesMacro.pagesContainer());
            $('#macro-param-div-courses').append(container);

            if (params['courses']) {
                $.each(params['courses'].split(','), function(i, id) {
                    $.ajax({
                        type: 'GET',
                        cache: false,
                        async: false,
                        url: Confluence.getContextPath() + "/rest/api/content/" + id,
                        dataType: 'json',
                        success: function(page) {
                            container.append(QuizzesMacro.page({id: id, title: page.title}));
                        }
                    });
                });
            }

            var updateIds = function() {
                var ids = [];
                $('.quiz-row').each(function() {
                    ids.push($(this).attr('id'));
                });
                courseInput.val(ids.join(',')).trigger('change');
            };

            $('.quiz-remove').live('click', function() {
                var row = $(this).parents('.quiz-row').remove();
                updateIds();
            });

            CQAutocomplete.init(autocomplete, function($suggestion) {
                if ($('#' + $suggestion.data('key')).length == 0) {
                    container.append(QuizzesMacro.page({id: $suggestion.data('key'), title: $suggestion.text()}));
                    updateIds();
                }
            }, function(token, onSuccess, onError) {
                $.ajax({
                    type: 'GET',
                    cache: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/course/search",
                    dataType: 'json',
                    data: {
                        title: token
                    },
                    success: function(variants) {
                        var data = [];
                        $.each(variants, function(i, variant) {
                            if ($('#quizzes-page-container #' + variant.key).length == 0) {
                                data.push(variant);
                            }
                        });
                        onSuccess(data);
                    },
                    error: function(errorResp) {
                        onError('Unable to find courses')
                    }
                });
            });
        }
    }

})(AJS.$);