(function($) {

    window.CQAutocomplete = {

        init: function($textarea, callback, getterCallback) {
            if ($.browser.msie  && parseInt($.browser.version, 10) <= 8) {
                return;
            }

            var t = this;
            $(document).click(function() {
                t.removeSuggestions();
            });

            t.bindTextAreaEvents($textarea, callback, getterCallback);
        },

        bindTextAreaEvents: function($textarea, callback, getterCallback) {
            this.bindTextAreaSuggestionsNavigation($textarea);
            this.bindTextAreaAutocomplete($textarea, callback, getterCallback);
        },

        bindTextAreaSuggestionsNavigation: function($textarea) {
            $textarea.keydown(function(e) {
                var $suggestionsContainer = $('.quiz-suggestions');
                var $suggestions = $suggestionsContainer.find('li:not(.quiz-suggestions-section-header)');
                if ($suggestions.length > 0) {
                    if ($.inArray(e.which, [13, 27, 38, 40]) >= 0) {
                        e.preventDefault();
                        e.stopPropagation();
                    }

                    // Enter
                    if (e.which == 13) {
                        $suggestions.filter('.quiz-suggestion-active').find('.quiz-suggestion').click();
                    }

                    // Escape
                    if (e.which == 27) {
                        $suggestionsContainer.remove();
                    }

                    // Up
                    if (e.which == 38) {
                        var current = $suggestions.filter('.quiz-suggestion-active').removeClass('quiz-suggestion-active');
                        var index = $suggestions.index(current);
                        var $prev = index > 0 ? $suggestions.eq(index - 1) : $suggestions.last();
                        $prev.addClass("quiz-suggestion-active");
                    }

                    // Down
                    if (e.which == 40) {
                        var current = $suggestions.filter('.quiz-suggestion-active').removeClass('quiz-suggestion-active');
                        var index = $suggestions.index(current);
                        var $next = index < $suggestions.length - 1 ? $suggestions.eq(index + 1) : $suggestions.eq(0);
                        $next.addClass("quiz-suggestion-active");
                    }
                }
            });
        },

        bindTextAreaAutocomplete: function($textarea, callback, getterCallback) {
            var self = this;

            $textarea.keyup(function(e) {

                clearTimeout(self.timer);

                self.timer = setTimeout(onKeyup, 500, e, $textarea, self, callback, getterCallback);
            });
        },

        bindSuggestionEvent: function($textarea, suggestions, callback) {
            var t = this;

            suggestions.click(function() {
                var $suggestion = $('.quiz-suggestion', this);
                if ($suggestion.length > 0) {
                    $textarea.val('').focus();
                    callback($suggestion);
                    t.removeSuggestions();
                }
                return false;
            });

            suggestions.hover(function() {
                $('.quiz-suggestion-active').removeClass('quiz-suggestion-active');
                $(this).addClass('quiz-suggestion-active');
            }, function() {
            });
        },

        showSuggestions: function($textarea, token, callback, getterCallback) {
            var t = this;

            getterCallback(token, function(variants) {
                t.removeSuggestions();

                $textarea.after(QuizSuggestions.suggestions({
                    suggestions: variants,
                    query: token
                }));

                $(".quiz-suggestions").css('width', $textarea.innerWidth() + 'px')
                    .offset({
                        top: $textarea.offset().top + $textarea.outerHeight() + 2,
                        left: $textarea.offset().left
                    });

                var suggestions = $('.quiz-suggestions li:not(.quiz-suggestions-section-header)');
                var highlighter = new Confluence.Highlighter(token.split(' '));

                $.each(suggestions, function() {
                    var suggestion = $(this).find('.quiz-suggestion');

                    if (suggestion.length) {          
                        suggestion.html(highlighter.highlight(suggestion.text(), true));
                    }
                });
                t.bindSuggestionEvent($textarea, suggestions, callback);
                $('.quiz-suggestions li.quiz-suggestions-section-header').click(function () {
                    return false;
                });
                suggestions.eq(0).addClass("quiz-suggestion-active");
            }, function(message) {
                t.removeSuggestions();
                AJS.log("Autocomplete error: " + message);
            });
        },

        removeSuggestions: function() {
            $('.quiz-suggestions').remove();
        },

        findParticipants: function(token, success, onError) {
            $.ajax({
                type: 'GET',
                cache: false,
                url: Confluence.getContextPath() + "/rest/prototype/1/search/user-or-group",
                data: {
                    "max-results": 7,
                    query: token
                },
                dataType: 'json',
                success: function(results) {
                    $.ajax({
                        type: 'GET',
                        cache: false,
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/service/email",
                        data: {
                            "max-results": 14 - results.result.length,
                            query: token
                        },
                        dataType: 'json',
                        success: function(data) {
                            var variants = [];
                            $.each(results.result, function(i, result) {
                                var name, icon, key;
                                if (result.type == "user") {
                                    key = result.username;
                                    name = result.title + " (" + result.username + ")";
                                    icon = result.thumbnailLink.href;
                                } else {
                                    key = result.name;
                                    name = result.name;
                                    icon = getPathToImage("group");
                                }
                                variants.push({
                                    name: name,
                                    icon: icon,
                                    type: result.type,
                                    key: key
                                });
                            });

                            $.each(data, function(i, email) {
                                variants.push({
                                    name: email,
                                    icon: getPathToImage("envelope"),
                                    type: "email",
                                    key: email
                                });
                            });

                            if (data.length == 0 && /^([a-zA-Z0-9_\.\-])+@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(token)) {
                                variants.push({
                                    name: token,
                                    icon: getPathToImage("envelope"),
                                    type: "email",
                                    key: token
                                });
                            }

                            success(variants);
                        },
                        error: function(errorResp) {
                            onError('Unable to find participants');
                        }
                    });
                }
            });
        },

        autocompleteParticipants: function($suggestion, container, btn) {
            if (container.find('li.recipient[data-key="' + $suggestion.data('key') + '"]').length == 0) {
                var recipient = $(QuizSuggestions.recipient({
                    type: $suggestion.data('type'),
                    key: $suggestion.data('key'),
                    img: $suggestion.data('img'),
                    title: $suggestion.text()
                }));
                container.find('.quiz-recipients').append(recipient);
                recipient.find('.remove-recipient').click(function() {
                    recipient.remove();
                    if (container.find('li.recipient').length == 0) {
                        btn.prop('disabled', true);
                    }
                });

                btn.prop('disabled', false);
            }
        }
    };

    function getPathToImage(imageName) {
        return Confluence.getContextPath() + "/download/resources/com.stiltsoft.confluence.quiz/images/" + imageName + ".png";
    }

    function onKeyup(e, $textarea, self, callback, getterCallback) {
        if ($.inArray(e.which, [13, 38, 40]) >= 0) {
            return;
        }

        var token = $textarea.val().trim();

        if (token.length > 0) {
            self.showSuggestions($textarea, token, callback, getterCallback);
        } else {
            self.removeSuggestions();
        }
    }

})(AJS.$);