(function($) {
    AJS.toInit(function() {
        var shareBtn = $("button.quiz");
        var settingsTable = $('#quiz-settings-table');
        shareBtn.click(function() {
            var mailServer = true;
            $.ajax({
                type: 'GET',
                cache: false,
                async: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/service/mail-server",
                success: function(data) {
                    mailServer = data;
                }
            });

            var dueDate = settingsTable.data('due-date');
            var today = new Date();
            today.setHours(0, 0, 0, 0);
            var isOverDue = dueDate && today > $.datepicker.parseDate('yy-mm-dd', dueDate);

            var dialog = new AJS.Dialog({
                width: 810,
                height: 500,
                id: "share-quiz-dialog",
                closeOnOutsideClick: false
            });

            dialog.addHeader(AJS.I18n.getText("quiz.share.dialog.title"));
            dialog.addPanel('panel',
                Quiz.dialog({
                    desc: settingsTable.find("#quiz-desc textarea").val() || '',
                    count: settingsTable.data("count") || '',
                    target: settingsTable.data("target") || '',
                    timelimitMins: Math.floor(settingsTable.data("timelimit") / 60),
                    timelimitSecs: settingsTable.data("timelimit") % 60,
                    attempts: settingsTable.data("attempts") || '',
                    showRes: settingsTable.data("showRes"),
                    showFeedback: settingsTable.data("showFeedback"),
                    random: settingsTable.data("random"),
                    skip: settingsTable.data("skip"),
                    resubmit: settingsTable.data("resubmit"),
                    mailServer: mailServer,
                    isOverDue: isOverDue
                }),
                'share-quiz-dialog-panel');

            if (mailServer || isOverDue) {
                dialog.addButton(AJS.I18n.getText("quiz.share.dialog.share"), function() {
                    submit.prop('disabled', true);
                    var $dialog = $('#share-quiz-dialog').addClass('disabled');
                    var inputs = $dialog.find('input, textarea').prop('disabled', true);
                    spinner.css('display', 'inline-block');

                    var recipients = {
                        user: [],
                        group: [],
                        email: []
                    };
                    $('.quiz-dialog li.recipient').each(function() {
                        var elem = $(this);
                        recipients[elem.data('type')].push(elem.data('key'));
                    });

                    var secs =  $('.quiz-dialog .secs').val();
                    var mins = $('.quiz-dialog .mins').val();
                    secs = secs ? parseInt(secs) : 0;
                    mins = mins ? parseInt(mins) : 0;
                    var timelimit = secs + mins * 60;

                    $.ajax({
                        type: 'POST',
                        cache: false,
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/service/test",
                        data: {
                            pageId: QuizCommons.getContentId(),
                            text: $('.quiz-dialog .textarea').val(),
                            count: $('.quiz-dialog .questions-number').val(),
                            target: $('.quiz-dialog .target').val(),
                            timelimit: timelimit,
                            attempts: $('.quiz-dialog .attempts').val(),
                            showRes: $('.quiz-dialog .show-res').is(':checked'),
                            showFeedback: $('.quiz-dialog .show-feedback').is(':checked'),
                            random: $('.quiz-dialog .random').is(':checked'),
                            skip: $('.quiz-dialog .skip').is(':checked'),
                            resubmit: $('.quiz-dialog .resubmit').is(':checked'),
                            users: recipients.user,
                            groups: recipients.group,
                            emails: recipients.email
                        },
                        dataType: 'json',
                        success: function(data) {
                            dialog.remove();
                            showAddAttemptsDialog(data);
                        },
                        error: function (xhr) {
                            QuizErrorHandler.showError(xhr);
                            submit.prop('disabled', false);
                            spinner.hide();
                            inputs.prop('disabled', false);
                            $dialog.removeClass('disabled');
                        }
                    });
                }, "share-quiz-dialog-save");
            }

            dialog.addLink(AJS.I18n.getText("share.dialog.form.cancel"), function (dialog) {
                $('.quiz-suggestions').remove();
                dialog.remove();
            }, '#');

            $('#share-quiz-dialog .dialog-title').append(Quiz.help());
            var submit = $('.share-quiz-dialog-save').prop('disabled', true);
            var spinner = $(Quiz.spinner());
            submit.before(spinner);

            CQAutocomplete.init($('.autocomplete-quiz-share'), function($suggestion) {
                    CQAutocomplete.autocompleteParticipants($suggestion, $('.quiz-dialog'), submit);
                },
                CQAutocomplete.findParticipants);

            QuizNumberUtils.bindNumberInputs($('#share-quiz-dialog'));

            var questionsCount = $('table.quiz-questions-report tbody tr').length;
            if (questionsCount > 0) {
                $('#share-quiz-dialog .questions-number').attr('max', questionsCount);
            }

            $('#share-quiz-dialog .target').bind('keyup change input', function() {
                var input = $(this);
                var max = parseInt($('#share-quiz-dialog .questions-number').val());
                max = max > 0 ? max : questionsCount > 0 ? questionsCount : 2147483647;
                if (parseInt(input.val()) > max) {
                    input.val(max);
                }
            });

            dialog.show();
        });

        //todo вот этот метод и Quiz.addAttemptsDialog нужно отрефакторить. Они делают слишком
        // хитрую логику на основании data.unenrolledUsers
        function showAddAttemptsDialog(data) {
            var dialog = new AJS.Dialog({
                width: 810,
                height: 500,
                id: "add-attempts-users-dialog",
                closeOnOutsideClick: false
            });

            var header = '';
            if (data.unenrolledUsers.length === 0) {
                header = AJS.I18n.getText("quiz.share.dialog.title");
            } else {
                header = AJS.I18n.getText("quiz.share.add-attempts.dialog.header");
            }

            dialog.addHeader(header);
            dialog.addPanel('panel', Quiz.addAttemptsDialog({data: data}), 'add-attempts-users-dialog');

            var container = $('#quiz-add-attempts');
            var input = container.find('#add-attempts');

            dialog.addButton(AJS.I18n.getText("quiz.share.add-attempts.dialog.add"), function() {
                btn.prop('disabled', true);
                var keys = [];
                checkboxes.filter(':checked').each(function () {
                    keys.push($(this).attr('id'));
                });

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/service/users/add-attempts",
                    data: {
                        quizId: QuizCommons.getContentId(),
                        attempts: input.val(),
                        keys: keys
                    },
                    dataType: 'json',
                    success: function() {
                        dialog.remove();
                        location.reload();
                    },
                    error: QuizErrorHandler.showError
                });
            }, "update-attempts-dialog-ok");
            dialog.addLink(AJS.I18n.getText("close.name"), function (dialog) {
                dialog.remove();
                if (data.enrolledCount) location.reload();
            }, '#');

            var btn = $('.update-attempts-dialog-ok').hide().prop('disabled', true);

            var checkboxes = container.find('input.participant-checkbox').change(function() {
                if (checkboxes.filter(':checked').length === 0) {
                    btn.prop('disabled', true);
                } else if (parseInt(input.val()) > 0) {
                    btn.prop('disabled', false);

                }
            });

            $('#select-all-enrollers').change(function () {
                checkboxes.prop('checked', $(this).is(':checked'));
                input.trigger('input')
            });

            input.bind('input', function () {
                if (parseInt(input.val()) > 0 && checkboxes.filter(':checked').length > 0) {
                    btn.prop('disabled', false);
                } else {
                    btn.prop('disabled', true);
                }
            });

            $('#show-add-attempts').click(function () {
                $(this).remove();
                $('#hidden-add-attempts-container').show();
                btn.show();
                return false;
            });

            dialog.show();
        }
    });
})(AJS.$);
