(function($) {

    if (window.QUIZZES_JS_ALREADY_LOADED === undefined) {
        const EMAIL_REG_EXP = /^([a-zA-Z0-9_\.\-])+@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        const EMPTY_MAIL = '';
        const EMPTY_NAME = '';

        var init = function() {
            //TODO в мобильной версии здесь используется библиотека Zepto и с ней был баг QUIZ-654
            //нужно изучить и подумать, может вообще стоит отказаться от Zepto.js
            //TODO это регулярное выражение писалось очень давно и, скорее всего, появились новые устройства
            //но вообще, определять таким способом устройство не очень хорошо, для начала можно почитать здесь
            //https://developer.mozilla.org/en-US/docs/Web/HTTP/Browser_detection_using_the_user_agent
            var btns = $('.take-quiz');
            var isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
            var isLoggedIn = AJS.params ? AJS.params.remoteUser : JSON.parse($('meta[name="ajs-current-user"]').attr('content')).anonymousUser === false;
            if (!Confluence.getContextPath) {
                Confluence.getContextPath = function() {
                    return $('meta[name="confluence-context-path"]').attr('content');
                }
            }

            btns.each(function() {
                var btn = $(this);

                var isAdminPreview = btn.hasClass('preview-quiz');
                var isAnonymous = btn.data('anonymous');
                var pageId = btn.data('page-id');
                var author = btn.data('author');
                var newTab = btn.data('new-tab');
                //todo тут и в прочих местах неплохо бы юзать строгие сравнения, но для этого нужно проводить тесты для каждого места
                var anonymousConfirmation = btn.attr('data-anonymous-confirmation') == 'false';

                btn.bind('click',function() {
                    if (isLoggedIn || isAnonymous) {
                        takeQuiz(pageId, author, EMPTY_MAIL, EMPTY_NAME, function(data) {
                            if (isQuizAvailable(data)) {
                                var href = Confluence.getContextPath() + data.url;
                                if (isAdminPreview) {
                                    href = href + '&view=admin';
                                }
                                if (newTab) {
                                    window.open(href,'_blank');
                                } else {
                                    window.location.href = href;
                                }
                            } else {
                                showNoAttemptsDialog(data, isMobile, isAdminPreview);
                            }
                        });
                    } else {
                        var dialog = new AJS.Dialog({
                            width: isMobile ? 310 : 550,
                            height: isMobile ? 390 : 330,
                            id: "take-quiz-dialog",
                            closeOnOutsideClick: false
                        });
                        var finish = false;

                        dialog.addHeader(AJS.I18n.getText("quizzes.take"));
                        dialog.addPanel('panel', QuizzesTemplate.dialog({anonymousConfirmation: anonymousConfirmation}), 'take-quiz-dialog-panel' + isMobile ? ' mobile' : '');
                        dialog.addButton(!anonymousConfirmation ? AJS.I18n.getText("quizzes.take") : AJS.I18n.getText("quizzes.dialog.mail.send"), function() {
                            $('#quizzes-mail .quiz-error').css('visibility', 'hidden');
                            var mailInput = $('#quizzes-mail-input');
                            var mailInputValue = mailInput.val().trim();
                            var nameInput = $('#quizzes-name-input');
                            var nameInputValue = nameInput.val().trim();

                            //TODO слишком много условий, нужно рефакторить
                            if (!finish) {
                                if (!nameInputValue) {
                                    $('#quizzes-mail .empty-name').css('visibility', 'visible');
                                    nameInput.focus();
                                } else if (!mailInputValue) {
                                    $('#quizzes-mail .empty-mail').css('visibility', 'visible');
                                    mailInput.focus();
                                } else if (!EMAIL_REG_EXP.test(mailInputValue) && nameInputValue) {
                                    $('#quizzes-mail .wrong-mail').css('visibility', 'visible');
                                    mailInput.focus();
                                } else {
                                    finish = true;
                                    takeQuiz(pageId, author, mailInputValue, nameInputValue, function(data) {
                                        if (!anonymousConfirmation) {
                                            dialog.remove();
                                            if (isQuizAvailable(data)) {
                                                var href = Confluence.getContextPath() + data.url;
                                                if (newTab) {
                                                    window.open(href,'_blank');
                                                } else {
                                                    window.location.href = href;
                                                }
                                            } else {
                                                showNoAttemptsDialog(null, isMobile, isAdminPreview);
                                            }
                                        } else {
                                            if (isQuizAvailable(data)) {
                                                $('#quizzes-mail').hide();
                                                $('#take-quiz-dialog .aui-message').show();
                                                $('#take-quiz-dialog .button-panel-link').remove();
                                                $('#take-quiz-dialog .take-quiz-dialog-ok').text(AJS.I18n.getText("quizzes.dialog.mail.close"));
                                                if (isMobile) {
                                                    $('#take-quiz-dialog').height(240).find('.dialog-panel-body').height(133);
                                                }
                                            } else {
                                                dialog.remove();
                                                showNoAttemptsDialog();
                                            }
                                        }
                                    });
                                }
                            } else {
                                dialog.remove();
                            }
                        }, "take-quiz-dialog-ok");
                        dialog.addLink(AJS.I18n.getText("quiz.create-wizard.dialog.cancel"), function (dialog) {
                            dialog.remove();
                        }, '#');

                        dialog.show();
                    }
                });
            });
        }

        function isQuizAvailable(resp) {
            return resp !== "overdue" && resp !== "no-attempts";
        }

        function takeQuiz(pageId, author, mail, name, success) {
            $.ajax({
                type: 'GET',
                cache: false,
                async: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/service/take/quiz",
                dataType: 'json',
                data: {
                    pageId: pageId,
                    author: author,
                    mail: mail,
                    name: name
                },
                success: success,
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function showNoAttemptsDialog(data, isMobile, isAdminPreview) {
            var dialog = new AJS.Dialog({
                width: isMobile ? 310 : 650,
                height: isAdminPreview ? 340 : isMobile ? 260 : 320,
                id: "no-attempts-dialog",
                closeOnOutsideClick: false
            });

            dialog.addHeader(AJS.I18n.getText("quizzes.take"));
            dialog.addPanel('panel', getNoAttemptsDialogBody(), 'no-attempts-dialog');
            dialog.addLink(AJS.I18n.getText("quizzes.dialog.mail.close"), function (dialog) {
                dialog.remove();
            }, '#');

            dialog.show();

            function getNoAttemptsDialogBody() {
                if (data === 'overdue') {
                    if (isAdminPreview) {
                        return QuizzesTemplate.overdueAdmin();
                    } else {
                        return QuizzesTemplate.overdue();
                    }
                } else if (isAdminPreview) {
                    return QuizzesTemplate.cantTakeAdmin();
                } else {
                    return QuizzesTemplate.cantTake();
                }
            }
        }

        if (window.ConfluenceMobile) {
            ConfluenceMobile.contentEventAggregator.on("displayed", init);
        } else {
            AJS.toInit(init);
        }

        window.QUIZZES_JS_ALREADY_LOADED = true;
    }
})(AJS.$ || Zepto);



