import initDueDateSettings from "../utils/due-date-settings";
import DOMPurify from "dompurify";

(function($) {

    window.QuizSettings = {

        //TODO нужно отрефакторить этот файл, потому что уже сложно понять, что здесь происходит
        singleCheckBoxTypes: ['show-res', 'skip', 'show-feedback', 'random', 'anonymous', 'skip-start-page', 'resubmit',
            'anonymous-confirmation', 'disable-user-notification', 'disable-take-notification', 'retake-on-fail', 'show-answers'],
        pagesTypes: ['success-page-id', 'fail-page-id', 'review-page-id', 'start-page-id'],
        checkboxValueType: ['due-date', 'due-days', 'enrollment-reminder', 'duedate-reminder', 'enrollment-reminder-msg', 'duedate-reminder-msg'],
        updateEnrolledTypes: ['due-date', 'due-days', 'attempts', 'enrollment-reminder', 'duedate-reminder'],
        reminders: ['enrollment-reminder', 'duedate-reminder'],

        init: function () {
            var self = this;
            self.table = $('#quiz-settings-table');
            self.views = self.table.find('.quiz-settings-view');
            self.edits = self.table.find('.quiz-settings-edit');
            self.targetEdit = $('#quiz-settings-target-edit input');
            self.authorsEdit = $('#quiz-settings-authors-edit');
            self.authorsView = $('#quiz-settings-authors-view');
            self.anonymousInputs = $('#quiz-settings-anonymous-edit input');
            self.dueDateText = self.edits.find('.due-date-text');
            self.prevValue = '';
            self.input = self.edits.filter(':visible').find('input, textarea');
            self.isDialog = false;

            self.setQuestionsCount();
            self.loadReminderMessages();

            if ($('body.content-preview').length || $('#quiz-settings-table:not(.editable)').length) {
                self.views.find('input').attr('disabled', 'disabled');
                return;
            }

            self.bindEditing();
            self.bindUsersAutocomplete();
            self.bindPageSelect();
            self.bindNumberInputs();
            self.bindAnonymousInputs();
            self.bindDueDateInputs();
            self.bindCheckboxValueInputs();
            self.setDueDateReminderInput();
        },

        startEditing: function (view) {
            var self = QuizSettings;
            var height = Math.max(view.find('.textarea-view').height(), 20);
            var edit = view.parent().find('.quiz-settings-edit');

            self.cancelEditing();
            self.editing = true;
            view.hide();
            self.input = edit.show().find('input[data-type]:not(.timelimit), textarea');
            var type = self.input.data('type');
            self.input.filter(':not(.due-date, .reminder-msg):visible').focus();
            self.input.filter('textarea').height(height);

            if (type == 'timelimit') {
                var timelimitParent = self.input.parent();
                var secs = self.table.data('timelimit');
                timelimitParent.find('.mins').focus().val(Math.floor(secs / 60));
                timelimitParent.find('.secs').val(secs % 60);
            }

            if (self.singleCheckBoxTypes.indexOf(type) !== -1) {
                self.prevValue = [];
                self.input.each(function() {
                    self.prevValue.push($(this).is(':checked'));
                });
            } else if (self.checkboxValueType.indexOf(type) !== -1) {
                self.prevValue = self.getSettingCurrentValue();
            } else {
                self.prevValue = self.input.val();
            }
        },

        cancelEditing: function() {
            var self = QuizSettings;

            if (self.isDialog) return;
            if (!self.editing) return;
            self.editing = false;
            var type = self.input.data('type');
            if (type === 'authors') {
                self.input.val('');
                self.authorsEdit.find('.quiz-recipients').replaceWith(self.authorsView.find('.quiz-recipients').clone());
            } else if (self.singleCheckBoxTypes.indexOf(type) !== -1) {
                self.input.each(function(i) {
                    $(this).attr('checked', self.prevValue[i]);
                });
            } else if (self.checkboxValueType.indexOf(type) !== -1) {
                self.input.each(function(i) {
                    var thisInput = $(this).val(self.prevValue[i]);
                    if (thisInput.is('input')) {
                        var parent = thisInput.parent();
                        parent.find('input[type="radio"], input[type="checkbox"]').prop('checked', self.prevValue[i].length > 0);
                        var stuff = parent.find('.param-colon, .due-date-text, input[data-type="due-days"], .clear-due-date, .reminder-input');
                        if (!self.prevValue[i]) {
                            stuff.hide();
                        } else {
                            stuff.show();
                        }
                    }
                });
                self.dueDateText.text(self.views.find('.due-date').text());
            } else {
                self.input.val(self.prevValue);
            }

            if (self.pagesTypes.indexOf(type) !== -1) {
                self.input.data('page-id', self.table.data(type));
            }

            self.views.show();
            self.edits.hide();
            $('.aui-datepicker-dialog').hide();
        },

        getSettingCurrentValue: function() {
            let self = QuizSettings;
            return self.input.map((index, el) => el.value).get();
        },

        shouldShowUpdateEnrolledDialog: function(settingsType) {
            let self = QuizSettings;
            let newValue = self.input.val();

            switch (settingsType) {
                case 'attempts': return self.prevValue !== newValue;
                // для dueDate сравниваем сразу весь массив self.prevValue, где лежит dueDate и daysAfterEnrollment
                case 'due-date': return JSON.stringify(self.getSettingCurrentValue()) !== JSON.stringify(self.prevValue)
                // для enrollment-reminder и duedate-reminder self.prevValue[0] - количество дней, self.prevValue[1] - текст напоминалки
                case 'enrollment-reminder': return self.prevValue[0] !== newValue;
                case 'duedate-reminder': return self.prevValue[0] !== newValue;
                default: return false;
            }
        },

        save: function(updateEnrolled) {
            var self = QuizSettings;

            var type = self.input.data('type');

            if (updateEnrolled === undefined && self.updateEnrolledTypes.indexOf(type) !== -1 &&
                $('.quiz-answers-report-content .quiz-answers-report-table tbody tr').length > 0 &&
                self.shouldShowUpdateEnrolledDialog(type)) {

                self.isDialog = true;

                var dialog = new AJS.Dialog({
                    width: 550,
                    height: 250,
                    id: "update-attempts-dialog",
                    closeOnOutsideClick: false
                });

                var dialogHeader = AJS.I18n.getText("quiz.answers-report.due-date.dialog.header");
                if (type === 'attempts') {
                    dialogHeader = AJS.I18n.getText("quiz.settings.dialog.attempts.header");
                } else if (self.reminders.indexOf(type) >= 0) {
                    dialogHeader = AJS.I18n.getText("quiz.course.settings.dialog.reminder-days");
                }
                dialog.addHeader(dialogHeader);
                dialog.addPanel('panel', QuizSettingsTemplate.updateEnrolledDialog({type: type.replace('-', '')}), 'update-attempts-dialog');
                dialog.addButton(AJS.I18n.getText("update.word"), function() {
                    updateEnrolled = $('#update-enrolled-input').is(':checked');
                    dialog.remove();
                    self.isDialog = false;
                    self.save(updateEnrolled);
                }, "update-attempts-dialog-ok");
                dialog.addLink(AJS.I18n.getText("cancel.name"), function () {
                    dialog.remove();
                    self.isDialog = false;
                    self.cancelEditing();
                }, '#');

                dialog.show();
                return;
            }

            if (type == 'timelimit') {
                var timelimitParent = self.input.parent();
                var secs =  timelimitParent.find('.secs').val();
                var mins = timelimitParent.find('.mins').val();
                secs = secs ? parseInt(secs) : 0;
                mins = mins ? parseInt(mins) : 0;
                self.input.val(secs + mins * 60);
            }

            self.prevValue = self.input.val();
            var insertValue = self.prevValue;

            if (type === 'authors') {
                var recipients = self.authorsEdit.find('.quiz-recipients');
                insertValue = recipients[0].outerHTML;
                var authors = [];
                recipients.find('.recipient').each(function() {
                    authors.push($(this).data('key'));
                });
                self.prevValue = authors.join(',');
                if (authors.length) {
                    self.authorsView.find('.quiz-settings-authors-ph').hide();
                } else {
                    self.authorsView.find('.quiz-settings-authors-ph').show();
                }
            } else if (type == 'desc') {
                insertValue = self.prevValue;
                if (insertValue) {
                    self.table.find('.quiz-settings-desc-ph').hide();
                } else {
                    self.table.find('.quiz-settings-desc-ph').show();
                }
            } else {
                if (self.pagesTypes.indexOf(type) !== -1) {
                    self.prevValue = self.input.data('page-id');
                } else if (self.singleCheckBoxTypes.indexOf(type) !== -1) {
                    self.prevValue = [];
                    self.input.each(function() {
                        self.prevValue.push($(this).is(':checked'));
                    });
                    insertValue = self.prevValue;
                } else if (self.checkboxValueType.indexOf(type) !== -1) {
                    self.prevValue = self.getSettingCurrentValue();
                    insertValue = self.prevValue;
                } else if (!insertValue.trim() || insertValue == 0) {
                    if (type == 'count') {
                        insertValue = AJS.I18n.getText('quiz.settings.count-all');
                    } else if (type == 'target') {
                        insertValue = AJS.I18n.getText('quiz.settings.target-all');
                    } else if (type == 'timelimit') {
                        insertValue = AJS.I18n.getText('quiz.settings.timelimit-no');
                    } else if (type == 'attempts') {
                        insertValue = AJS.I18n.getText('quiz.settings.attempts-no');
                    }
                } else if (type == 'timelimit') {
                    var seconds = self.prevValue % 60 ;
                    var minutes = Math.floor(self.prevValue / 60) % 60;
                    var hours = Math.floor(self.prevValue / 3600);
                    insertValue = "";
                    if (hours > 0) {
                        var h = hours > 1 ? AJS.I18n.getText('quiz.settings.timelimit.hours') : AJS.I18n.getText('quiz.settings.timelimit.hour');
                        insertValue = hours + " " + h + " ";
                    }
                    if (minutes > 0) {
                        var m = minutes > 1 ? AJS.I18n.getText('quiz.settings.timelimit.minutes') : AJS.I18n.getText('quiz.settings.timelimit.minute');
                        insertValue += minutes + " " + m + " ";
                    }
                    if (seconds > 0) {
                        var s = seconds > 1 ? AJS.I18n.getText('quiz.settings.timelimit.seconds') : AJS.I18n.getText('quiz.settings.timelimit.second');
                        insertValue += seconds + " " + s;
                    }
                    insertValue = insertValue.trim();
                }
                self.table.data(type, self.prevValue);

                if (type == 'count') {
                    var maxTarget = self.prevValue && self.prevValue > 0 ? self.prevValue : '';
                    if (self.questionsCount > 0) {
                        maxTarget = maxTarget ? Math.min(parseInt(maxTarget), self.questionsCount) : self.questionsCount;
                    }
                    self.targetEdit.attr('max', maxTarget);
                }
            }

            if (self.singleCheckBoxTypes.indexOf(type) !== -1 || self.checkboxValueType.indexOf(type) !== -1) {
                var updatedEnrolled = false;
                self.input.each(function(i, elem) {
                    var inputType = $(elem).data('type');
                    self.table.data(inputType, self.prevValue[i]);

                    $.ajax({
                        type: 'POST',
                        cache: false,
                        async: false,
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/service/settings",
                        data: {
                            pageId: QuizCommons.getContentId(),
                            type: inputType,
                            value: self.prevValue[i],
                            updateEnrolled: updateEnrolled && !updatedEnrolled && (self.reminders.indexOf(inputType) >=0 || self.prevValue[i] != '' || self.input.length - 1 === i)
                        },
                        error: QuizErrorHandler.showError
                    });
                    updatedEnrolled = updatedEnrolled || self.prevValue[i] != '';
                });
            } else {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/service/settings",
                    data: {
                        pageId: QuizCommons.getContentId(),
                        type: type,
                        value: self.prevValue,
                        updateEnrolled: updateEnrolled || false
                    },
                    success: function () {
                        if (updateEnrolled) location.reload();
                    },
                    error: QuizErrorHandler.showError
                });
            }

            if (self.pagesTypes.indexOf(type) !== -1) {
                var view = self.input.parents('td:eq(0)').find('.quiz-settings-view');
                var a = view.find('a');
                a.html(insertValue);
                a.attr('href', Confluence.getContextPath() + '/pages/viewpage.action?pageId=' + self.prevValue);
                self.prevValue = insertValue;
                var defaultPage = view.find('.default-page');
                insertValue ? defaultPage.hide() : defaultPage.show();
            } else if (self.singleCheckBoxTypes.indexOf(type) !== -1) {
                self.input.each(function(i) {
                    $(this).parents('td:eq(0)').find('.quiz-settings-view input').eq(i).attr('checked', insertValue[i]);
                });
            } else if (self.checkboxValueType.indexOf(type) !== -1) {
                self.input.each(function(i) {
                    var thisInput = $(this);
                    var thisView = thisInput.parents('td:eq(0)').find('.quiz-settings-view');
                    var thisViewInput = thisView.find('[data-view-type="' + thisInput.data('type') + '"]');

                    if (thisInput.is('textarea')) {
                        self.convertWikiToView(insertValue[i], function (html) {
                            thisViewInput.html(html);
                        });
                    } else if (thisInput.hasClass('due-date')) {
                        thisViewInput.text(self.dueDateText.text());
                    } else {
                        thisViewInput.text(insertValue[i]);
                    }

                    if (thisInput.is('input')) {
                        thisView.find('input[type="radio"], input[type="checkbox"]').eq(i).prop('checked', insertValue[i].length > 0);
                        if (insertValue[i].length) {
                            thisView.find('.param-colon').eq(i).show();
                        } else {
                            thisView.find('.param-colon').eq(i).hide();
                        }
                    }
                });

                self.setDueDateReminderInput();
            } else if (type === 'authors') {
                self.authorsView.find('.quiz-recipients').replaceWith(self.authorsEdit.find('.quiz-recipients').clone());
            } else {
                self.convertWikiToView(insertValue, function (html, r) {
                    self.input.parents('td:eq(0)').find('.quiz-settings-view span:eq(0)').html(html);
                });
            }
            self.cancelEditing();
        },

        bindEditing: function () {
            var self = this;

            self.edits.find('textarea').elastic();
            self.edits.click(function(e) {
                e.stopPropagation();
            });

            self.views.click(function(e) {
                if ($(e.target).is('a')) {
                    return;
                }
                self.startEditing($(this));

                return false;
            });

            $(document).click(function() {
                self.cancelEditing();
            });

            self.edits.find('input, textarea').keydown(function(e) {
                if (e.which == 13) {
                    if (self.input.is('textarea') && !e.ctrlKey) {
                        return;
                    }
                    if ((self.input.is('.autocomplete-user') || self.input.is('.autocomplete-confluence-content')) && !e.ctrlKey) {
                        return $('.quiz-settings-edit .autocomplete li.active').length != 0;
                    }
                    self.save();
                    return false;
                } else if (e.which == 27) {
                    self.cancelEditing();
                }
            });
            self.edits.find('.cancel').click(self.cancelEditing);
            self.edits.find('.submit').click(function() {
                self.save();
                return false;
            });
        },

        bindUsersAutocomplete: function () {
            var self = this;

            var authorsInput = self.authorsEdit.find('input').bind("selected.autocomplete-user", function(e, data) {
                authorsInput.val('');

                if (self.authorsEdit.find('.recipient[data-key="' + data.content.userKey + '"]').length) {
                    return;
                }

                var recipient = $(QuizUsers.recipient({
                    name: data.content.key,
                    fullName: data.content.title,
                    key: data.content.userKey,
                    img: data.content.thumbnailLink.href
                }));

                self.authorsEdit.find('ol.recipients.quiz-recipients').append(recipient);
                Confluence.Binder.userHover();
            });

            self.authorsEdit.delegate('.remove-recipient', 'click', function() {
                $(this).parent().remove();
            });
        },

        bindPageSelect: function () {
            $('#quiz-settings-success-page-edit input, #quiz-settings-fail-page-edit input, ' +
                '#quiz-settings-review-page-edit input, #quiz-settings-start-page-edit input')
                .bind('selected.autocomplete-content', function(e, content) {
                    $(this).data('page-id', content.content.id);
                }).bind('input keyup change', function() {
                if (!$(this).val().trim()) {
                    $(this).data('page-id', '');
                }
            });
        },

        bindNumberInputs: function () {
            var self = this;

            QuizNumberUtils.bindNumberInputs(self.edits);
            self.setTargetInputsLimits();
        },

        setTargetInputsLimits: function() {
            var self = this;

            var maxTarget = self.table.data('count') && self.table.data('count') > 0 ? self.table.data('count') : '';
            if (self.questionsCount > 0) {
                $('#quiz-settings-count-edit input').attr('max', self.questionsCount);
                maxTarget = maxTarget ? Math.min(maxTarget, self.questionsCount) : self.questionsCount;
            }
            self.targetEdit.attr('max', maxTarget);
        },

        bindAnonymousInputs: function () {
            var self = this;
            self.anonymousInputs.change(function() {
                var input = $(this);
                if (input.is(':checked')) {
                    self.anonymousInputs.not(input).prop('checked', false);
                }
            });
        },

        bindDueDateInputs: function () {
            var self = this;
            initDueDateSettings(AJS, self.edits);
        },

        bindCheckboxValueInputs: function () {
            var self = this;
            self.edits.find('.checkbox-value').change(function () {
                var checkbox = $(this);
                var parent = checkbox.parent();
                var stuff = parent.find('.reminder-input, .param-colon');

                if (checkbox.is(':checked')) {
                    stuff.show();
                    stuff.filter('.reminder-input').focus();
                } else {
                    stuff.hide();
                    stuff.filter('.reminder-input, textarea').val('');
                }
            });
        },
        
        setDueDateReminderInput: function () {
            var self = this;
            var input = self.edits.find('input[data-type="duedate-reminder"]');
            var dueDate = self.table.data('due-date');
            var dueDays = self.table.data('due-days');

            if (dueDays) {
                input.attr('max', dueDays - 1);
            } else if (dueDate) {
                var date = $.datepicker.parseDate('yy-mm-dd', dueDate);
                var daysBefore = parseInt((date.getTime() - new Date().getTime()) / (24 * 60 * 60 *1000));
                if (daysBefore <= 0) {
                    daysBefore = '';
                }
                input.attr('max', daysBefore);
            } else {
                input.attr('max', '');
            }
        },

        convertWikiToView: function (wiki, callback) {
            if (wiki) {
                $.ajax({
                    type: 'POST',
                    url: Confluence.getContextPath() + "/rest/tinymce/1/wikixhtmlconverter",
                    dataType: 'text',
                    headers: {
                        'Accept': 'text/plain, */*; q=0.01',
                        'Content-Type': 'application/json; charset=UTF-8'
                    },
                    data: JSON.stringify({
                        entityId: QuizCommons.getContentId(),
                        spaceKey: AJS.params.spaceKey,
                        wiki: wiki
                    }),
                    success: callback,
                    error: QuizErrorHandler.showError
                });
            } else {
                callback(wiki);
            }
        },

        setQuestionsCount: function () {
            this.questionsCount = $('table.quiz-questions-report tr[data-id]').length;
        },

        loadReminderMessages: function() {
            let self = this;
            $.ajax({
                type: 'GET',
                cache: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/service/settings/reminder-messages",
                dataType: 'json',
                data: {
                    pageId: QuizCommons.getContentId()
                },
                success: messages => {
                    self.convertWikiToView(messages.enrollmentReminderMsg, html => {
                        $('div[data-view-type="enrollment-reminder-msg"]').html(DOMPurify.sanitize(html));
                    });
                    $('textarea[data-type="enrollment-reminder-msg"]').val(DOMPurify.sanitize(messages.enrollmentReminderMsg));
                    self.convertWikiToView(messages.dueDateReminderMsg, html => {
                        $('div[data-view-type="duedate-reminder-msg"]').html(DOMPurify.sanitize(html));
                    });
                    $('textarea[data-type="duedate-reminder-msg"]').val(DOMPurify.sanitize(messages.dueDateReminderMsg));

                    $('.reminder-message-spinner').hide();
                    $('.reminder-msg-view').show()
                },
                error: errorResp => {
                    $('.reminder-view').off().find('.reminder-message-spinner, .overlay-icon').hide();
                    $('[name="enrollment-reminder"],[name="duedate-reminder"]').attr('disabled', 'disabled');
                    $('.reminder-error-message').show();
                }
            });
        }
    };

    AJS.toInit(function() {
        QuizSettings.init();
        AJS.bind('quiz-questions-report-updated', function () {
            QuizSettings.setQuestionsCount();
            QuizSettings.setTargetInputsLimits();
        });
    });
})(AJS.$);


