(function($) {

    window.QuizQuestionsReport = {

        init: function () {
            var self = this;
            self.table = $('.quiz-questions-report');
            self.tableTop = $('.quiz-questions-report-content form.aui');
            self.isIndex = self.table.hasClass('index');
            self.tbody = self.table.find('tbody');

            self.bindInputs();
        },

        makeTableSortable: function () {
            var self = this;
            var tds = self.tbody.find('tr:eq(0) td');
            var cols = self.table.find('col');
            var colWidth = [];
            var tdWidth = [];

            if (!self.table.hasClass('index')) {
                self.table.mousedown(function() {
                    colWidth = [];
                    tdWidth = [];
                    tds.each(function() {
                        colWidth.push($(this).outerWidth());
                        tdWidth.push($(this).width());
                    });
                });

                self.table.find('tbody').sortable({
                    containment: 'parent',
                    tolerance: "pointer",
                    axis: 'y',
                    start: function(e, ui) {
                        ui.item.children('td').each(function(i) {
                            $(this).width(tdWidth[i] + 1);
                        });
                        cols.each(function(i) {
                            $(this).width(colWidth[i]);
                        });
                        self.tbody.append(ui.item);
                    },
                    stop: function(e, ui) {
                        ui.item.children('td').each(function() {
                            $(this).width('');
                        });
                        cols.each(function() {
                            $(this).width('');
                        });

                        var ids = [];
                        self.tbody.find('tr').each(function() {
                            var tr = $(this);
                            ids.push(tr.data('id'));
                        });

                        $.ajax({
                            type: 'POST',
                            cache: false,
                            url: Confluence.getContextPath() + "/rest/quiz/1.0/quiz-question/question/reorder",
                            data: {
                                quizId: QuizCommons.getContentId(),
                                ids: ids,
                                id: ui.item.data('id'),
                                categoryId: 0
                            },
                            error: QuizErrorHandler.showError
                        });
                    }
                });

                self.table.bind("sortEnd", function() {
                    self.table.find('.ui-sortable-placeholder').remove();
                });
            }
        },

        bindInputs: function () {
            var self = this;
            self.randomInputs = self.table.find('input.random');
            self.selects = $('input.qqr-select');
            self.savePanel = $('#quiz-questions-save-changes');
            self.reusePanel = $('#qqr-reuse-panel');
            self.saveBtn = $('#quiz-questions-save');
            self.reuseBtn = $('#qqr-reuse');
            self.endPoint = self.table.parents('.quiz-questions-report-content').find('.end-point');
            self.panels = self.savePanel.add(self.reusePanel);

            if (self.isIndex) {
                self.bindRandomInputs();
                self.bindSelects();
                self.bindQuizzesEdit();
            }

            self.bindReuseQuestions();

            registerResizeEventListener('.quiz-questions-report-content', self.updatePanelPosition);
        },

        bindRandomInputs: function () {
            var self = this;
            var prevParams = self.getRandomParams();
            var newParams = prevParams;
            var ids = [];
            self.tbody.find('tr').each(function() {
                ids.push($(this).data('id'));
            });

            self.randomInputs.change(function() {
                newParams = self.getRandomParams();
                var equals = true;
                prevParams.some(function(element, index) {
                    equals = equals && element === newParams[index];
                    return !equals;
                });
                if (!equals) {
                    self.endPoint.show();
                    self.updatePanelPosition();
                    self.savePanel.show();
                    self.selects.add(self.table.find('input.qqr-select-all')).prop('disabled', true);
                    $(window).bind('beforeunload.quiz-questions', function() {
                        return AJS.I18n.getText("quiz.answers.changes.not-saved");
                    });
                    self.saveBtn.prop('disabled', false);
                } else {
                    self.hideSavePanel();
                }
            });

            $('#quiz-questions-cancel').click(function() {
                self.randomInputs.prop('checked', false);
                prevParams.forEach(function(n, i) {
                    self.randomInputs.eq(i).prop('checked', n);
                });
                self.hideSavePanel();

                return false;
            });

            self.saveBtn.click(function() {
                var changes = {ids: [], values: []};
                for (var i = 0; i < ids.length; i++) {
                    if (newParams[i] != prevParams[i]) {
                        changes.ids.push(ids[i]);
                        changes.values.push(newParams[i]);
                    }
                }

                self.saveBtn.prop('disabled', true);

                $.ajax({
                    type: 'POST',
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/quiz-question/change-answers-randomize",
                    data: {
                        pageIds: changes.ids,
                        values: changes.values
                    },
                    success: function() {
                        self.hideSavePanel();
                        prevParams = newParams;
                    },
                    error: QuizErrorHandler.showError
                });

                return false;
            });
        },

        bindSelects: function () {
            var self = this;

            var select = function(checked) {
                if (checked) {
                    self.randomInputs.prop('disabled', true);
                    self.showReusePanel();
                } else {
                    self.hideReusePanel();
                }
            };

            self.table.find('input.qqr-select-all').live('change', function () {
                var checked = $(this).is(':checked');
                self.selects.prop('checked', checked);
                select(checked);
            });

            self.selects.change(function () {
                select(self.selects.filter(':checked').length);
            });
        },

        bindReuseQuestions: function () {
            var self = this;
            
            $('#qqr-reuse-cancel').click(function () {
                self.hideReusePanel();
                return false;
            });

            self.reuseBtn.click(function () {
                var dialog = new AJS.Dialog({
                    width: 810,
                    height: 500,
                    id: "reuse-question-dialog",
                    closeOnOutsideClick: false
                });

                var quizIds = [];
                var questionsContainer;

                dialog.addHeader(AJS.I18n.getText("quiz.question.report.reuse"));
                dialog.addPanel('panel', QuizQuestionsReportTemplate.dialog(), 'reuse-question-dialog-panel');
                dialog.addButton(AJS.I18n.getText("quiz.question.report.dialog.reuse"), function() {
                    var questionIds = [];
                    questionsContainer.find('tr.quiz-row').each(function () {
                        questionIds.push(this.id);
                    });
                    reuseDialogBtn.prop('disabled', true);
                    reuseDialogBtn.before($('<img class="wait-icon" src="' + Confluence.getContextPath() +'/images/icons/wait.gif">'));

                    $.ajax({
                        type: 'POST',
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/quiz-question/add-questions",
                        data: {
                            questionIds: questionIds,
                            quizIds: quizIds
                        },
                        success: function () {
                            var msg = AJS.messages.success({
                                body: AJS.I18n.getText('quiz.question.report.dialog.reuse.success'),
                                closeable: true,
                                fadeout: true,
                                delay: 2000,
                                duration: 300
                            });
                            msg.css({position: 'fixed', top: '50px', right: '30px', 'z-index': 10000});
                            $('body').append(msg);

                            self.hideReusePanel();
                            dialog.remove();
                            if (self.table.hasClass('index')) {
                                location.reload();
                            }
                        },
                        error: QuizErrorHandler.showError
                    });

                }, "reuse-question-dialog-ok");
                dialog.addLink(AJS.I18n.getText("quiz.create-wizard.dialog.cancel"), function (dialog) {
                    dialog.remove();
                    self.hideReusePanel();
                }, '#');

                var reuseDialogBtn = $('.reuse-question-dialog-ok');
                reuseDialogBtn.prop('disabled', true);

                questionsContainer = $('#questions-page-container');
                var pagesHtml = '';
                self.selects.filter(':checked').each(function () {
                    var td = this.parentElement;
                    var tr = td.parentElement;
                    var title = td.nextElementSibling.textContent;
                    pagesHtml += QuizQuestionsReportTemplate.page({id: tr.attributes['data-id'].nodeValue, title: title, hint: title});
                });
                questionsContainer.append(pagesHtml);

                var questionsWrapper = $('.quiz-dialog-param-wrapper.questions');
                $('.reuse-questions-form .show-questions').click(function () {
                    questionsWrapper.removeClass('collapsed');
                });
                $('.reuse-questions-form .hide-questions').click(function () {
                    questionsWrapper.addClass('collapsed');
                });

                dialog.show();

                var autocompeteInput = $('.reuse-questions-form .quizzes-input');
                var autocompeteContainer = $('.reuse-questions-form #quizzes-page-container');

                var getIds = function () {
                    quizIds = [];
                    autocompeteContainer.find('tr.quiz-row').each(function () {
                        quizIds.push($(this).attr('id'));
                    });

                    if (quizIds.length) {
                        reuseDialogBtn.prop('disabled', false);
                    } else {
                        reuseDialogBtn.prop('disabled', true);
                    }
                };

                self.bindQuizAutocomplete(autocompeteInput, autocompeteContainer, getIds);

                return false;
            });
        },

        bindQuizzesEdit: function () {
            var self = this;

            var views = self.table.find('.qqr-view');
            var edits = self.table.find('.qqr-edit');
            var inputs = edits.find('input');

            inputs.each(function () {
                var autocompeteInput = $(this);
                var autocompeteContainer = autocompeteInput.parent().find('.quizzes-page-container');
                self.bindQuizAutocomplete(autocompeteInput, autocompeteContainer, function () {});
            });

            var getInputValues = function (input) {
                var value = {};
                value.editContents = input.parent().find('.quizzes-page-container');
                value.html = value.editContents.html();
                value.links = value.editContents.find('a');
                value.ids = [];
                value.editContents.find('tr.quiz-row').each(function () {
                    value.ids.push($(this).attr('id'));
                });

                return value;
            };

            var input = inputs.filter(':visible');
            var prevValue = getInputValues(input);

            var cancelEditing = function() {
                input.val('');
                prevValue.editContents.html(prevValue.html);
                views.show();
                edits.hide();
            };

            var save = function() {
                var newValue = getInputValues(input);
                input.parents('td').find('.qqr-links').html('').append(newValue.links.clone());
                var addIds = $.grep(newValue.ids, function(el){return $.inArray(el, prevValue.ids) == -1});
                var removeIds = $.grep(prevValue.ids, function(el){return $.inArray(el, newValue.ids) == -1});
                var questionId = input.parents('tr').data('id');

                $.ajax({
                    type: 'POST',
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/quiz-question/remove-question",
                    data: {
                        pageIds: questionId,
                        quizIds: removeIds
                    },
                    error: QuizErrorHandler.showError
                });

                $.ajax({
                    type: 'POST',
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/quiz-question/add-questions",
                    data: {
                        questionIds: questionId,
                        quizIds: addIds
                    },
                    error: QuizErrorHandler.showError
                });

                prevValue = newValue;
                cancelEditing();
            };

            edits.click(function(e) {
                if (!$(e.target).is('.quiz-remove, .quiz-suggestion')) {
                    e.stopPropagation();
                }
            });

            views.click(function(e) {
                if ($(e.target).is('a')) {
                    return;
                }
                var parent = $(this);
                cancelEditing();

                parent.hide();
                input = parent.parent().find('.qqr-edit').show().find('input').focus();
                prevValue = getInputValues(input);

                return false;
            });

            edits.find('.cancel').click(cancelEditing);

            edits.find('.submit').click(function() {
                save();
                return false;
            });

            $(document).click(function() {
                cancelEditing();
            });
        },

        hideSavePanel: function() {
            var self = this;
            self.savePanel.hide();
            self.selects.add(self.table.find('input.qqr-select-all')).prop('disabled', false);
            self.endPoint.css('margin-bottom', '').hide();
            $(window).unbind('beforeunload.quiz-questions');
        },

        showReusePanel: function() {
            var self = this;
            self.endPoint.show();
            self.updatePanelPosition();
            self.reusePanel.show();
        },

        hideReusePanel: function() {
            var self = this;
            self.selects.prop('checked', false);
            self.table.find('input.qqr-select-all').prop('checked', false);
            $('.bulk-category-select').prop('checked', false);
            self.reusePanel.hide();
            self.randomInputs.not('[data-free]').prop('disabled', false);
            self.endPoint.css('margin-bottom', '').hide();
        },

        getRandomParams: function() {
            var self = this;
            var params = [];
            self.randomInputs.each(function() {
                params.push($(this).is(':checked'));
            });
            return params
        },

        updatePanelPosition: function() {
            var self = QuizQuestionsReport;
            var offset = self.endPoint.offset();

            if (!offset) return;
            var windowPosition = $(window).height() + $(window).scrollTop();
            var windowBottom = windowPosition - offset.top;
            self.panels.css({'bottom': Math.min(Math.max(5, windowBottom - 47), windowPosition - self.tableTop.offset().top - 86),
                            'left': offset.left,
                            'width': self.endPoint.width() - 12});
            if (windowBottom > 5) {
                self.endPoint.css('margin-bottom', Math.min(windowBottom - 5, 50) + 'px');
            } else {
                self.endPoint.css('margin-bottom', '');
            }
        },

        bindQuizAutocomplete: function (autocompeteInput, autocompeteContainer, callback) {
            var self = this;

            CQAutocomplete.init(autocompeteInput, function($suggestion) {
                if (autocompeteContainer.find('#' + $suggestion.data('key')).length == 0) {
                    autocompeteContainer.append(QuizQuestionsReportTemplate.page({
                        id: $suggestion.data('key'),
                        title: $suggestion.text(),
                        hint: $suggestion.attr('title')
                    }));

                    callback();
                }
            }, function(token, onSuccess, onError) {
                $.ajax({
                    type: 'GET',
                    cache: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/service/search/quizzes",
                    data: {
                        title: token,
                        restrictedIds: self.table.hasClass('index') ? '' : QuizCommons.getContentId()
                    },
                    dataType: 'json',
                    success: function(variants) {
                        var data = [];
                        $.each(variants, function(i, variant) {
                            if (autocompeteContainer.find('#quizzes-page-container #' + variant.key).length == 0) {
                                data.push(variant);
                            }
                        });
                        onSuccess(data);
                    },
                    error: function (errorResp) {
                        onError('Unable to find quizzes');
                    }
                });
            });

            $('.quiz-remove').die('click').live('click', function() {
                $(this).parents('.quiz-row').remove();
                callback();
                return false;
            });
        }
    };

    AJS.toInit(function() {
        QuizQuestionsReport.init();
        AJS.bind('quiz-questions-updated', function () {
            QuizQuestionsReport.init();
        });
    });
})(AJS.$);




