(function($) {
    AJS.toInit(function() {
        if ($('.page.quiz').length === 0 && $('body.content-preview').length === 0) {
            var inputs = $('.quiz-answer');
            var savePanel = $('#quiz-answers-save-changes');
            var container = $('.quiz-answers-container');

            var getAnswers = function() {
                var answers = [];
                inputs.each(function(i) {
                    if ($(this).is(':checked')) {
                        answers.push(i + 1);
                    }
                });
                return answers
            };
            var hidePanel = function() {
                savePanel.hide();
                container.css('margin-bottom', '');
                $(window).unbind('beforeunload.quiz-answers');
            };

            var prevAnswers = getAnswers();
            var newAnswers = prevAnswers;

            inputs.change(function() {
                newAnswers = getAnswers();
                if ($(prevAnswers).not(newAnswers).length > 0 || $(newAnswers).not(prevAnswers).length > 0) {
                    savePanel.show();
                    updatePanelPosition();
                    $(window).bind('beforeunload.quiz-answers', function() {
                        return AJS.I18n.getText("quiz.answers.changes.not-saved");
                    });
                } else {
                    hidePanel();
                }
            });

            $('#quiz-answers-cancel').click(function() {
                inputs.prop('checked', false);
                prevAnswers.forEach(function(n) {
                    inputs.eq(n - 1).prop('checked', true);
                });
                hidePanel();

                return false;
            });

            $('#quiz-answers-save').click(function() {
                $.ajax({
                    type: 'POST',
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/quiz-question/change-answers",
                    data: {
                        pageId: QuizCommons.getContentId(),
                        value: newAnswers.join(',')
                    },
                    success: function() {
                        hidePanel();
                        prevAnswers = newAnswers;
                    },
                    error: QuizErrorHandler.showError
                });

                return false;
            });

            var updatePanelPosition = function() {
                if (savePanel.css('display') == 'none') return;

                var windowBottom = $(window).height() + $(window).scrollTop() - container.offset().top - container.height();
                savePanel.css('bottom', Math.max(5, windowBottom - 47));
                savePanel.css('left', container.offset().left - 5);
                savePanel.css('right', $(window).width() - container.offset().left - container.width());
                if (windowBottom > 5) {
                    container.css('margin-bottom', Math.min(windowBottom - 5, 50) + 'px');
                } else {
                    container.css('margin-bottom', '');
                }
            };
            registerResizeEventListener('.quiz-answers-container', updatePanelPosition);
        }

        if ($('.free-text-answer').length) {
            $('.quiz-answer-text').each(function() {
                $(this).wrap("<ul><li></li></ul>");
            });
        }
    });
})(AJS.$);



