import initDueDateSettings from "../utils/due-date-settings";

(function($) {

    window.QuizAnswersReport = {

        init: function () {
            var self = this;
            self.content = $('.quiz-answers-report-content');
            self.table = $('.quiz-answers-report-table');
            self.tableWrapper = self.table.parents('.table-wrap');
            self.tbody = self.table.find('tbody');
            self.endPoint = self.content.find('.end-point');
            self.panel = $('#qar-panel');
            self.panelDD = $('#qar-dd');
            self.removeBtn = $('#remove-quiz-records');
            self.tableCheckBoxes = [];
            self.enrollActionsTrigger = $('#qar-trigger');

            self.bindShowActionsForSelectedRows();
            self.bindTablesorterInit();
            self.initCheckBoxes();
            self.bindCheckBoxes();
            self.bindRemove();
            self.bindAddAttempts();
            self.bindUpdateDueDate();
            self.bindCancel();
            self.bindLearnShare();
            self.bindExpandAttempts();
            self.bindRemindBtn();
            self.bindExport();
            self.makeTableScrollable();

            registerResizeEventListener('.quiz-answers-report-content', self.updatePanelPosition);
        },

        bindShowActionsForSelectedRows: function() {
            let self = this;

            self.panelDD.on({
                "aui-dropdown2-show": function() {
                    self.panelDD.css('top', (self.enrollActionsTrigger.offset().top - self.panelDD.height()) + 'px');
                }
            });
        },

        bindTablesorterInit: function () {
            var self = this;

            self.table.bind('tablesorter-initialized', function() {
                self.initCheckBoxes();
            });
        },

        initCheckBoxes: function () {
            var self = this;

            self.table.each(function (i) {
                self.tableCheckBoxes[i] = $(this).find('.record-checkbox');
            });

            self.checkBoxes = $(self.tableCheckBoxes).map(function () { return this.toArray(); } );

            TableSorterFixer.fix(self.table);
        },

        bindCheckBoxes: function () {
            var self = this;

            self.table.each(function (i) {
                $(this).find('#select-all-records').live('change', function() {
                    if ($(this).is(':checked')) {
                        self.tableCheckBoxes[i].attr('checked', 'checked');
                    } else {
                        self.tableCheckBoxes[i].attr('checked', false);
                    }

                    self.onCheckBoxesChange();
                });
            });

            self.checkBoxes.bind('change', function() {
                self.onCheckBoxesChange();
            });
        },

        onCheckBoxesChange: function() {
            var self = this;

            if (self.checkBoxes.filter(':checked').length) {
                self.showPanel();
            } else {
                self.hidePanel();
            }
        },

        bindRemove: function () {
            var self = this;
            self.removeBtn.click(function() {
                $(document).click();

                var dialog = new AJS.Dialog({
                    width: 500,
                    height: 180,
                    id: "delete-answers-dialog",
                    closeOnOutsideClick: false
                });

                dialog.addHeader(AJS.I18n.getText("quiz.report.dialog.delete.title"));
                dialog.addPanel('panel', "<div>" + AJS.I18n.getText("quiz.report.dialog.delete.body") + "</div>", 'delete-answers-dialog-panel');
                dialog.addButton(AJS.I18n.getText("quiz.report.dialog.delete.confirm"), function() {
                    submit.prop('disabled', true);
                    spinner.css('display', 'inline-block');
                    $.ajax({
                        type: 'POST',
                        cache: false,
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/service/answers/remove",
                        data: {
                            pageId: self.content.data('pageid'),
                            ids: self.getIds()
                        },
                        dataType: 'json',
                        success: function() {
                            var checked = self.checkBoxes.filter(':checked');
                            self.checkBoxes = self.checkBoxes.not(checked);
                            checked.parent().parent().remove();
                            self.hidePanel();

                            self.table.each(function (i) {
                                self.tableCheckBoxes[i] = self.tableCheckBoxes[i].not(checked);
                                if (self.tableCheckBoxes[i].length === 0) {
                                    self.content.find('.quiz-answers-report-empty, .quizzes-empty').eq(i).show();
                                    $(this).remove();
                                    $('#quiz-remind-participants').remove();
                                    $('.export-qa').remove();
                                }
                            });

                            self.table.trigger('update', false);
                            dialog.remove();
                        },
                        error: QuizErrorHandler.showError
                    });
                }, "delete-answers-dialog-save");
                dialog.addLink(AJS.I18n.getText("quiz.create-wizard.dialog.cancel"), function (dialog) {
                    dialog.remove();
                }, '#');


                var submit = $('.delete-answers-dialog-save');
                var spinner = $(QuizAnswersReportTemplate.spinner());
                submit.before(spinner);

                dialog.show();

                return false;
            });
        },

        bindAddAttempts: function() {
            var self = this;
            $('#qar-add-attempts').click(function() {
                $(document).click();

                var dialog = new AJS.Dialog({
                    width: 500,
                    height: 300,
                    id: "qar-add-attempts-dialog",
                    closeOnOutsideClick: false
                });

                dialog.addHeader(AJS.I18n.getText("quiz.share.add-attempts.dialog.header"));
                dialog.addPanel('panel', Quiz.addAttemptsDialog({data: {unenrolledUsers: [{}]}}), 'qar-add-attempts-panel');

                var input = $('#add-attempts');

                dialog.addButton(AJS.I18n.getText("quiz.share.add-attempts.dialog.add"), function() {
                    $.ajax({
                        type: 'POST',
                        cache: false,
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/service/records/add-attempts",
                        data: {
                            quizId: self.content.data('pageid'),
                            attempts: input.val(),
                            ids: self.getIds()
                        },
                        dataType: 'json',
                        success: function() {
                            QuizMessageHelper.showSuccessMsg(AJS.I18n.getText('quiz.report.add.attempts.success'));
                            dialog.remove();
                            location.reload();
                        },
                        error: QuizErrorHandler.showError
                    });
                    self.hidePanel();
                }, "qar-add-attempts-save");
                dialog.addLink(AJS.I18n.getText("quiz.create-wizard.dialog.cancel"), function (dialog) {
                    self.hidePanel();
                    dialog.remove();
                }, '#');

                var btn = $('.qar-add-attempts-save');

                input.bind('input', function () {
                    if (parseInt(input.val()) > 0) {
                        btn.prop('disabled', false);
                    } else {
                        btn.prop('disabled', true);
                    }
                });

                $('#show-add-attempts').remove();
                $('#hidden-add-attempts-container').show();

                dialog.show();

                return false;
            });
        },

        bindUpdateDueDate: function () {
            var self = this;
            $('#qar-update-due-date').click(function() {
                $(document).click();

                var settingsTable = $('quiz-settings-table');
                var dialog = $(QuizAnswersReportTemplate.dueDateDialog({
                    dueDate: settingsTable.data('due-date'),
                    dueDays: settingsTable.data('due-days'),
                    userDueDate: settingsTable.find('[data-view-type="due-date"]').text()
                }));
                initDueDateSettings(AJS, dialog);
                AJS.dialog2(dialog).show();
                dialog.find('.cancel').click(function () {
                    AJS.dialog2(dialog).hide();
                });
                dialog.find('.submit').click(function () {
                    $.ajax({
                        type: 'POST',
                        cache: false,
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/service/records/update-due-date",
                        data: {
                            quizId: self.content.data('pageid'),
                            dueDate: dialog.find('[data-type="due-date"]').val(),
                            dueDays: dialog.find('[data-type="due-days"]').val(),
                            ids: self.getIds()
                        },
                        dataType: 'json',
                        success: function() {
                            QuizMessageHelper.showSuccessMsg(AJS.I18n.getText('quiz.report.update.due-date.success'));
                            self.hidePanel();
                            dialog.remove();
                            location.reload();
                        },
                        error: QuizErrorHandler.showError
                    });

                    AJS.dialog2(dialog).hide();
                });

                return false;
            });
        },

        bindCancel: function () {
            var self = this;
            $('#qar-cancel').click(function () {
                self.hidePanel();
                $(document).click();
                return false;
            });
        },

        bindLearnShare: function () {
            $('#qar-learn-share').click(function() {
                var dialog = new AJS.Dialog({
                    width: 500,
                    height: 280,
                    id: "learn-share-answers-dialog",
                    closeOnOutsideClick: true
                });

                dialog.addHeader(AJS.I18n.getText("quiz.answers-report.share.dialog.title"));
                dialog.addPanel('panel', "<div>" + AJS.I18n.getText("quiz.answers-report.share.dialog.body", AJS.Meta.get('page-title')) + "</div>", 'learn-share-answers-dialog-panel');
                dialog.addLink(AJS.I18n.getText("close.name"), function (dialog) {
                    dialog.remove();
                }, '#');

                dialog.show();

                return false;
            });
        },

        bindExpandAttempts: function () {
            var self = this;

            self.table.find(".aui-iconfont-collapsed").click(function () {
                var tr = $(this).hide().parents('tr');
                tr.find('.qar-subcell').show();
                tr.find('.aui-iconfont-expanded').css('display', 'inline-block');
            });

            self.table.find(".aui-iconfont-expanded").click(function () {
                var tr = $(this).hide().parents('tr');
                tr.find('.qar-subcell').hide();
                tr.find('.aui-iconfont-collapsed').show();
            })
        },

        bindExport: function() {
            var enabled = true;
            var link = $('.export-qa:not(.export-preview)').click(function () {
                if (enabled) {
                    enabled = false;
                    link.attr('disabled', true);
                    var spinner = $('.quiz-export-spinner').css('display', '');
                    var checkDownload = function () {
                        if ($.cookie('quiz-csv')) {
                            $.cookie('quiz-csv', null);
                            link.attr('disabled', false);
                            spinner.hide();
                            enabled = true;
                        } else {
                            setTimeout(checkDownload, 500);
                        }
                    };

                    checkDownload();
                } else {
                    return false;
                }
            });
        },

        bindRemindBtn: function () {
            var self = this;

            $('#quiz-remind-participants').click(function () {
                var dialog = new AJS.Dialog({
                    width: 500,
                    height: 350,
                    id: "remind-dialog",
                    closeOnOutsideClick: false
                });

                dialog.addHeader(AJS.I18n.getText("quiz.answers-report.remind.dialog.title"));
                dialog.addPanel('panel', QuizAnswersReportTemplate.remindDialog(), 'remind-dialog-panel');
                dialog.addButton(AJS.I18n.getText("quiz.answers-report.remind.dialog.btn"), function() {
                    submit.prop('disabled', true);
                    spinner.css('display', 'inline-block');
                    $.ajax({
                        type: 'POST',
                        cache: false,
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/service/remind",
                        data: {
                            quizId: self.content.data('pageid'),
                            message: $('#quiz-remind-message').val()
                        },
                        dataType: 'json',
                        success: function() {
                            dialog.remove();
                            QuizMessageHelper.showSuccessMsg(AJS.I18n.getText('quiz.answers-report.remind.success'));
                        },
                        error: QuizErrorHandler.showError
                    });
                }, "remind-dialog-save");
                dialog.addLink(AJS.I18n.getText("quiz.create-wizard.dialog.cancel"), function (dialog) {
                    dialog.remove();
                }, '#');

                var submit = $('.remind-dialog-save');
                var spinner = $(QuizAnswersReportTemplate.spinner());
                submit.before(spinner);

                dialog.show();

                return false;
            });
        },

        makeTableScrollable: function () {
            $(".quiz-answers-report-table:not(.fixed-col)").each(function() {
                var table = $(this);
                if (table.find('.qar-fixed-column-border').length) {
                    table.find('th:first-child,td:first-child').each(function() {
                        var element = $(this);
                        element.addClass('column-fixed-left');
                        element.css('backgroundColor', getBackgroundColorForFixedCells(element));
                    });
                    table.addClass('fixed-col');
                    table.parent().bind('scroll.quiz-tf', function () {
                        var fht = table.parents('.fht-table-wrapper');
                        if (fht.length) {
                            var ths = table.find('th.fixed');
                            fht.find('.fht-thead th.fixed').each(function (i) {
                                $(this).css('left', ths.eq(i).css('left'));
                            });
                        }
                    });
                }
            }).bind('tablesorter-initialized', function() {
                var table = $(this);
                table.find('th .qar-fixed-column-border').each(function() {
                    var element = $(this);
                    element.parents('th:eq(0)').append(element);
                });
            });

            if (window.navigator.userAgent.indexOf("MSIE ") > 0 || !!navigator.userAgent.match(/Trident.*rv\:11\./)) {
                $('.qar-fixed-column-border.right, .qar-fixed-column-border.left').each(function() {
                    var element = $(this);
                    element.height(element.parents('th, td').eq(0).outerHeight() - 1);
                });
            }

            $('.qar-answer img').each(function() {
                var img = $(this);
                var height = img.height();
                var width = img.width();
                if (width > height) {
                    if (width > 200) {
                        img.css({width: '200px', height: 'auto'});
                    }
                } else if (height > 200) {
                    img.css({height: '200px', width: 'auto'});
                }
            });

            $('.qar-question-wrapper').each(function() {
                var container = $(this);
                while(this.scrollHeight > 120) {
                    container.text(container.text().substring(0, container.text().length - 2).trim() + '\u2026');
                }
            });
        },

        showPanel: function () {
            var self = this;
            self.endPoint.show();
            self.updatePanelPosition();
            self.panel.show();
        },

        hidePanel: function () {
            var self = this;
            self.panel.hide();
            self.checkBoxes.attr('checked', false);
            $('#select-all-records').attr('checked', false);
            self.endPoint.css('margin-bottom', '').hide();
        },

        updatePanelPosition: function() {
            var self = QuizAnswersReport;

            if (!self.endPoint.offset()) return;
            var windowPosition = $(window).height() + $(window).scrollTop();
            var windowBottom = windowPosition - self.endPoint.offset().top;
            var bottom = Math.min(Math.max(5, windowBottom - 47), windowPosition - self.tbody.offset().top - 43);
            self.panel.css({'bottom': bottom,
                'left': self.tableWrapper.offset().left,
                'width': self.tableWrapper.width() - 12});
            if (windowBottom > 5) {
                self.endPoint.css('margin-bottom', Math.min(windowBottom - 5, 50) + 'px');
            } else {
                self.endPoint.css('margin-bottom', '');
            }
        },

        getIds: function () {
            var self = QuizAnswersReport;
            var checked = self.checkBoxes.filter(':checked');
            var ids = [];
            checked.each(function() {
                ids.push($(this).attr('id'));
            });
            return ids;
        }
    };

    AJS.toInit(function() {
        QuizAnswersReport.init();
    });
})(AJS.$);

function getBackgroundColorForFixedCells(element) {
    var parent = element.parent();

    var elementBackground = element.css("background-color");
    elementBackground = (elementBackground == "transparent" || elementBackground == "rgba(0, 0, 0, 0)") ? null : elementBackground;

    var parentBackground = parent.css("background-color");
    parentBackground = (parentBackground == "transparent" || parentBackground == "rgba(0, 0, 0, 0)") ? null : parentBackground;

    var background = parentBackground ? parentBackground : "white";
    return elementBackground ? elementBackground : background;
}