AJS.toInit(function($){

    Confluence.Blueprint.setWizard('com.stiltsoft.confluence.quiz:create-question-template', function(wizard) {
        wizard.on("post-render.question-create", function(e, state) {
            $('#create-dialog').css('visibility', 'hidden');
            var quizId = $('.quiz-create-wizard').data('quizid');
            if (!quizId) {
                $.ajax({
                    type: 'GET',
                    cache: false,
                    async: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/quiz-question/parent-page",
                    data: {
                        pageId: state.wizardData.parentPageId
                    },
                    dataType: 'json',
                    success: function(data) {
                        if (data && !data.isEmpty) {
                            state.wizardData.parentPageId = data.id;
                            quizId = data.id;
                        }
                    }
                });

            }
            state.$container.find('#quizid').val(quizId);
            $('.create-dialog-create-button').click();
        });
    });

    function BPWithTitle(wizard) {
        wizard.on('submit.quiz-create submit.course-create', function(e, state) {
            var title = state.$container.find('#title');
            title.siblings(".error").html('');
            if (!state.pageData.title) {
                return false;
            }
            if (!Confluence.Blueprint.canCreatePage(state.wizardData.spaceKey, $.trim(state.pageData.title))) {
                title.focus().siblings(".error").html(AJS.I18n.getText("quiz.blueprint.form.page.error"));
                return false;
            }
        });

        wizard.on("post-render.quiz-create post-render.course-create", function(e, state) {
            var helpLink = e.namespace === 'course-create' ? Quiz.BP.helpCourse() : Quiz.BP.helpQuiz();
            $('#create-dialog .dialog-title').css('white-space', 'normal').append(helpLink);
            var btn = $('.create-dialog-create-button');
            var input = state.$container.find('#title');
            var validate = function() {
                btn.prop('disabled', input.val().trim() == '');
            };

            var data = state.wizardData.title || {};

            input.bind('propertychange keyup input paste', validate);
            state.$container.find('#courseid').val(data.courseId || '');
            state.$container.find('#sectionid').val(data.sectionId || '');
            input.val(data.title || '');

            btn.prop('disabled', true);
            validate();
        });
    }

    Confluence.Blueprint.setWizard('com.stiltsoft.confluence.quiz:create-quiz-template', BPWithTitle);

    Confluence.Blueprint.setWizard('com.stiltsoft.confluence.quiz:create-course-template', BPWithTitle);
});