(function($) {

    var TakeQuizBtnMacroJsOverride = function() {
    };

    TakeQuizBtnMacroJsOverride.prototype.beforeParamsSet = function(params) {
        $('#macro-browser-dialog .macro-desc .macro-doco-link').css('float', 'right').before('<br>')
            .before(AJS.I18n.getText("quiz.macros.feature-request"));

        var userKey = AJS.params.remoteUserKey;

        if (!userKey) {
            $.ajax({
                type: 'GET',
                cache: false,
                async: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/service/current-user-key",
                dataType: 'text',
                success: function(key) {
                    userKey = key;
                }
            });
        }

        if (params['author'] && userKey != params['author']) {
            $('#macro-param-div-quizzes').hide().before(QuizzesMacro.message({
                user: params['author-name'],
                userName: params['author-full-name'],
                hint: AJS.I18n.getText('quizzes.macro.message.2')
            }));
            Confluence.Binder.userHover();
            return params;
        } else {
            params['author'] = userKey;
            params['author-name'] = AJS.params.remoteUser;
            params['author-full-name'] = AJS.params.userDisplayName || AJS.params.currentUserFullname;
        }

        var autocomplete = $(QuizzesMacro.input({ph: AJS.I18n.getText('quizzes.macro.placeholder')}));
        var container = $(QuizzesMacro.pagesContainer());

        var input = $('#macro-param-quiz').hide().after(autocomplete);
        $('#macro-param-div-quiz').append(container);
        if (params['quizid']) {
            $.ajax({
                type: 'GET',
                cache: false,
                async: false,
                url: Confluence.getContextPath() + "/rest/api/content/" + params['quizid'],
                dataType: 'json',
                success: function(page) {
                    params['quiz'] = page.title;
                    autocomplete.val(page.title);
                }
            });
        }

        CQAutocomplete.init(autocomplete, function($suggestion) {
            params['quiz'] = $suggestion.text();
            autocomplete.val($suggestion.text());
            input.val($suggestion.text()).trigger('change');
            params['quizid'] = $suggestion.data('key');
        }, function(token, onSuccess, onError) {
            $.ajax({
                type: 'GET',
                cache: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/service/search/quizzes",
                data: {
                    title: token
                },
                dataType: 'json',
                success: function(variants) {
                    var data = [];
                    $.each(variants, function(i, variant) {
                        if ($('#quizzes-page-container #' + variant.key).length == 0) {
                            data.push(variant);
                        }
                    });
                    onSuccess(data);
                },
                error: function(errorResp) {
                    onError('Unable to find quizzes');
                }
            });
        });

        return params;
    };

    AJS.MacroBrowser.setMacroJsOverride("take-quiz-button", new TakeQuizBtnMacroJsOverride());

})(AJS.$);





