(function($) {

    var QuizElementMacroJsOverride = function() {
    };

    QuizElementMacroJsOverride.prototype.beforeParamsSet = function(params) {
        $('#macro-browser-dialog .macro-desc .macro-doco-link').css('float', 'right').before('<br>')
            .before(AJS.I18n.getText("quiz.macros.feature-request"));

        var typeSelect = $('#macro-param-type');
        typeSelect.find('option').each(function() {
            var option = $(this);
            switch (option.attr('value')) {
                case "Free text":
                    option.attr('title', AJS.I18n.getText('quiz-start-element.type.review.hint'));
                    break;
                case "Time limit":
                    option.attr('title', AJS.I18n.getText('quiz-start-element.type.timelimit.hint'));
                    break;
                case "Target":
                    option.attr('title', AJS.I18n.getText('quiz-start-element.type.target.hint'));
                    break;
                case "Total":
                    option.attr('title', AJS.I18n.getText('quiz-start-element.type.total.hint'));
                    break;
                case "Description":
                    option.attr('title', AJS.I18n.getText('quiz-start-element.type.description.hint'));
                    break;
                case "Due date":
                    option.attr('title', AJS.I18n.getText('quiz-start-element.type.due-date.hint'));
                    break;
            }
        });

        typeSelect.change(function() {
            typeSelect.attr('title', typeSelect.find('option:selected').attr('title'));
        }).attr('title', typeSelect.find('option:selected').attr('title'));

        return params;
    };

    AJS.MacroBrowser.setMacroJsOverride("quiz-start-element", new QuizElementMacroJsOverride());

})(AJS.$);

