(function($) {

    var QuizElementMacroJsOverride = function() {
    };

    QuizElementMacroJsOverride.prototype.beforeParamsSet = function(params) {
        $('#macro-browser-dialog .macro-desc .macro-doco-link').css('float', 'right').before('<br>')
            .before(AJS.I18n.getText("quiz.macros.feature-request"));

        var typeSelect = $('#macro-param-type');
        typeSelect.find('option').each(function() {
            var option = $(this);
            switch (option.attr('value')) {
                case "Correct":
                    option.attr('title', AJS.I18n.getText('quiz-result-element.type.correct.hint'));
                    break;
                case "Score":
                    option.attr('title', AJS.I18n.getText('quiz-result-element.type.score.hint'));
                    break;
                case "Target":
                    option.attr('title', AJS.I18n.getText('quiz-result-element.type.target.hint'));
                    break;
                case "Total":
                    option.attr('title', AJS.I18n.getText('quiz-result-element.type.total.hint'));
                    break;
                case "Participant":
                    option.attr('title', AJS.I18n.getText('quiz-result-element.type.participant.hint'));
                    break;
            }
        });

        typeSelect.change(function() {
            typeSelect.attr('title', typeSelect.find('option:selected').attr('title'));
        }).attr('title', typeSelect.find('option:selected').attr('title'));

        return params;
    };

    AJS.MacroBrowser.setMacroJsOverride("quiz-result-element", new QuizElementMacroJsOverride());

})(AJS.$);




