(function($) {

    window.QuizPagesMacroLib = {

        init: function(params) {
            $('#macro-browser-dialog .macro-desc .macro-doco-link').css('float', 'right').before('<br>')
                .before(AJS.I18n.getText("quiz.macros.feature-request"));

            params = EditMacroCheck.canEditQuizMacro(params);

            var autocomplete = $(QuizzesMacro.input({ph: AJS.I18n.getText('quizzes.macro.placeholder')}));
            var container = $(QuizzesMacro.pagesContainer());

            var input = $('#macro-param-quizzes').hide().after(autocomplete);
            $('#macro-param-div-quizzes').append(container);
            if (params['quizzes']) {
                $.each(params['quizzes'].split(','), function(i, id) {
                    $.ajax({
                        type: 'GET',
                        cache: false,
                        async: false,
                        url: Confluence.getContextPath() + "/rest/api/content/" + id,
                        dataType: 'json',
                        success: function(page) {
                            container.append(QuizzesMacro.page({id: id, title: page.title}));
                        }
                    });
                });
            }

            var updateIds = function() {
                var ids = [];
                $('.quiz-row').each(function() {
                    ids.push($(this).attr('id'));
                });
                input.val(ids.join(',')).trigger('change');
            };

            $('.quiz-remove').live('click', function() {
                var row = $(this).parents('.quiz-row').remove();
                updateIds();
            });

            CQAutocomplete.init(autocomplete, function($suggestion) {
                if ($('#' + $suggestion.data('key')).length == 0) {
                    container.append(QuizzesMacro.page({id: $suggestion.data('key'), title: $suggestion.text()}));
                    updateIds();
                }
            }, function(token, success, onError) {
                $.ajax({ //TODO вынести все одинаковые запросы на поиск квизов в одну функцию
                    type: 'GET',
                    cache: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/service/search/quizzes",
                    data: {
                        title: token,
                        restrictedIds: input.val().split(',')
                    },
                    dataType: 'json',
                    success: function(variants) {
                        var data = [];
                        $.each(variants, function(i, variant) {
                            if ($('#quizzes-page-container #' + variant.key).length == 0) {
                                data.push(variant);
                            }
                        });
                        success(data);
                    },
                    error: function (errorResp) {
                        onError('Unable to find quizzes');
                    }
                });
            });

            return params;
        }
    };

})(AJS.$);





