(function($) {

    var QuizAnswersMacroJsOverride = function() {
    };

    QuizAnswersMacroJsOverride.prototype.postPreview = function(iframe) {
        var contents = $(iframe).contents();
        var inputs = contents.find('.quiz-answer');
        if (inputs.length == 0) {
            return;
        }
        contents.find('.quiz-answers-container').prepend("<p><em>" + AJS.I18n.getText("quiz.answers.macro.preview.hint") +"</em></p>");
        var answersInput = $('#macro-param-answers');

        document.getElementById('macro-preview-iframe').contentWindow.AJS.$(".quiz-answer").bind('change', function() {
            var answers = [];
            inputs.each(function(i, input) {
                if ($(input).is(':checked')) {
                    answers.push(i + 1);
                }
            });
            answersInput.val(answers.join(','));
        });

        contents.find(".quiz-answers-container").contents().filter(function() {
            return this.nodeType == 3 && this.data.trim().length == 0;
        }).remove();
    };

    QuizAnswersMacroJsOverride.prototype.beforeParamsRetrieved = function(params) {
        var randomContainer = $('#macro-param-div-random');
        var typeInput = $('#macro-param-type');
        if (params["type"] === QUESTION_TYPE_NAMES.FREE_TEXT || params['type'] === QUESTION_TYPE_NAMES.AUTO_CHECKED_FREE_TEXT) {
            randomContainer.hide();
        }

        typeInput.change(function() {
            $('#macro-browser-preview-link').click();
            if ($(this).val() === QUESTION_TYPE_NAMES.FREE_TEXT || $(this).val() === QUESTION_TYPE_NAMES.AUTO_CHECKED_FREE_TEXT) {
                randomContainer.fadeOut();
            } else {
                randomContainer.fadeIn();
            }
        });

        typeInput.find('option').each(function() {
            var opt = $(this);
            switch (opt.val()) {
                case QUESTION_TYPE_NAMES.SINGLE_CHOICE:
                    opt.text(AJS.I18n.getText("quiz.create-wizard.dialog.type.single"));
                    break;
                case QUESTION_TYPE_NAMES.MULTIPLE_CHOICE:
                    opt.text(AJS.I18n.getText("quiz.create-wizard.dialog.type.multiple"));
                    break;
                case QUESTION_TYPE_NAMES.FREE_TEXT:
                    opt.text(AJS.I18n.getText("quiz.create-wizard.dialog.type.free-text"));
                    break;
                case QUESTION_TYPE_NAMES.AUTO_CHECKED_FREE_TEXT:
                    opt.text(AJS.I18n.getText("quiz.create-wizard.dialog.type.auto-checked-free-text"));
                    break;
            }
        });

        return params;
    };

    QuizAnswersMacroJsOverride.prototype.beforeParamsSet = function(params) {
        $('#macro-browser-dialog .macro-desc .macro-doco-link').css('float', 'right').before('<br>')
            .before(AJS.I18n.getText("quiz.macros.feature-request"));

        return params;
    };

    AJS.MacroBrowser.setMacroJsOverride("quiz-answers", new QuizAnswersMacroJsOverride());

})(AJS.$);



