(function($) {
    window.EditMacroCheck = {

        canEditCourseReportMacro: function(macroParams) {
            var self = this;
            var courseEntityParams = {url: Confluence.getContextPath() + "/rest/quiz/1.0/course/can-edit-courses",
                                    name: 'courses',
                                    hint: AJS.I18n.getText('course.macro.message.2')};
            return self.check(macroParams, courseEntityParams);
        },

        canEditQuizMacro: function(macroParams) {
            var self = this;
            var quizEntityParams = {url: Confluence.getContextPath() + "/rest/quiz/1.0/service/can-edit-quizzes",
                                    name: 'quizzes',
                                    hint: AJS.I18n.getText('quizzes.macro.message.2')};
            return self.check(macroParams, quizEntityParams);
        },

        check: function(macroParams, entityParams) {
            var userKey = AJS.params.remoteUserKey;

            if (!userKey) {
                $.ajax({
                    type: 'GET',
                    cache: false,
                    async: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/service/current-user-key",
                    dataType: 'text',
                    success: function(key) {
                        userKey = key;
                    }
                });
            }

            var canEdit = !macroParams['author'] || userKey === macroParams['author'];

            if (!canEdit) {
                $.ajax({
                    type: 'GET',
                    cache: false,
                    async: false,
                    url: entityParams.url,
                    data: {
                        ids: macroParams[entityParams.name] ? macroParams[entityParams.name].split(',') : [],
                        author: macroParams['author']
                    },
                    dataType: 'text',
                    success: function(data) {
                        canEdit = data === 'true';
                    }
                });
            }

            if (!canEdit) {
                $('#macro-param-div-' + entityParams.name).hide().before(QuizzesMacro.message({
                    user: macroParams['author-name'],
                    userName: macroParams['author-full-name'],
                    hint: entityParams.hint
                }));
                Confluence.Binder.userHover();
            } else {
                macroParams['author'] = userKey;
                macroParams['author-name'] = AJS.params.remoteUser;
                macroParams['author-full-name'] = AJS.params.userDisplayName || AJS.params.currentUserFullname;
            }

            return macroParams;
        }
    };


})(AJS.$);